/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.WorksBehaviour;
import ca.bradj.questown.jobs.requests.WorkRequest;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class TownVillagers {
    @Nullable
    public static JobID getPreferredWork(JobID villagerCurrentJob, Predicate<JobID> canFitInDay, Predicate<JobID> canAlwaysStart, ImmutableList<WorkRequest> requestedResults, WorksBehaviour.TownData td) {
        ArrayList<JobID> preference = new ArrayList<JobID>((Collection<JobID>)ServerJobsRegistry.getPreferredWorkIds(villagerCurrentJob));
        return TownVillagers.chooseFromList(canFitInDay, canAlwaysStart, requestedResults, td, preference);
    }

    @Nullable
    public static JobID chooseFromList(Predicate<JobID> canFitInDay, Predicate<JobID> canAlwaysStart, ImmutableList<WorkRequest> requestedResults, WorksBehaviour.TownData td, Collection<JobID> preferenceIn) {
        ArrayList<JobID> preference = new ArrayList<JobID>(preferenceIn);
        Collections.shuffle(preference);
        for (JobID p : preference) {
            if (canAlwaysStart.test(p)) {
                return p;
            }
            if (!canFitInDay.test(p)) continue;
            List<Ingredient> i = requestedResults.stream().map(WorkRequest::asIngredient).toList();
            for (Ingredient requestedResult : i) {
                if (!ServerJobsRegistry.canSatisfy(td, p, requestedResult)) continue;
                return p;
            }
        }
        return null;
    }
}

