/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.core.Pair;
import ca.bradj.questown.core.UtilClean;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class VillagerLearningHandle<JOB_ID> {
    private final Collection<JOB_ID> townKnownJobs = new ArrayList<JOB_ID>();
    private final BiPredicate<JOB_ID, JOB_ID> isParentOf;
    private final Supplier<ImmutableList<JOB_ID>> allShuffled;
    private final int maxAttemptsToLearn;
    private final Predicate<JOB_ID> isParentUnlocked;
    private ImmutableMap<JOB_ID, ImmutableList<JOB_ID>> precalculated;
    private LinkedBlockingQueue<Pair<Collection<JOB_ID>, Consumer<ImmutableList<Pair<JOB_ID, JOB_ID>>>>> requesters = new LinkedBlockingQueue();

    public VillagerLearningHandle(Supplier<ImmutableSet<JOB_ID>> allJobs, Function<ImmutableSet<JOB_ID>, ImmutableList<JOB_ID>> shuffle, BiPredicate<JOB_ID, JOB_ID> isParentOf, Predicate<JOB_ID> isParentUnlocked, int maxAttemptsToLearn) {
        this.allShuffled = () -> (ImmutableList)shuffle.apply((ImmutableSet)allJobs.get());
        this.isParentOf = isParentOf;
        this.maxAttemptsToLearn = maxAttemptsToLearn;
        this.isParentUnlocked = isParentUnlocked;
    }

    public void init(Collection<JOB_ID> townKnownJobs) {
        this.townKnownJobs.addAll(townKnownJobs);
    }

    public boolean tick(Collection<JOB_ID> villagerJobs) {
        if (this.precalculated != null && !this.requesters.isEmpty()) {
            Pair next = (Pair)this.requesters.remove();
            ImmutableList.Builder b = ImmutableList.builder();
            for (Object jobId : (Collection)next.a()) {
                b.addAll(this.getNextJobAwareness(jobId).stream().map(v -> new Pair<Object, Object>(jobId, v)).toList());
            }
            ((Consumer)next.b()).accept(b.build());
            this.precalculated = ImmutableMap.of();
            return false;
        }
        ImmutableList<JOB_ID> shuffled = this.allShuffled.get();
        ArrayList<JOB_ID> uniqueRoots = new ArrayList<JOB_ID>(villagerJobs);
        HashMap<JOB_ID, ArrayList<JOB_ID>> precalculated = new HashMap<JOB_ID, ArrayList<JOB_ID>>();
        boolean changed = false;
        block1: for (Object uniqueRoot : uniqueRoots) {
            ImmutableList<JOB_ID> already;
            if (this.precalculated != null && this.precalculated.keySet().stream().anyMatch(v -> v.equals(uniqueRoot)) && !(already = this.getNextJobAwareness(uniqueRoot)).isEmpty()) {
                precalculated.put(uniqueRoot, new ArrayList<JOB_ID>(already));
                continue;
            }
            int attemptsUsed = 0;
            for (Object jobId : shuffled) {
                if (attemptsUsed >= this.maxAttemptsToLearn) continue block1;
                if (uniqueRoot.equals(jobId) || !this.isParentOf.test(uniqueRoot, jobId)) continue;
                ++attemptsUsed;
                if (this.townKnownJobs.contains(jobId)) continue;
                List cur = (List)UtilClean.getOrDefault(precalculated, uniqueRoot, new ArrayList());
                if (cur.size() >= this.maxAttemptsToLearn) continue block1;
                if (cur.contains(jobId)) continue;
                UtilClean.addAllOrInitializeList(precalculated, uniqueRoot, ImmutableList.of(jobId));
                changed = true;
            }
        }
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry e : precalculated.entrySet()) {
            b.put(e.getKey(), (Object)ImmutableList.copyOf((Collection)((Collection)e.getValue())));
        }
        this.precalculated = b.build();
        return changed;
    }

    public ImmutableList<JOB_ID> getNextJobAwareness(JOB_ID jobForRoot) {
        return UtilClean.getOrDefaultCollectionByKeyPredicate(this.precalculated, k -> k.equals(jobForRoot), ImmutableList.of());
    }

    public ImmutableMap<JOB_ID, ImmutableList<JOB_ID>> getNextJobAwarenesses() {
        return this.precalculated;
    }

    public void requestKnowledge(Collection<JOB_ID> jobID, Consumer<ImmutableList<Pair<JOB_ID, JOB_ID>>> o) {
        this.requesters.add(new Pair<Collection<JOB_ID>, Consumer<ImmutableList<Pair<JOB_ID, JOB_ID>>>>(jobID, o));
    }
}

