/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town;

import ca.bradj.questown.blocks.FalseDoorBlock;
import ca.bradj.questown.blocks.FalseWallBlock;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.space.Position;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class WallDetection {
    public static WallDetection INSTANCE = new WallDetection();

    public static boolean IsWall(ServerLevel level, Position dp, int y) {
        BlockPos bp = Positions.ToBlock((Position)dp, (int)y);
        BlockPos abp = bp.m_7494_();
        BlockState blockState = level.m_8055_(bp);
        if (blockState.m_60734_() instanceof FalseWallBlock || blockState.m_60734_() instanceof FalseDoorBlock) {
            return true;
        }
        if (WallDetection.IsEmpty(level, dp, y)) {
            return false;
        }
        BlockState aboveBlockState = level.m_8055_(abp);
        if (blockState.m_60795_() || aboveBlockState.m_60795_()) {
            return false;
        }
        if (blockState.m_60808_((BlockGetter)level, bp).m_83281_() || aboveBlockState.m_60808_((BlockGetter)level, abp).m_83281_()) {
            return false;
        }
        if (WallDetection.isSolid(bp, (Level)level, blockState) && WallDetection.isSolid(abp, (Level)level, aboveBlockState)) {
            return true;
        }
        return WallDetection.IsDoor(level, dp, y);
    }

    public static boolean IsEmpty(ServerLevel level, Position dp, int y) {
        BlockPos bp = Positions.ToBlock((Position)dp, (int)y);
        BlockPos abp = bp.m_7494_();
        boolean empty = level.m_46859_(bp);
        boolean emptyAbove = level.m_46859_(abp);
        return empty || emptyAbove;
    }

    public static boolean IsDoor(ServerLevel level, Position dp, int y) {
        BlockState bs = level.m_8055_(Positions.ToBlock((Position)dp, (int)y));
        if (bs.m_60734_() instanceof FalseDoorBlock) {
            return true;
        }
        return bs.m_60734_() instanceof DoorBlock && DoubleBlockHalf.LOWER.equals(bs.m_61145_((Property)DoorBlock.f_52730_).orElse(null));
    }

    public static boolean isSolid(BlockPos bp, Level level, BlockState blockState) {
        if (blockState.m_60734_() instanceof AbstractGlassBlock || blockState.m_60734_() instanceof IronBarsBlock) {
            return true;
        }
        if (blockState.m_60734_() instanceof StairBlock) {
            return false;
        }
        return blockState.m_60808_((BlockGetter)level, bp).m_83215_().m_82309_() >= 1.0 && !blockState.m_60631_((BlockGetter)level, bp) && !blockState.m_60812_((BlockGetter)level, bp).m_83281_();
    }
}

