/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.econ;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.gui.ItemEconomicsData;
import ca.bradj.questown.town.quests.RoomNeed;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoMCEconomics {
    final Queue<UnmetNeed> unmetNeedsRecord = NoMCEconomics.initQueue();
    final Queue<UnmetNeed> unmetRoomsRecord = NoMCEconomics.initQueue();
    boolean needAggregate;
    private Map<UUID, ImmutableList<ItemEconomicsData>> aggregated = ImmutableMap.of();
    private ImmutableList<ItemEconomicsData> aggregatedAll = ImmutableList.of();
    private ImmutableList<RoomNeed<String>> roomsAll = ImmutableList.of();

    @NotNull
    private static EvictingQueue<UnmetNeed> initQueue() {
        return EvictingQueue.create((int)((Integer)Config.ECONOMIC_RECORDS_DEPTH.get()));
    }

    public static ImmutableMap<UUID, ImmutableList<ItemEconomicsData>> aggregateForUI(Collection<UnmetNeed> unmetNeedsRecord) {
        Map<UUID, Map<String, Integer>> map = NoMCEconomics.generateCounts(unmetNeedsRecord);
        return NoMCEconomics.aggregateCounts(map);
    }

    @NotNull
    private static ImmutableMap<UUID, ImmutableList<ItemEconomicsData>> aggregateCounts(Map<UUID, Map<String, Integer>> map) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<UUID, Map<String, Integer>> villagerMap : map.entrySet()) {
            ImmutableList.Builder b2 = ImmutableList.builder();
            for (Map.Entry<String, Integer> reqMap : villagerMap.getValue().entrySet()) {
                b2.add((Object)new ItemEconomicsData(reqMap.getKey(), reqMap.getValue()));
            }
            b.put((Object)villagerMap.getKey(), (Object)b2.build());
        }
        return b.build();
    }

    public static ImmutableList<RoomNeed<String>> aggregateRooms(Collection<UnmetNeed> data) {
        Map<UUID, Map<String, Integer>> map = NoMCEconomics.generateCounts(data);
        HashMap needsOut = new HashMap();
        for (Map.Entry<UUID, Map<String, Integer>> villagerMap : map.entrySet()) {
            for (Map.Entry<String, Integer> reqMap : villagerMap.getValue().entrySet()) {
                String k = reqMap.getKey();
                RoomNeed current = (RoomNeed)UtilClean.getOrDefault(needsOut, k, new RoomNeed<String>(k, 0, 0));
                RoomNeed newVal = current.withVillagers(current.villagersWhoNeed() + 1).withTimes(current.timesNeeded() + reqMap.getValue());
                needsOut.put(k, newVal);
            }
        }
        return ImmutableList.copyOf(needsOut.values());
    }

    @NotNull
    private static Map<UUID, Map<String, Integer>> generateCounts(Collection<UnmetNeed> unmetNeedsRecord) {
        HashMap<UUID, Map<String, Integer>> map = new HashMap<UUID, Map<String, Integer>>();
        for (UnmetNeed unmetNeed : unmetNeedsRecord) {
            map.compute(unmetNeed.villager(), (u, m) -> {
                if (m == null) {
                    HashMap<String, Integer> om = new HashMap<String, Integer>();
                    om.put(unmetNeed.request(), 1);
                    return om;
                }
                m.compute(unmetNeed.request(), (k, v) -> v == null ? 1 : v + 1);
                return m;
            });
        }
        return map;
    }

    public boolean update() {
        if (!this.needAggregate) {
            return false;
        }
        this.aggregated = NoMCEconomics.aggregateForUI(this.unmetNeedsRecord);
        this.aggregatedAll = this.buildOverallData();
        this.roomsAll = NoMCEconomics.aggregateRooms(this.unmetRoomsRecord);
        return true;
    }

    @Nullable
    private ImmutableList<ItemEconomicsData> buildOverallData() {
        HashMap<String, Integer> b = new HashMap<String, Integer>();
        for (ImmutableList<ItemEconomicsData> v : this.aggregated.values()) {
            for (ItemEconomicsData i : v) {
                b.compute(i.ingredientKey(), (k, vv) -> vv == null ? i.timesNeeded() : vv + i.timesNeeded());
            }
        }
        UUID standIn = UUID.randomUUID();
        ImmutableMap<UUID, ImmutableList<ItemEconomicsData>> x = NoMCEconomics.aggregateCounts((Map<UUID, Map<String, Integer>>)ImmutableMap.of((Object)standIn, b));
        ImmutableList aggregatedAll1 = (ImmutableList)x.get(standIn);
        return aggregatedAll1;
    }

    public void registerUnmetNeed(long tick, UUID villagerId, String requested) {
        this.unmetNeedsRecord.add(new UnmetNeed(tick, villagerId, requested));
        this.needAggregate = true;
    }

    public void registerUnmetRoom(long tick, UUID villagerId, String requested) {
        this.unmetRoomsRecord.add(new UnmetNeed(tick, villagerId, requested));
        this.needAggregate = true;
    }

    public ImmutableList<ItemEconomicsData> getAggregatedItems(@Nullable UUID villagerId) {
        return NoMCEconomics.getAggregated(this.aggregatedAll, this.aggregated, villagerId);
    }

    public Collection<RoomNeed<String>> getAggregatedRooms() {
        return this.roomsAll;
    }

    private static <S extends Needable> ImmutableList<S> getAggregated(List<S> all, Map<UUID, ? extends List<S>> allSplitByVillager, @Nullable UUID villagerId) {
        List<S> l = all;
        if (villagerId != null) {
            l = UtilClean.getOrDefaultCollection(allSplitByVillager, villagerId, ImmutableList.of());
        }
        return ImmutableList.copyOf(l.stream().sorted((a, b) -> Integer.compare(b.timesNeeded(), a.timesNeeded())).toList());
    }

    public record UnmetNeed(long tick, UUID villager, String request) {
    }

    public static interface Needable {
        public int timesNeeded();
    }
}

