/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.econ;

import ca.bradj.questown.town.econ.NoMCEconomics;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class TownEconomicsSerializer {
    public static final TownEconomicsSerializer INSTANCE = new TownEconomicsSerializer();
    public static final String NBT_REQUEST = "request";
    public static final String NBT_VILLAGER = "villager";
    public static final String NBT_TICK = "tick";
    public static final String NBT_NEEDS = "needs";
    public static final String NBT_ROOMS = "rooms";

    public CompoundTag serialize(NoMCEconomics econ) {
        CompoundTag tag = new CompoundTag();
        ListTag needs = new ListTag();
        for (NoMCEconomics.UnmetNeed unmetNeed : econ.unmetNeedsRecord) {
            CompoundTag t = new CompoundTag();
            t.m_128359_(NBT_REQUEST, unmetNeed.request());
            t.m_128362_(NBT_VILLAGER, unmetNeed.villager());
            t.m_128356_(NBT_TICK, unmetNeed.tick());
            needs.add((Object)t);
        }
        tag.m_128365_(NBT_NEEDS, (Tag)needs);
        ListTag rooms = new ListTag();
        for (NoMCEconomics.UnmetNeed unmetNeed : econ.unmetRoomsRecord) {
            CompoundTag t = new CompoundTag();
            t.m_128359_(NBT_REQUEST, unmetNeed.request());
            t.m_128362_(NBT_VILLAGER, unmetNeed.villager());
            t.m_128356_(NBT_TICK, unmetNeed.tick());
            rooms.add((Object)t);
        }
        tag.m_128365_(NBT_ROOMS, (Tag)rooms);
        return tag;
    }

    public void deserialize(NoMCEconomics econ, CompoundTag tag) {
        ListTag needs = tag.m_128437_(NBT_NEEDS, 10);
        needs.forEach(t -> {
            CompoundTag tt = (CompoundTag)t;
            String req = tt.m_128461_(NBT_REQUEST);
            UUID vil = tt.m_128342_(NBT_VILLAGER);
            long tic = tt.m_128454_(NBT_TICK);
            econ.registerUnmetNeed(tic, vil, req);
        });
        ListTag rooms = tag.m_128437_(NBT_ROOMS, 10);
        rooms.forEach(t -> {
            CompoundTag tt = (CompoundTag)t;
            String req = tt.m_128461_(NBT_REQUEST);
            UUID vil = tt.m_128342_(NBT_VILLAGER);
            long tic = tt.m_128454_(NBT_TICK);
            econ.registerUnmetRoom(tic, vil, req);
        });
        econ.needAggregate = true;
    }
}

