/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.init.items.ItemsInit;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TownFlagBOPItemHandler
implements IItemHandler {
    private final TownFlagBlockEntity town;

    public TownFlagBOPItemHandler(TownFlagBlockEntity town) {
        this.town = town;
    }

    public static void eject(TownFlagBlockEntity flag, ServerPlayer recipient) {
        --flag.bopCount;
        flag.m_6596_();
        ItemStack v = ((Item)ItemsInit.BLOCK_OF_PROGRESS.get()).m_7968_();
        BlockPos bp = flag.getTownFlagBasePos();
        flag.messages.broadcastMessage("messages.player.took_bop", recipient.m_7755_(), ((Item)ItemsInit.BLOCK_OF_PROGRESS.get()).m_7968_(), Util.getTinyString(bp));
        if (recipient.m_150109_().m_36054_(v)) {
            recipient.m_150109_().m_6596_();
            recipient.f_36095_.m_38946_();
            return;
        }
        ServerLevel level = flag.getServerLevel();
        bp = bp.m_121945_(Compat.getRandomHorizontal(level));
        ItemEntity item = new ItemEntity((Level)level, (double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), v);
        level.m_7967_((Entity)item);
    }

    public int getSlots() {
        return 64;
    }

    @NotNull
    public ItemStack getStackInSlot(int i) {
        if (i >= this.town.bopCount) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)ItemsInit.BLOCK_OF_PROGRESS.get());
    }

    @NotNull
    public ItemStack insertItem(int i, @NotNull ItemStack itemStack, boolean simulate) {
        if (!this.isItemValid(i, itemStack)) {
            return itemStack;
        }
        itemStack.m_41774_(1);
        if (!simulate) {
            ++this.town.bopCount;
            QT.FLAG_LOGGER.debug("Flag now contains {} BOPs", this.town.bopCount);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack extractItem(int i, int i1, boolean b) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int i) {
        return 1;
    }

    public boolean isItemValid(int i, @NotNull ItemStack itemStack) {
        if (i >= this.getSlots()) {
            return false;
        }
        if (i < this.town.bopCount) {
            return false;
        }
        return itemStack.m_150930_((Item)ItemsInit.BLOCK_OF_PROGRESS.get());
    }
}

