/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.QT;
import ca.bradj.questown.blocks.RoomBlock;
import ca.bradj.questown.blocks.WelcomeMatBlock;
import ca.bradj.questown.town.TownFlagInitialization;
import ca.bradj.questown.town.TownHealingHandle;
import ca.bradj.questown.town.TownKnowledgeStore;
import ca.bradj.questown.town.TownPois;
import ca.bradj.questown.town.WelcomeMatsSerializer;
import ca.bradj.questown.town.econ.TownEconomicsSerializer;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.entity.TownQuestsHandle;
import ca.bradj.questown.town.entity.TownRoomsHandle;
import ca.bradj.questown.town.entity.TownVillagerHandle;
import ca.bradj.questown.town.entity.TownWorkHandle;
import ca.bradj.questown.town.quests.MCMorningRewards;
import ca.bradj.questown.town.quests.MCQuestBatches;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TownFlagInitializationImpl
implements TownFlagInitialization {
    private final TownFlagBlockEntity flag;
    private static final ImmutableList<Class<?>> LEGACY_BLOCKS = ImmutableList.of(WelcomeMatBlock.class);

    public TownFlagInitializationImpl(TownFlagBlockEntity flag) {
        this.flag = flag;
    }

    @Override
    public TownRoomsHandle getRoomsHandle() {
        return this.flag.roomsHandle;
    }

    @Override
    public void setUpQuestsForNewlyPlacedFlag() {
        this.flag.setUpQuestsForNewlyPlacedFlag();
    }

    @Override
    public void setInitializedQuests(boolean b) {
        this.flag.isInitializedQuests = b;
    }

    @Override
    public TownQuestsHandle getQuests() {
        return this.flag.questsHandle;
    }

    @Override
    public MCMorningRewards getMorningRewards() {
        return this.flag.morningRewards;
    }

    @Override
    public TownPois getPOIs() {
        return this.flag.pois;
    }

    @Override
    public TownKnowledgeStore getKnowledge() {
        return this.flag.knowledgeHandle;
    }

    @Override
    public TownVillagerHandle getVillagers() {
        return this.flag.villagerHandle;
    }

    @Override
    public TownHealingHandle getHealing() {
        return this.flag.healing;
    }

    @Override
    public MCQuestBatches getQuestBatches() {
        return this.flag.quests.questBatches;
    }

    @Override
    public TownWorkHandle getWorkHandle() {
        return this.flag.workHandle;
    }

    @Override
    public CompoundTag serializeBOP() {
        CompoundTag t = new CompoundTag();
        t.m_128405_("count", this.flag.bopCount);
        return t;
    }

    @Override
    public void initializeBOP(CompoundTag tag) {
        this.flag.bopCount = tag.m_128451_("count");
    }

    @Override
    public CompoundTag serializeBlockRooms() {
        Object allRooms = this.flag.roomsHandle.blockRooms();
        ServerLevel sl = this.flag.getServerLevel();
        allRooms = allRooms.stream().filter(v -> !TownFlagInitializationImpl.isLegacy(v, sl)).toList();
        return WelcomeMatsSerializer.INSTANCE.serializeNBT((Collection<BlockPos>)allRooms, "pos");
    }

    private static boolean isLegacy(BlockPos v, ServerLevel sl) {
        Block block = sl.m_8055_(v).m_60734_();
        return LEGACY_BLOCKS.stream().anyMatch(c -> c.isInstance(block));
    }

    @Override
    public boolean initBlockRooms(CompoundTag tag, TownFlagBlockEntity t) {
        ServerLevel sl = t.getServerLevel();
        if (sl == null) {
            QT.FLAG_LOGGER.error("Cannot initialize block rooms, server level is null.", new Object[0]);
            return false;
        }
        Collection<BlockPos> l = WelcomeMatsSerializer.INSTANCE.deserializeNBT(tag, "pos");
        for (BlockPos blockPos : l) {
            if (TownFlagInitializationImpl.isLegacy(blockPos, sl)) continue;
            BlockState current = sl.m_8055_(blockPos);
            if (current.m_60795_()) {
                QT.FLAG_LOGGER.warn("Block no longer exists. Lost block-room at {}", blockPos);
                continue;
            }
            Block block = current.m_60734_();
            if (!(block instanceof RoomBlock)) {
                QT.FLAG_LOGGER.warn("Block is not a room block. Lost block-room at {}", blockPos);
                continue;
            }
            RoomBlock rb = (RoomBlock)block;
            t.initializer().getRoomsHandle().registerBlockAsRoom(RoomBlock.getRoomId(rb), blockPos);
        }
        QT.FLAG_LOGGER.debug("Initialized block rooms from {}", tag);
        return true;
    }

    @Override
    public CompoundTag serializeBonusGiven() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128379_("value", this.flag.givenBonusFood);
        return compoundTag;
    }

    @Override
    public boolean initEconomics(CompoundTag tag) {
        TownEconomicsSerializer.INSTANCE.deserialize(this.flag.getEconomicsHandle(), tag);
        return true;
    }

    @Override
    public void initEconomicsForNewFlag() {
    }

    @Override
    public CompoundTag serializeEconomics() {
        return TownEconomicsSerializer.INSTANCE.serialize(this.flag.getEconomicsHandle());
    }
}

