/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.commands.DebugLogArgument;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.integration.minecraft.MCContainer;
import ca.bradj.questown.integration.minecraft.MCHeldItem;
import ca.bradj.questown.integration.minecraft.MCTownItem;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.integration.minecraft.TownStateSerializer;
import ca.bradj.questown.jobs.ImmutableSnapshot;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.leaver.ContainerTarget;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.TownContainers;
import ca.bradj.questown.town.TownState;
import ca.bradj.questown.town.Warper;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.space.Position;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownFlagState {
    static final String NBT_TIME_WARP_REFERENCE_TICK = String.format("%s_last_tick", "questown");
    static final String NBT_TOWN_STATE = String.format("%s_town_state", "questown");
    private final TownFlagBlockEntity parent;
    private boolean initialized = false;
    private final Stack<Function<TownFlagBlockEntity, MCTownState>> townInit = new Stack();
    private final Map<BlockPos, Integer> listenedBlocks = new HashMap<BlockPos, Integer>();
    private final ArrayList<Integer> times = new ArrayList();

    public TownFlagState(TownFlagBlockEntity parent) {
        this.parent = parent;
    }

    @Nullable
    MCTownState captureState() {
        ImmutableList.Builder vB = ImmutableList.builder();
        for (LivingEntity entity : this.parent.getVillagerHandle().entities()) {
            if (!(entity instanceof VisitorMobEntity)) continue;
            if (!((VisitorMobEntity)entity).isInitialized()) {
                return null;
            }
            Vec3 pos = entity.m_20182_();
            ImmutableSnapshot<MCHeldItem, ?> snapshot = ((VisitorMobEntity)entity).getJobJournalSnapshot();
            TownState.VillagerData<MCHeldItem> data = new TownState.VillagerData<MCHeldItem>(pos.f_82479_, pos.f_82480_, pos.f_82481_, snapshot, entity.m_20148_());
            vB.add(data);
        }
        long dayTime = this.parent.getServerLevel().m_46468_();
        return new MCTownState((List<TownState.VillagerData<MCHeldItem>>)vB.build(), TownContainers.findAllContainersMatching(this.parent, item -> true).toList(), this.parent.getWorkStatusHandle(null).getAll(), (ImmutableMap<BlockPos, Integer>)ImmutableMap.of(), this.parent.getWelcomeMats(), (ImmutableList<MCHeldItem>)ImmutableList.of(), (ImmutableMap<UUID, Boolean>)ImmutableMap.copyOf(this.parent.villagerHandle.hasBlockOfProgress), dayTime);
    }

    static MCTownState advanceTime(TownFlagBlockEntity e, ServerLevel sl, @Nullable Long optionalWarpDuration) {
        MCTownState storedState;
        long dayTime = sl.m_46468_();
        if (e.advancedTimeOnTick == dayTime) {
            e.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TIME_WARP).log("Already advanced time on this tick. Skipping.", new Object[0]);
            return null;
        }
        e.advancedTimeOnTick = dayTime;
        if (Compat.getBlockStoredTagData(e).m_128441_(NBT_TOWN_STATE)) {
            storedState = TownStateSerializer.INSTANCE.load(Compat.getBlockStoredTagData(e).m_128469_(NBT_TOWN_STATE), sl, bp -> e.getWelcomeMats().contains(bp));
            e.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TIME_WARP).log("Loaded state from NBT: {}", storedState);
        } else {
            storedState = new MCTownState((List<TownState.VillagerData<MCHeldItem>>)ImmutableList.of(), (List<ContainerTarget<MCContainer, MCTownItem>>)ImmutableList.of(), (ImmutableMap<BlockPos, State>)ImmutableMap.of(), (ImmutableMap<BlockPos, Integer>)ImmutableMap.of(), (List<BlockPos>)ImmutableList.of(), (ImmutableList<MCHeldItem>)ImmutableList.of(), (ImmutableMap<UUID, Boolean>)ImmutableMap.of(), 0L);
            QT.logBug("NBT had no town state. That's probably a bug. Town state will reset", new Object[0]);
        }
        ArrayList villagers = new ArrayList(storedState.villagers);
        long ticksPassed = dayTime - storedState.worldTimeAtSleep;
        if (optionalWarpDuration != null) {
            ticksPassed = optionalWarpDuration;
        }
        if (ticksPassed <= 0L) {
            QT.FLAG_LOGGER.info("Time warp is not applicable", new Object[0]);
            return storedState;
        }
        ticksPassed = Math.min(ticksPassed, (long)((Integer)Config.TIME_WARP_MAX_TICKS.get()).intValue());
        MCTownState liveState = storedState;
        ArrayList warpSteps = new ArrayList();
        int i = 0;
        while (i < villagers.size()) {
            TownState.VillagerData v = (TownState.VillagerData)villagers.get(i);
            e.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TIME_WARP).log("[{}] Warping time by {} ticks, starting with journal: {}", v.uuid, ticksPassed, liveState);
            Warper<ServerLevel, MCTownState> vWarper = ServerJobsRegistry.getWarper(i, v.journal.jobId());
            int n = i++;
            vWarper.getTicks(dayTime, ticksPassed).forEach(tick -> warpSteps.add(new AbstractMap.SimpleEntry<Long, Function>(tick.tick(), ts -> vWarper.warp(sl, (MCTownState)ts, tick.tick(), tick.ticksSincePrevious(), ii))));
        }
        warpSteps.sort(Map.Entry.comparingByKey());
        long before = System.currentTimeMillis();
        for (Map.Entry entry : warpSteps) {
            MCTownState affectedState = (MCTownState)((Function)entry.getValue()).apply((Object)liveState);
            if (affectedState == null) continue;
            liveState = affectedState;
        }
        long after = System.currentTimeMillis();
        TownInterface.DebugLogger logger = ((Boolean)Config.LOG_WARP_RESULT.get()).booleanValue() ? QT.FLAG_LOGGER::info : e.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TIME_WARP);
        logger.log("State after warp of {}: {}", ticksPassed, liveState);
        QT.FLAG_LOGGER.info("Warp took {} milliseconds", after - before);
        return new MCTownState((List<TownState.VillagerData<MCHeldItem>>)liveState.villagers, (List<ContainerTarget<MCContainer, MCTownItem>>)liveState.containers, (ImmutableMap<BlockPos, State>)liveState.workStates, (ImmutableMap<BlockPos, Integer>)liveState.workTimers, (List<BlockPos>)liveState.gates, liveState.knowledge(), (ImmutableMap<UUID, Boolean>)liveState.blocksOfProgress, dayTime);
    }

    static void recoverMobs(TownFlagBlockEntity e, ServerLevel sl) {
        ImmutableList entitiesSnapshot = ImmutableList.copyOf(e.getVillagerHandle().entities());
        for (LivingEntity entity : entitiesSnapshot) {
            e.getVillagerHandle().remove(entity);
            entity.m_5796_();
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (Compat.getBlockStoredTagData(e).m_128441_(NBT_TOWN_STATE)) {
            @NotNull ImmutableList<TownState.VillagerData<MCHeldItem>> villagers = TownStateSerializer.loadVillagers(Compat.getBlockStoredTagData(e).m_128469_(NBT_TOWN_STATE));
            for (TownState.VillagerData v : villagers) {
                VisitorMobEntity recovered = new VisitorMobEntity(sl, e);
                recovered.initialize(e, v.uuid, v.xPosition, v.yPosition, v.zPosition, v.journal);
                sl.m_7967_((Entity)recovered);
                e.getVillagerHandle().register(recovered);
            }
            e.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TIME_WARP).log("Loaded villager state from NBT: {}", villagers);
        }
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_(NBT_TOWN_STATE)) {
            CompoundTag stateTag = tag.m_128469_(NBT_TOWN_STATE);
            this.townInit.push((Function<TownFlagBlockEntity, MCTownState>)((Function)e -> TownStateSerializer.INSTANCE.load(stateTag, e.getServerLevel(), bp -> e.getWelcomeMats().contains(bp))));
        }
    }

    public boolean tick(TownFlagBlockEntity e, CompoundTag flagTag, ServerLevel level) {
        if (!e.isInitialized()) {
            return false;
        }
        long start = System.currentTimeMillis();
        long lastTick = flagTag.m_128454_(NBT_TIME_WARP_REFERENCE_TICK);
        long gt = level.m_46468_();
        long timeSinceWake = Math.max(0L, gt - lastTick);
        boolean waking = timeSinceWake > 10L || !this.initialized;
        this.initialized = true;
        if (waking) {
            this.warp(e, flagTag, level, timeSinceWake);
        } else {
            flagTag.m_128356_(NBT_TIME_WARP_REFERENCE_TICK, gt);
        }
        Iterator<ContainerTarget<MCContainer, MCTownItem>> matchIter = TownContainers.findAllContainersMatching(e, item -> true).iterator();
        boolean changes = this.checkForContainerChanges(e, level, matchIter);
        this.profileTick(start);
        return changes;
    }

    void warp(TownFlagBlockEntity e, CompoundTag flagTag, ServerLevel level, long timeSinceWake) {
        long levelDayTime = level.m_46468_();
        try {
            MCTownState newState = TownFlagState.advanceTime(this.parent, level, timeSinceWake);
            if (newState != null) {
                e.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TIME_WARP).log("Storing state on {}: {}", e.getUUID(), newState);
                Compat.getBlockStoredTagData(e).m_128365_(NBT_TOWN_STATE, (Tag)TownStateSerializer.INSTANCE.store(newState));
                TownFlagState.recoverMobs(this.parent, level);
                this.parent.getKnowledgeHandle().registerFoundLoots((Collection<MCHeldItem>)newState.knowledge());
            }
        }
        catch (Exception ex) {
            if (((Boolean)Config.CRASH_ON_FAILED_WARP.get()).booleanValue()) {
                throw ex;
            }
            QT.FLAG_LOGGER.error("Time warp raised exception", ex);
            QT.FLAG_LOGGER.info("Due to config, continuing as if nothing happened in town while player was away", new Object[0]);
        }
        flagTag.m_128356_(NBT_TIME_WARP_REFERENCE_TICK, levelDayTime);
    }

    private void profileTick(long startTime) {
        if ((Integer)Config.TICK_SAMPLING_RATE.get() > 0) {
            long end = System.currentTimeMillis();
            this.times.add((int)(end - startTime));
            if (this.times.size() > (Integer)Config.TICK_SAMPLING_RATE.get()) {
                Questown.LOGGER.debug("[TownFlagState] Average tick length: {}", (Object)this.times.stream().mapToInt(Integer::intValue).average());
                this.times.clear();
            }
        }
    }

    private boolean checkForContainerChanges(TownFlagBlockEntity e, ServerLevel level, Iterator<ContainerTarget<MCContainer, MCTownItem>> matchIter) {
        boolean containersChanged = false;
        for (int i = 0; i < (Integer)Config.BASE_MAX_LOOP.get() && matchIter.hasNext(); ++i) {
            ContainerTarget<MCContainer, MCTownItem> v = matchIter.next();
            BlockPos bp = Positions.ToBlock((Position)v.getPosition(), (int)v.getYPosition());
            BlockEntity entity = level.m_7702_(bp);
            if (entity == null) {
                QT.FLAG_LOGGER.error("Entity is null at {}, but was expected to be a container", bp);
                continue;
            }
            LazyOptional cap = entity.getCapability(Compat.ITEM_HANDLER);
            if (!cap.isPresent()) continue;
            int newValue = TownFlagState.determineValue((IItemHandler)cap.resolve().get());
            if (this.listenedBlocks.containsKey(bp)) {
                Integer oldValue = this.listenedBlocks.get(bp);
                if (oldValue.equals(newValue)) continue;
                e.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TOWN_STATE_CHANGES).log("Chest tags changed", new Object[0]);
                containersChanged = true;
            } else {
                containersChanged = true;
            }
            this.listenedBlocks.put(bp, newValue);
        }
        return containersChanged;
    }

    private static int determineValue(IItemHandler cap) {
        ArrayList<String> itemNames = new ArrayList<String>(cap.getSlots());
        for (int i = 0; i < cap.getSlots(); ++i) {
            itemNames.add(cap.getStackInSlot(i).toString());
        }
        return itemNames.hashCode();
    }

    void putStateOnTile(CompoundTag flagTag, UUID uuid, TownInterface.DebugLogger logger) {
        @Nullable MCTownState state = this.captureState();
        if (state == null) {
            QT.FLAG_LOGGER.warn("TownState was null. Will not store.", new Object[0]);
            return;
        }
        logger.log("[Tile] Storing state on {}: {}", uuid, state);
        CompoundTag cereal = TownStateSerializer.INSTANCE.store(state);
        flagTag.m_128365_(NBT_TOWN_STATE, (Tag)cereal);
    }
}

