/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.core.advancements.RoomTrigger;
import ca.bradj.questown.core.init.AdvancementsInit;
import ca.bradj.questown.logic.RoomRecipes;
import ca.bradj.questown.logic.TownCycle;
import ca.bradj.questown.roomrecipes.Matches;
import ca.bradj.questown.town.WallDetection;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatches;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.DoorDetection;
import ca.bradj.roomrecipes.recipes.RecipeDetection;
import ca.bradj.roomrecipes.recipes.RoomAnnouncing;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import ca.bradj.roomrecipes.render.RoomEffects;
import ca.bradj.roomrecipes.rooms.ActiveRooms;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TownRooms
implements TownCycle.BlockChecker,
DoorDetection.DoorChecker,
ActiveRooms.ChangeListener<MCRoom>,
RoomAnnouncing {
    private final List<RecipeRoomChangeListener> changeListeners = new ArrayList<RecipeRoomChangeListener>();
    private final Stack<Position> roomsToSkipInitialAnnounce = new Stack();
    private final ActiveRooms<MCRoom> rooms = new ActiveRooms();
    private final int scanLevel;
    private final Supplier<TownFlagBlockEntity> entitySupplier;

    public void addRecipeRoomChangeListener(RecipeRoomChangeListener cl) {
        this.changeListeners.add(cl);
    }

    public Optional<MCRoom> get(Position position) {
        return Optional.ofNullable((MCRoom)this.rooms.get(position));
    }

    public void skipAnnounceOnFirstDetect(Collection<Position> collection) {
        this.roomsToSkipInitialAnnounce.addAll(collection);
    }

    public TownRooms(int scanLevel, Supplier<TownFlagBlockEntity> entitySupplier) {
        this.entitySupplier = entitySupplier;
        this.scanLevel = scanLevel;
        this.rooms.addChangeListener((ActiveRooms.ChangeListener)this);
    }

    int getY() {
        return this.entitySupplier.get().getTownFlagBasePos().m_123342_() + this.scanLevel;
    }

    @Override
    public boolean IsEmpty(Position dp) {
        return WallDetection.IsEmpty(this.entitySupplier.get().getServerLevel(), dp, this.getY());
    }

    @Override
    public boolean IsWall(Position dp) {
        return WallDetection.IsWall(this.entitySupplier.get().getServerLevel(), dp, this.getY());
    }

    @Override
    public boolean IsDoor(Position dp) {
        return WallDetection.IsDoor(this.entitySupplier.get().getServerLevel(), dp, this.getY());
    }

    public void update(ImmutableMap<Position, Optional<MCRoom>> rooms) {
        this.rooms.update(rooms);
    }

    public Collection<MCRoom> getAll() {
        return this.rooms.getAll();
    }

    public void roomAdded(Position doorPos, MCRoom room) {
        TownFlagBlockEntity entity = this.entitySupplier.get();
        this.grantAdvancement(doorPos);
        ServerLevel l = entity.getServerLevel();
        TownRooms.addParticles(l, room, (ParticleOptions)ParticleTypes.f_123748_);
        Optional<RoomRecipeMatches<MCRoom>> recipe = this.getActiveRecipes(l, room);
        if (this.roomsToSkipInitialAnnounce.contains(room.doorPos)) {
            this.roomsToSkipInitialAnnounce.remove(room.doorPos);
        } else {
            this.changeListeners.forEach(cl -> cl.updateRecipeForRoom(this.scanLevel, room, room, (RoomRecipeMatch<MCRoom>)((RoomRecipeMatch)recipe.orElse(null))));
            Optional<Object> name = Optional.empty();
            if (recipe.isPresent()) {
                name = Matches.getTopMatch(this::recipesFromLevel, (RoomRecipeMatch<MCRoom>)((RoomRecipeMatch)recipe.get()));
            }
            entity.messages.roomCreated(name.orElse(null), doorPos);
        }
    }

    private Map<ResourceLocation, RoomRecipe> recipesFromLevel() {
        return RoomRecipes.hydrate(this.entitySupplier.get().getServerLevel().m_7465_(), true);
    }

    protected Optional<RoomRecipeMatches<MCRoom>> getActiveRecipes(ServerLevel level, MCRoom room) {
        return RecipeDetection.getActiveRecipes((Level)level, (MCRoom)room, (boolean)false);
    }

    private void grantAdvancement(Position doorPos) {
        TownFlagBlockEntity entity = this.entitySupplier.get();
        ServerLevel level = entity.getServerLevel();
        if (level == null) {
            return;
        }
        AdvancementsInit.ROOM_TRIGGER.triggerForNearestPlayer(level, RoomTrigger.Triggers.FirstRoom, Positions.ToBlock((Position)doorPos, (int)entity.getY()));
    }

    public void roomResized(Position doorPos, MCRoom oldRoom, MCRoom newRoom) {
        TownFlagBlockEntity entity = this.entitySupplier.get();
        TownRooms.addParticles(entity.getServerLevel(), newRoom, (ParticleOptions)ParticleTypes.f_123748_);
        ServerLevel l = entity.getServerLevel();
        Optional<RoomRecipeMatches<MCRoom>> recipe = this.getActiveRecipes(l, newRoom);
        this.changeListeners.forEach(changeListener -> changeListener.updateRecipeForRoom(this.scanLevel, oldRoom, newRoom, (RoomRecipeMatch<MCRoom>)((RoomRecipeMatch)recipe.orElse(null))));
        Optional<Object> roomName = Optional.empty();
        if (recipe.isPresent()) {
            roomName = Matches.getTopMatch(this::recipesFromLevel, (RoomRecipeMatch<MCRoom>)((RoomRecipeMatch)recipe.get()));
        }
        entity.messages.roomSizeChanged(roomName.orElse(null), doorPos);
    }

    public void recheckRecipes(Supplier<ServerLevel> level) {
        for (MCRoom newRoom : this.rooms.getAll()) {
            Optional<RoomRecipeMatches<MCRoom>> recipe = this.getActiveRecipes(level.get(), newRoom);
            this.changeListeners.forEach(changeListener -> changeListener.updateRecipeForRoom(this.scanLevel, newRoom, newRoom, (RoomRecipeMatch<MCRoom>)((RoomRecipeMatch)recipe.orElse(null))));
        }
    }

    public void roomDestroyed(Position doorPos, MCRoom room) {
        TownFlagBlockEntity entity = this.entitySupplier.get();
        ServerLevel l = entity.getServerLevel();
        Optional<RoomRecipeMatches<MCRoom>> recipe = this.getActiveRecipes(l, room);
        Optional<Object> roomName = Optional.empty();
        if (recipe.isPresent()) {
            roomName = Matches.getTopMatch(this::recipesFromLevel, (RoomRecipeMatch<MCRoom>)((RoomRecipeMatch)recipe.get()));
        }
        entity.messages.roomDestroyed(roomName.orElse(null), doorPos);
        TownRooms.addParticles(l, room, (ParticleOptions)ParticleTypes.f_123762_);
        this.changeListeners.forEach(cl -> cl.updateRecipeForRoom(this.scanLevel, room, null, null));
    }

    public static void addParticles(ServerLevel sl, MCRoom room, ParticleOptions pType) {
        for (InclusiveSpace space : room.getSpaces()) {
            RoomEffects.renderParticlesBetween((InclusiveSpace)space, (x, z) -> {
                BlockPos bp = new BlockPos(x, (double)room.yCoord, z);
                if (!sl.m_46859_(bp)) {
                    return;
                }
                sl.m_8767_(pType, x, (double)room.yCoord, z, 2, 0.0, 1.0, 0.0, 1.0);
                sl.m_8767_(pType, x, (double)(room.yCoord + 1), z, 2, 0.0, 1.0, 0.0, 1.0);
            });
        }
    }

    public static interface RecipeRoomChangeListener {
        public void updateRecipeForRoom(int var1, @Nullable MCRoom var2, @Nullable MCRoom var3, @Nullable RoomRecipeMatch<MCRoom> var4);
    }
}

