/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.QT;
import ca.bradj.questown.commands.DebugLogArgument;
import ca.bradj.questown.core.Config;
import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.integration.jobs.UnsafeVillagerData;
import ca.bradj.questown.items.EffectMetaItem;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.jobs.ServerJobsRegistry;
import ca.bradj.questown.jobs.Signals;
import ca.bradj.questown.jobs.declarative.DowntimeWork;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.Effect;
import ca.bradj.questown.town.PoseInPlace;
import ca.bradj.questown.town.TownVillagerBedsHandle;
import ca.bradj.questown.town.TownVillagerMoods;
import ca.bradj.questown.town.TownVillagerUIs;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.VillagerStatsData;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.entity.TownVillagerHandlerSerializer;
import ca.bradj.questown.town.entity.TownVillagerLearningHandle;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.interfaces.VillagerHolder;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TownVillagerHandle
implements VillagerHolder {
    public static final TownVillagerHandlerSerializer SERIALIZER = new TownVillagerHandlerSerializer();
    private final Map<VillagerUUID, CompoundTag> customData = new HashMap<VillagerUUID, CompoundTag>();
    private final Map<VillagerUUID, Long> mostRecentDowntimeTick = new HashMap<VillagerUUID, Long>();
    private final Map<VillagerUUID, LookTarget> lookTargets = new HashMap<VillagerUUID, LookTarget>();
    private final Map<VillagerUUID, LookTarget> mostRecentLookTarget = new HashMap<VillagerUUID, LookTarget>();
    private final Map<VillagerUUID, Boolean> jobChangesPending = new HashMap<VillagerUUID, Boolean>();
    final Map<UUID, Integer> fullness = new HashMap<UUID, Integer>();
    final Map<UUID, Integer> experience = new HashMap<UUID, Integer>();
    final Map<UUID, Integer> levels = new HashMap<UUID, Integer>();
    final Map<UUID, Integer> damage = new HashMap<UUID, Integer>();
    final Map<UUID, PoseInPlace> requestedPose = new HashMap<UUID, PoseInPlace>();
    final Map<UUID, Boolean> hasBlockOfProgress = new HashMap<UUID, Boolean>();
    final TownVillagerMoods moods = new TownVillagerMoods();
    private final List<LivingEntity> entities = new ArrayList<LivingEntity>();
    private final List<Consumer<VillagerStatsData>> listeners = new ArrayList<Consumer<VillagerStatsData>>();
    private final List<Consumer<VisitorMobEntity>> hungryListeners = new ArrayList<Consumer<VisitorMobEntity>>();
    private final UnsafeTown town = new UnsafeTown(this.getClass());
    private static final int TICK_FACTOR = 10;
    private final TownVillagerBedsHandle beds = new TownVillagerBedsHandle();
    final TownVillagerLearningHandle learning = new TownVillagerLearningHandle();

    public static void staticInit() {
        TownVillagerUIs.staticInit();
    }

    public ImmutableMap<VillagerUUID, Boolean> getJobChangesPending() {
        return ImmutableMap.copyOf(this.jobChangesPending);
    }

    public void initialize(Map<UUID, Integer> fullness, Map<UUID, ? extends ImmutableCollection<Effect>> moodEffects, Map<UUID, Integer> damage, Map<UUID, ? extends ImmutableCollection<JobID>> unlockedJobs, Map<UUID, ? extends Map<JobID, ? extends ImmutableCollection<JobID>>> jobsKnownToExist, ImmutableMap<UUID, Integer> experience, ImmutableMap<UUID, Integer> level, ImmutableMap<VillagerUUID, Boolean> jobChangesPending) {
        if (!this.fullness.isEmpty()) {
            throw new IllegalStateException("Attempting to initialize already initialized");
        }
        this.fullness.putAll(fullness);
        this.moods.initialize(moodEffects);
        this.damage.putAll(damage);
        this.learning.initialize(unlockedJobs, jobsKnownToExist);
        this.experience.putAll((Map<UUID, Integer>)experience);
        this.levels.putAll((Map<UUID, Integer>)level);
        this.jobChangesPending.putAll((Map<VillagerUUID, Boolean>)jobChangesPending);
    }

    public void tick(long currentTick, Signals signals) {
        if (signals != Signals.NIGHT) {
            this.tickHunger();
        }
        this.tickDamage();
        this.moods.tick(currentTick);
        TownFlagBlockEntity t = this.town.getUnsafe();
        this.beds.tick(t, (ImmutableList<LivingEntity>)ImmutableList.copyOf(this.entities));
        this.learning.tick((ImmutableList<LivingEntity>)ImmutableList.copyOf(this.entities), currentTick);
        this.entities.forEach((? super T e) -> {
            Optional<GlobalPos> bestBed = this.beds.getBestBed(t, (LivingEntity)e);
            e.m_6274_().m_21886_(MemoryModuleType.f_26359_, bestBed);
        });
    }

    private void tickHunger() {
        if (!((Boolean)Config.HUNGER_ENABLED.get()).booleanValue()) {
            this.entities.forEach((? super T e) -> this.fullness.put(e.m_20148_(), (Integer)Config.BASE_FULLNESS.get()));
            return;
        }
        Map<UUID, Integer> map = this.fullness;
        Integer base = (Integer)Config.BASE_FULLNESS.get();
        BiConsumer<Integer, LivingEntity> then = (newVal, e) -> {
            if (newVal == 0) {
                this.hungryListeners.forEach((? super T l) -> l.accept((VisitorMobEntity)e));
            }
        };
        this.tickThing(map, base, e -> 10, then);
    }

    private void tickDamage() {
        this.tickThing(this.damage, 0, e -> this.applyHealFactor((LivingEntity)e, 100), (newVal, e) -> {});
    }

    private int applyHealFactor(LivingEntity e, int i) {
        if (!(e instanceof VisitorMobEntity)) {
            return i;
        }
        PoseInPlace pose = this.requestedPose.get(e.m_20148_());
        if (pose == null) {
            return i;
        }
        if (!Pose.SLEEPING.equals((Object)pose.pose())) {
            return i;
        }
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        Double bedFactor = (Double)Config.NORMAL_BED_HEAL_MULTIPLIER.get();
        Double boostedFactor = t.getHealingHandle().getHealFactor(e.m_20183_());
        Double hf = Math.min(bedFactor, boostedFactor);
        int i1 = (int)((double)i * hf);
        t.getDebugLogger(QT.VILLAGER_LOGGER, DebugLogArgument.VILLAGER_STATS).log("Healing by {} due to sleeping heal factor {} {}", i1, hf, e.m_20148_());
        return i1;
    }

    private void tickThing(Map<UUID, Integer> map, Integer base, Function<LivingEntity, Integer> amount, BiConsumer<Integer, LivingEntity> then) {
        this.entities.forEach((? super T e) -> {
            UUID u = e.m_20148_();
            int oldVal = map.getOrDefault(u, base);
            int newVal = Math.max(0, oldVal - (Integer)amount.apply((LivingEntity)e));
            map.put(u, newVal);
            if (newVal != oldVal) {
                this.listeners.forEach((? super T l) -> l.accept(this.getStats(u)));
            }
            then.accept(newVal, (LivingEntity)e);
        });
    }

    @Override
    public VillagerStatsData getStats(UUID uuid) {
        Integer bf = (Integer)Config.BASE_FULLNESS.get();
        float fullnessPercent = (float)Util.getOrDefault(this.fullness, uuid, bf).intValue() / (float)bf.intValue();
        float damagePercent = this.getDamagePercent(uuid);
        int experienceNum = Util.getOrDefault(this.experience, uuid, 0);
        int experienceTarget = (int)this.getExpForCurrentLevel(uuid);
        return new VillagerStatsData(fullnessPercent, experienceNum, experienceTarget, this.moods.getMood(uuid), damagePercent);
    }

    private float getExpForCurrentLevel(UUID uuid) {
        Integer level = UtilClean.getOrDefault(this.levels, uuid, 1);
        Integer baseExp = (Integer)Config.EXPERIENCE_REQUIRED_AT_LEVEL_1.get();
        Double rampFactor = (Double)Config.EXPERIENCE_RAMP_FACTOR.get();
        return (float)((double)baseExp.intValue() * Math.pow(rampFactor, level - 1));
    }

    public float getDamagePercent(UUID uuid) {
        return (float)Util.getOrDefault(this.damage, uuid, 0).intValue() / (float)(16L * (Long)Config.DAMAGE_TICKS.get() * 10L);
    }

    @Override
    public Collection<JobID> getJobs() {
        return this.entities.stream().map(v -> ((VisitorMobEntity)v).getJobId()).toList();
    }

    @Override
    public ImmutableMap<VillagerUUID, JobID> getVillagerJobs() {
        HashMap b = new HashMap();
        this.entities.stream().filter(v -> v instanceof VisitorMobEntity).map(v -> (VisitorMobEntity)v).filter(v -> v.getVUID() != null).forEach((? super T v) -> b.put(v.getVUID(), v.getJobId()));
        return ImmutableMap.copyOf(b);
    }

    @Override
    public void changeJobForVillager(UUID visitorUUID, JobID jobID, boolean announce) {
        this.changeJobForVillager(VillagerUUID.from(visitorUUID), jobID, announce);
    }

    @Override
    public void changeJobForVillager(VillagerUUID villagerUUID, JobID newJob, boolean announce) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        VisitorMobEntity f = this.getEntity(villagerUUID);
        if (f == null) {
            QT.FLAG_LOGGER.error("Could not find entity {} to apply job change: {}", villagerUUID, newJob);
            return;
        }
        if (DowntimeWork.matches(f.getJobId())) {
            this.registerMostRecentDowntime(villagerUUID, Util.getTick(this.town.getServerLevelUnsafe()));
        }
        this.doSetJob(villagerUUID, newJob, f);
        t.m_6596_();
        if (announce) {
            t.messages.jobChanged(newJob, VillagerUUID.get(villagerUUID));
        }
        t.possibleWork.invalidate();
        t.getVillagerHandle().setJobChangePending(f.getVUID(), false);
    }

    private void doSetJob(VillagerUUID visitorUUID, JobID jobName, VisitorMobEntity f) {
        f.setJob(ServerJobsRegistry.getInitializedJob(this.town.getServerLevelUnsafe(), jobName, f.getJobJournalSnapshot().items(), VillagerUUID.get(visitorUUID)));
    }

    @Override
    public void changeToNextJobForVillager(UUID villagerUUID, JobID currentJob) {
        this.town.getUnsafe().changeJobForVisitorFromBoard(villagerUUID, currentJob);
    }

    public Stream<LivingEntity> stream() {
        return this.entities.stream();
    }

    @Override
    public void remove(LivingEntity visitorMobEntity) {
        this.entities.remove(visitorMobEntity);
        this.town.getUnsafe().m_6596_();
    }

    @Override
    public void showUI(ServerPlayer sender, String type, UUID villagerId) {
        TownVillagerUIs.showUI(sender, this.entities, type, villagerId, this.learning.getUnlockedJobs(), this.learning.getChildJobsKnownToExist(this.getEntity(villagerId).getJobId()));
    }

    @Override
    public void fillHunger(UUID uuid) {
        this.fillHunger(uuid, 1.0f);
    }

    @Override
    public void fillHunger(UUID uuid, float percent) {
        this.fullness.put(uuid, (int)(percent * (float)((Integer)Config.BASE_FULLNESS.get()).intValue()));
    }

    @Override
    public void makeAngry(UUID uuid) {
    }

    void forEach(Consumer<VisitorMobEntity> c) {
        List<VisitorMobEntity> villagers = this.entities.stream().filter(v -> v instanceof VisitorMobEntity).map(v -> (VisitorMobEntity)v).toList();
        for (VisitorMobEntity villager : villagers) {
            c.accept(villager);
        }
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    public long size() {
        return this.entities.size();
    }

    public void add(VisitorMobEntity vEntity) {
        this.entities.add((LivingEntity)vEntity);
        ImmutableList<JobID> defaultWork = ServerJobsRegistry.getDefaultWork(vEntity.getJobId());
        for (JobID jobID : defaultWork) {
            this.unlockJob(vEntity.m_20148_(), jobID);
        }
        this.learning.requestKnowledge(vEntity.m_20148_(), defaultWork);
        TownFlagBlockEntity t = this.town.getUnsafe();
        this.beds.claim((LivingEntity)vEntity, t);
        vEntity.addSleepListener(e -> {
            Double healFactor = t.getHealingHandle().getHealFactor(e.bedPos());
            long ticksHealed = (long)((double)e.duration().longValue() * healFactor);
            this.damage.compute(vEntity.m_20148_(), (id, cur) -> {
                if (cur == null) {
                    return 0;
                }
                int newVal = Math.toIntExact(Math.max(0L, (long)cur.intValue() - ticksHealed));
                t.getDebugLogger(QT.VILLAGER_LOGGER, DebugLogArgument.VILLAGER_STATS).log("Villager damage changed from {} to {} after {} ticks of sleep via bed at {} with heal factor {} [{}]", cur, newVal, e.duration(), e.bedPos(), healFactor, vEntity.m_20148_());
                return newVal;
            });
        });
    }

    public boolean exists(VisitorMobEntity visitorMobEntity) {
        return this.entities.contains(visitorMobEntity);
    }

    @Override
    public void addStatsListener(Consumer<VillagerStatsData> l) {
        this.listeners.add(l);
    }

    public void addHungryListener(Consumer<VisitorMobEntity> l) {
        this.hungryListeners.add(l);
    }

    @Override
    public void removeStatsListener(Consumer<VillagerStatsData> l) {
        this.listeners.remove(l);
    }

    @Override
    public Collection<LivingEntity> entities() {
        return this.entities;
    }

    public void makeAllTotallyHungry() {
        if (!((Boolean)Config.HUNGER_ENABLED.get()).booleanValue()) {
            return;
        }
        this.entities.forEach((? super T e) -> {
            UUID u = e.m_20148_();
            this.fullness.put(u, 1);
        });
    }

    @Override
    public boolean isDining(UUID uuid) {
        return this.entities.stream().filter(v -> uuid.equals(v.m_20148_())).map(v -> ServerJobsRegistry.isDining(((VisitorMobEntity)v).getJobId())).findFirst().orElse(false);
    }

    @Override
    public boolean canDine(UUID uuid) {
        return this.entities.stream().filter(v -> uuid.equals(v.m_20148_())).map(v -> ((VisitorMobEntity)v).canStopWorkingAtAnyTime()).findFirst().orElse(false);
    }

    @Override
    public void applyEffect(ResourceLocation effect, Long expireOnTick, UUID uuid) {
        if (EffectMetaItem.ConsumableEffects.FILL_HUNGER.equals((Object)effect)) {
            this.fillHunger(uuid);
            return;
        }
        if (EffectMetaItem.ConsumableEffects.FILL_HUNGER_HALF.equals((Object)effect)) {
            this.fillHunger(uuid, 0.5f);
            return;
        }
        this.moods.tryApplyEffect(effect, expireOnTick, uuid);
    }

    @Override
    public int getAffectedTime(UUID uuid, Integer timeToAugment) {
        float offset = (float)((Integer)Config.NEUTRAL_MOOD.get()).intValue() / 100.0f - this.moods.getMood(uuid);
        return (int)((1.0f + offset) * (float)timeToAugment.intValue());
    }

    @Override
    public int getWorkSpeed(UUID uuid) {
        return (int)(this.moods.getMood(uuid) * 10.0f);
    }

    public void associate(TownFlagBlockEntity t) {
        this.town.initialize(t);
        this.learning.associate(t);
    }

    @Override
    public void freezeVillagers(Integer ticks) {
        this.stream().filter(VisitorMobEntity.class::isInstance).map(VisitorMobEntity.class::cast).forEach((? super T v) -> v.freeze(ticks));
    }

    @Override
    public void recallVillagers() {
        BlockPos visitorJoinPos = this.town.getUnsafe().m_58899_();
        this.forEach(v -> {
            QT.FLAG_LOGGER.info("Moving {} to {} and healing", v, visitorJoinPos);
            v.m_6034_(visitorJoinPos.m_123341_(), visitorJoinPos.m_123342_(), visitorJoinPos.m_123343_());
            v.m_21153_(v.m_21233_());
        });
    }

    @Override
    public void validateEntity(VisitorMobEntity visitorMobEntity) {
        if (this.exists(visitorMobEntity)) {
            return;
        }
        QT.FLAG_LOGGER.error("Visitor mob's parent has no record of entity. Removing visitor", new Object[0]);
        visitorMobEntity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Deprecated(forRemoval=true)
    public VisitorMobEntity getEntity(UUID ownerUUID) {
        return this.getEntity(VillagerUUID.from(ownerUUID));
    }

    public VisitorMobEntity getEntity(VillagerUUID ownerUUID) {
        Optional<LivingEntity> f = this.stream().filter(v -> ownerUUID.matches(v.m_20148_())).findFirst();
        if (f.isEmpty()) {
            QT.FLAG_LOGGER.error("No entities found for UUID: {}", ownerUUID);
            return null;
        }
        LivingEntity ff = f.get();
        if (!(ff instanceof VisitorMobEntity)) {
            QT.FLAG_LOGGER.error("Entity is wrong type: {}", ff);
            return null;
        }
        VisitorMobEntity v2 = (VisitorMobEntity)ff;
        return v2;
    }

    @Override
    public void addDamage(UUID uuid) {
        Integer oldVal = Util.getOrDefault(this.damage, uuid, 0);
        int addition = (int)((Long)Config.DAMAGE_TICKS.get() * 10L);
        this.damage.put(uuid, oldVal + addition);
    }

    @Override
    public int getDamageTicksLeft(UUID uuid) {
        return Util.getOrDefault(this.damage, uuid, 0) / 10;
    }

    @Override
    public void requestPose(UUID ownerUUID, PoseInPlace pose) {
        this.requestedPose.put(ownerUUID, pose);
    }

    @Override
    public Optional<PoseInPlace> getRequestedPose(UUID ownerUUID) {
        return Optional.ofNullable(this.requestedPose.get(ownerUUID));
    }

    @Override
    public void clearPoseRequests(UUID uuid) {
        this.requestedPose.remove(uuid);
    }

    @Override
    public void showMultiStatusUI(ServerPlayer player) {
        TownVillagerUIs.showMultiStatusUI(player, this.town.getUnsafe().getInfo(), this.entities, () -> this.town.getUnsafe().getAllQuestsWithRewards(), this.town.getUnsafe().getBlocksOfProgress());
    }

    @Override
    public void showItemJobsUI(ServerPlayer sender, Ingredient itemToShowJobsFor) {
        TownVillagerUIs.showItemJobsUI(sender, this.town.getUnsafe(), this.entities, itemToShowJobsFor);
    }

    @Override
    public void showJobUI(ServerPlayer sender, JobID jobToShow) {
        TownVillagerUIs.showJobsWithSameRootUI(sender, this.town.getUnsafe(), this.entities, jobToShow);
    }

    @Override
    public void setJobChangePending(@Nullable VillagerUUID vuid, boolean value) {
        this.jobChangesPending.put(vuid, value);
        this.town.getUnsafe().m_6596_();
    }

    @Override
    public boolean isJobChangePending(VillagerUUID vuid) {
        return UtilClean.getOrDefault(this.jobChangesPending, vuid, false);
    }

    @Override
    public void register(VisitorMobEntity vEntity) {
        @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
        QT.FLAG_LOGGER.info("Registered entity with town {}: {}", t.getUUID(), vEntity);
        this.add(vEntity);
        vEntity.addChangeListener(() -> {
            TownInterface.DebugLogger logger = t.getDebugLogger(QT.FLAG_LOGGER, DebugLogArgument.TOWN_STATE_CHANGES);
            logger.log("Entity requests flag to be marked changed", new Object[0]);
            t.m_6596_();
        });
        t.m_6596_();
    }

    @Override
    public void unlockJob(UUID villagerUUID, JobID id) {
        this.learning.unlockJob(villagerUUID, id);
    }

    @Override
    public void addExperience(UUID uuid, int exp) {
        int target;
        if (this.hasBlockOfProgress(uuid)) {
            return;
        }
        int newExp = this.experience.compute(uuid, (x, cur) -> cur == null ? exp : cur + exp);
        if (newExp >= (target = (int)this.getExpForCurrentLevel(uuid))) {
            Integer newLvl = this.levels.compute(uuid, (x, cur) -> cur == null ? 2 : cur + 1);
            this.experience.put(uuid, newExp % target);
            this.town.getUnsafe().messages.broadcastMessage("message.villager.leveled_up", uuid, newLvl);
            this.hasBlockOfProgress.put(uuid, true);
        }
    }

    @Override
    public boolean hasBlockOfProgress(UUID uuid) {
        return Util.getOrDefault(this.hasBlockOfProgress, uuid, false);
    }

    @Override
    public void clearBlockOfProgress(UUID uuid) {
        this.hasBlockOfProgress.put(uuid, false);
    }

    @Override
    public void scheduleJobRootChange(UUID villagerUUID, boolean instant) {
        VisitorMobEntity e = this.getEntity(villagerUUID);
        if (e == null) {
            QT.FLAG_LOGGER.error("Villager not found for job root change: {}", villagerUUID);
            return;
        }
        if (instant) {
            QT.FLAG_LOGGER.info("Villager {} will change to a new job NOW (creative mode)", UtilClean.truncateMiddle(villagerUUID));
            this.changeJobRootNow(e);
            return;
        }
        TownFlagBlockEntity t = this.town.getUnsafe();
        t.getVillagerHandle().setJobChangePending(e.getVUID(), true);
        t.messages.broadcastMessage("message.questown.villager.leveled_up", UtilClean.truncateMiddle(villagerUUID));
    }

    @Override
    public boolean isUnlocked(JobID jobID) {
        return this.learning.isUnlocked(jobID);
    }

    @Override
    public UnsafeVillagerData getUnprotectedDataHandle(final @Nullable VillagerUUID vuid) {
        return new UnsafeVillagerData(){

            @Override
            public String get(String key) {
                CompoundTag tag = UtilClean.getOrDefault(TownVillagerHandle.this.customData, vuid, new CompoundTag());
                if (!tag.m_128441_(key)) {
                    return null;
                }
                return tag.m_128461_(key);
            }

            @Override
            public void write(String key, String value) {
                CompoundTag tag = UtilClean.getOrDefault(TownVillagerHandle.this.customData, vuid, new CompoundTag());
                tag.m_128359_(key, value);
                TownVillagerHandle.this.customData.put(vuid, tag);
            }

            @Override
            public void clear(String key) {
                CompoundTag tag = UtilClean.getOrDefault(TownVillagerHandle.this.customData, vuid, new CompoundTag());
                tag.m_128473_(key);
                TownVillagerHandle.this.customData.put(vuid, tag);
            }
        };
    }

    @Override
    public Optional<Entity> getLookTarget(@Nullable VillagerUUID vuid) {
        LookTarget tar = this.lookTargets.get(vuid);
        if (tar == null) {
            return Optional.empty();
        }
        long currentTick = Util.getTick(this.town.getServerLevelUnsafe());
        if (currentTick < tar.untilTick()) {
            return Optional.of(tar.who);
        }
        this.town.getUnsafe().getDebugLogger(QT.VILLAGER_LOGGER, DebugLogArgument.VILLAGER_NAVIGATION).log("Look target for {} has expired at tick {} (current {})", vuid, tar.untilTick(), currentTick);
        this.lookTargets.remove(vuid);
        return Optional.empty();
    }

    @Override
    public void setLookTarget(@Nullable VillagerUUID vuid, Entity entity, long untilTick, long thenNotUntilTick) {
        LookTarget tar = this.mostRecentLookTarget.get(vuid);
        if (tar != null && tar.who.equals((Object)entity)) {
            long currentTick = Util.getTick(this.town.getServerLevelUnsafe());
            if (currentTick < tar.untilTick()) {
                return;
            }
            this.mostRecentLookTarget.remove(vuid);
        }
        this.lookTargets.computeIfAbsent(vuid, k -> {
            this.mostRecentLookTarget.put((VillagerUUID)k, new LookTarget(entity, thenNotUntilTick));
            LookTarget lookTarget = new LookTarget(entity, untilTick);
            this.town.getUnsafe().getDebugLogger(QT.VILLAGER_LOGGER, DebugLogArgument.VILLAGER_NAVIGATION).log("Setting look target for {} to {} until tick {} (then not until {})", vuid, entity, untilTick, thenNotUntilTick);
            return lookTarget;
        });
    }

    public ImmutableMap<UUID, ImmutableSet<JobID>> getUnlockedJobs() {
        return this.learning.getUnlockedJobs();
    }

    public ImmutableMap<UUID, ImmutableMap<JobID, ImmutableSet<JobID>>> getChildJobsKnownToExist() {
        return this.learning.getChildJobsKnownToExist();
    }

    public void handleMorning() {
        this.forEach(LivingEntity::m_5796_);
        this.makeAllTotallyHungry();
        long tick = Util.getTick(this.town.getServerLevelUnsafe());
        this.forEach(v -> this.registerMostRecentDowntime(v.getVUID(), tick));
        this.forEach(v -> {
            if (!this.isJobChangePending(v.getVUID())) {
                return;
            }
            this.changeJobRootNow((VisitorMobEntity)v);
        });
    }

    private void changeJobRootNow(VisitorMobEntity v) {
        Optional<JobID> override = this.town.getUnsafe().getQuestHandle().overnightJobOverride();
        if (override.isPresent()) {
            this.unlockAndChange(v, override.get());
            return;
        }
        ImmutableSet<JobID> allRoots = ServerJobsRegistry.getAllRootJobs();
        List<JobID> allOtherJobs = allRoots.stream().filter(z -> !v.getJobId().sameRoot((JobID)z)).toList();
        if (allOtherJobs.isEmpty()) {
            QT.FLAG_LOGGER.error("Only one job root detected in town? This is likely a poorly configured data pack.", new Object[0]);
            this.jobChangesPending.put(v.getVUID(), false);
            return;
        }
        ImmutableList shuffled = Compat.shuffle(ImmutableSet.copyOf(allOtherJobs), this.town.getServerLevelUnsafe());
        JobID newJob = (JobID)shuffled.get(0);
        if (v.getJobId().sameRoot(newJob)) {
            QT.logBug("Root change resulted in same root. From {} to {}.", v.getJobId(), newJob);
        }
        this.unlockAndChange(v, newJob);
    }

    private void unlockAndChange(VisitorMobEntity v, JobID newJob) {
        this.town.getUnsafe().getVillagerHandle().unlockJob(v.m_20148_(), newJob);
        this.town.getUnsafe().getVillagerHandle().changeJobForVillager(v.getVUID(), newJob, true);
    }

    public boolean isReadyForDowntime(VillagerUUID from, long currentTick) {
        Long maxTicksBeforeDowntime = (Long)Config.MAX_TICKS_BETWEEN_DOWNTIME.get();
        Long mostRecent = UtilClean.getOrDefault(this.mostRecentDowntimeTick, from, -maxTicksBeforeDowntime.longValue());
        return currentTick - mostRecent >= maxTicksBeforeDowntime;
    }

    public void registerMostRecentDowntime(VillagerUUID ownerUUID, long tick) {
        this.mostRecentDowntimeTick.put(ownerUUID, tick);
    }

    private record LookTarget(Entity who, Long untilTick) {
    }
}

