/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.QT;
import ca.bradj.questown.integration.minecraft.MCTownState;
import ca.bradj.questown.integration.minecraft.TownStateSerializer;
import ca.bradj.questown.mc.Compat;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.TownState;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.entity.TownFlagState;
import java.util.Optional;

public class TownVillagers {
    public static void assumeStateFromTown(TownFlagBlockEntity town, VisitorMobEntity visitorMobEntity) {
        if (!Compat.getBlockStoredTagData(town).m_128441_(TownFlagState.NBT_TOWN_STATE)) {
            QT.FLAG_LOGGER.error("Villager entity exists but town state is missing. This is a bug and may cause unexpected behaviour.", new Object[0]);
            return;
        }
        MCTownState state = TownStateSerializer.INSTANCE.load(Compat.getBlockStoredTagData(town).m_128469_(TownFlagState.NBT_TOWN_STATE), town.getServerLevel(), bp -> town.pois.getWelcomeMats().contains((Object)bp));
        Optional<TownState.VillagerData> match = state.villagers.stream().filter(v -> v.uuid.equals(visitorMobEntity.m_20148_())).findFirst();
        if (match.isEmpty()) {
            QT.FLAG_LOGGER.error("Villager entity exists but is not present on town state. This is a bug and may cause unexpected behaviour.", new Object[0]);
            return;
        }
        town.villagerHandle.register(visitorMobEntity);
        TownState.VillagerData m = match.get();
        visitorMobEntity.initialize(town, m.uuid, m.xPosition, m.yPosition, m.zPosition, m.journal);
    }
}

