/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.items.QTNBT;
import ca.bradj.questown.jobs.requests.WorkRequest;
import ca.bradj.questown.jobs.requests.WorkRequestSerializer;
import ca.bradj.questown.town.entity.TownWorkHandle;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class TownWorkHandleSerializer {
    public static final TownWorkHandleSerializer INSTANCE = new TownWorkHandleSerializer();

    public CompoundTag serializeNBT(TownWorkHandle workHandle) {
        CompoundTag tag = new CompoundTag();
        QTNBT.put(tag, "boards", (Tag)TownWorkHandleSerializer.serializeBoards(workHandle));
        QTNBT.put(tag, "requests", this.serializeRequests(workHandle));
        return tag;
    }

    public void deserializeNBT(CompoundTag compound, TownWorkHandle workHandle) {
        this.deserializeBoards(QTNBT.getList(compound, "boards")).forEach(workHandle::registerJobBoard);
        this.deserializeRequests(QTNBT.getList(compound, "requests")).forEach(workHandle::requestWork);
    }

    @NotNull
    private static ListTag serializeBoards(TownWorkHandle workHandle) {
        ListTag list = new ListTag();
        workHandle.jobBoards.forEach(v -> {
            CompoundTag bT = new CompoundTag();
            bT.m_128405_("x", v.m_123341_());
            bT.m_128405_("y", v.m_123342_());
            bT.m_128405_("z", v.m_123343_());
            list.add((Object)bT);
        });
        return list;
    }

    private Iterable<BlockPos> deserializeBoards(ListTag boards) {
        return boards.stream().map(v -> {
            CompoundTag vc = (CompoundTag)v;
            return new BlockPos(vc.m_128451_("x"), vc.m_128451_("y"), vc.m_128451_("z"));
        }).toList();
    }

    private Tag serializeRequests(TownWorkHandle workHandle) {
        ListTag list = new ListTag();
        workHandle.requestedResults.forEach(v -> {
            Tag tag = WorkRequestSerializer.INSTANCE.serialize((WorkRequest)v);
            list.add((Object)tag);
        });
        return list;
    }

    private Collection<WorkRequest> deserializeRequests(ListTag requests) {
        ImmutableList.Builder b = ImmutableList.builder();
        requests.forEach(v -> b.add((Object)WorkRequestSerializer.INSTANCE.deserialize((CompoundTag)v)));
        return b.build();
    }
}

