/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.entity;

import ca.bradj.questown.QT;
import ca.bradj.questown.Questown;
import ca.bradj.questown.core.init.BlocksInit;
import ca.bradj.questown.mc.Util;
import ca.bradj.questown.town.UnsafeTown;
import ca.bradj.questown.town.entity.TownFlagBlockEntity;
import ca.bradj.questown.town.workstatus.State;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.RoomWithBlocks;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TownWorldInteraction {
    private final UnsafeTown town = new UnsafeTown(this.getClass());

    TownWorldInteraction() {
    }

    void init(TownFlagBlockEntity t) {
        this.town.initialize(t);
    }

    void swapBlocks(ServerLevel level, RoomRecipeMatch<MCRoom> match) {
        ImmutableMap swaps = ImmutableMap.of((Object)Questown.ResourceLocation("job_board"), this::swapJobBoardSign);
        for (ResourceLocation recipeID : match.getRecipeIDs()) {
            BiFunction swap = (BiFunction)swaps.get((Object)recipeID);
            if (swap == null) continue;
            swap.apply(level, match);
        }
    }

    private Void swapJobBoardSign(ServerLevel level, RoomWithBlocks<MCRoom, BlockPos, Block> room) {
        BlockPredicate predicate = BlockPredicate.Builder.m_17924_().m_204027_(BlockTags.f_13068_).m_17931_();
        for (Map.Entry e : room.containedBlocks.entrySet()) {
            if (!predicate.m_17914_(level, (BlockPos)e.getKey())) continue;
            Direction value = Direction.EAST;
            try {
                value = Util.rotationToDirection((Integer)level.m_8055_((BlockPos)e.getKey()).m_61143_((Property)StandingSignBlock.f_56987_));
            }
            catch (IllegalArgumentException x) {
                try {
                    value = ((Direction)level.m_8055_((BlockPos)e.getKey()).m_61143_((Property)WallSignBlock.f_58064_)).m_122428_();
                }
                catch (IllegalArgumentException x2) {
                    QT.FLAG_LOGGER.error("Could not find valid direction for sign", new Object[0]);
                }
            }
            level.m_46597_((BlockPos)e.getKey(), (BlockState)((Block)BlocksInit.JOB_BOARD_BLOCK.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)value));
            @NotNull TownFlagBlockEntity t = this.town.getUnsafe();
            t.registerJobsBoard((BlockPos)e.getKey());
            t.jobHandle.setJobBlockState((BlockPos)e.getKey(), State.freshAtState(1));
        }
        return null;
    }
}

