/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.interfaces;

import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.integration.jobs.UnsafeVillagerData;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.mobs.visitor.VisitorMobEntity;
import ca.bradj.questown.town.PoseInPlace;
import ca.bradj.questown.town.VillagerStatsData;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public interface VillagerHolder {
    public long size();

    public void addStatsListener(Consumer<VillagerStatsData> var1);

    public void removeStatsListener(Consumer<VillagerStatsData> var1);

    public Collection<LivingEntity> entities();

    public void remove(LivingEntity var1);

    public void showUI(ServerPlayer var1, String var2, UUID var3);

    public void fillHunger(UUID var1);

    public void fillHunger(UUID var1, float var2);

    public void makeAngry(UUID var1);

    public boolean isDining(UUID var1);

    public void applyEffect(ResourceLocation var1, Long var2, UUID var3);

    public int getAffectedTime(UUID var1, Integer var2);

    public int getWorkSpeed(UUID var1);

    public VillagerStatsData getStats(UUID var1);

    public Collection<JobID> getJobs();

    public ImmutableMap<VillagerUUID, JobID> getVillagerJobs();

    public void changeJobForVillager(VillagerUUID var1, JobID var2, boolean var3);

    @Deprecated(forRemoval=true)
    public void changeJobForVillager(UUID var1, JobID var2, boolean var3);

    public void changeToNextJobForVillager(UUID var1, JobID var2);

    public boolean canDine(UUID var1);

    public void freezeVillagers(Integer var1);

    public void recallVillagers();

    public void validateEntity(VisitorMobEntity var1);

    public void addDamage(UUID var1);

    public int getDamageTicksLeft(UUID var1);

    public void requestPose(UUID var1, PoseInPlace var2);

    public Optional<PoseInPlace> getRequestedPose(UUID var1);

    public void clearPoseRequests(UUID var1);

    public void showMultiStatusUI(ServerPlayer var1);

    public void showItemJobsUI(ServerPlayer var1, Ingredient var2);

    public void register(VisitorMobEntity var1);

    public void unlockJob(UUID var1, JobID var2);

    public void addExperience(UUID var1, int var2);

    public boolean hasBlockOfProgress(UUID var1);

    public void clearBlockOfProgress(UUID var1);

    public void scheduleJobRootChange(UUID var1, boolean var2);

    public boolean isUnlocked(JobID var1);

    public UnsafeVillagerData getUnprotectedDataHandle(@Nullable VillagerUUID var1);

    public Optional<Entity> getLookTarget(@Nullable VillagerUUID var1);

    public void setLookTarget(@Nullable VillagerUUID var1, Entity var2, long var3, long var5);

    public void showJobUI(ServerPlayer var1, JobID var2);

    public void setJobChangePending(VillagerUUID var1, boolean var2);

    public boolean isJobChangePending(VillagerUUID var1);
}

