/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.MCRewardContainer;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class MCDelayedReward
extends MCReward
implements MCRewardContainer {
    public static final long START_OF_DAY = 1L;
    public static final String ID = "delayed";
    private static final String NBT_CHILD = "child";
    private final TownInterface town;
    private MCReward child;

    public MCDelayedReward(TownInterface town, MCReward child) {
        super((RewardType)RewardsInit.DELAYED.get());
        this.town = town;
        this.child = child;
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> this.town.addMorningReward(this.child);
    }

    public MCDelayedReward(RewardType<? extends MCReward> rType, TownInterface town) {
        super(rType);
        this.town = town;
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return this.child.addsQuestsWhenApplied();
    }

    @Override
    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBT_CHILD, MCReward.SERIALIZER.serializeNBT(this.child));
        return tag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        if (this.child != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.child = MCReward.SERIALIZER.deserializeNBT(entity, tag.m_128469_(NBT_CHILD));
    }

    @Override
    public Collection<MCReward> getContainedRewards() {
        return ImmutableList.of((Object)this.child);
    }

    public String toString() {
        return "MCDelayedReward{child=" + String.valueOf(this.child) + "}";
    }

    @Override
    public String toNiceString() {
        return "InMorning{" + this.child.toNiceString() + "}";
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return this.child.contains(reward);
    }
}

