/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.gui.QuestTypes;
import ca.bradj.questown.jobs.JobID;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class MCQuest
extends Quest<ResourceLocation, MCRoom> {
    public static final Serializer SERIALIZER = new Serializer();

    MCQuest() {
    }

    private MCQuest(UUID batchUUID, @Nullable VillagerUUID ownerId, ResourceLocation wantedRecipe, @Nullable ResourceLocation fromRecipe) {
        this(batchUUID, ownerId, wantedRecipe, fromRecipe, Quest.QuestType.ROOM, 1);
    }

    private MCQuest(UUID batchUUID, VillagerUUID ownerId, ResourceLocation wantedRecipe, @Nullable ResourceLocation fromRecipe, Quest.QuestType questType, int count) {
        super(batchUUID, ownerId, wantedRecipe, fromRecipe, questType, count);
    }

    public static MCQuest standalone(UUID batchUUID, @Nullable VillagerUUID ownerId, ResourceLocation recipeId) {
        return new MCQuest(batchUUID, ownerId, recipeId, null, Quest.QuestType.ROOM, 1);
    }

    public static MCQuest upgrade(UUID batchUUID, @Nullable VillagerUUID ownerId, ResourceLocation oldRecipeId, ResourceLocation newRecipeId) {
        return new MCQuest(batchUUID, ownerId, newRecipeId, oldRecipeId, Quest.QuestType.ROOM, 1);
    }

    public static MCQuest item(UUID batchUUID, @Nullable VillagerUUID ownerId, ResourceLocation itemId, int count) {
        return new MCQuest(batchUUID, ownerId, itemId, null, Quest.QuestType.ITEM, count);
    }

    public static MCQuest jobChange(UUID batchUUID, @Nullable VillagerUUID ownerId, JobID jobId) {
        ResourceLocation rl = JobID.toRL(jobId);
        return MCQuest.jobChange(batchUUID, ownerId, rl);
    }

    public static MCQuest jobChange(UUID batchUUID, @Nullable VillagerUUID ownerId, ResourceLocation jobId) {
        return new MCQuest(batchUUID, ownerId, jobId, null, Quest.QuestType.JOB_CHANGE, 1);
    }

    public MCQuest completed(@Nullable MCRoom room) {
        MCQuest q = new MCQuest(this.batchUUID, this.ownerUUID, (ResourceLocation)this.getWantedId(), this.fromRecipeID().orElse(null), this.getType(), this.getCountNeeded());
        q.ownerUUID = this.ownerUUID;
        q.status = Quest.QuestStatus.COMPLETED;
        q.completedOn = room;
        return q;
    }

    public MCQuest lost() {
        MCQuest q = new MCQuest(this.batchUUID, this.ownerUUID, (ResourceLocation)this.getWantedId(), this.fromRecipeID().orElse(null), Quest.QuestType.ROOM, 1);
        q.ownerUUID = this.ownerUUID;
        q.status = Quest.QuestStatus.ACTIVE;
        q.completedOn = null;
        return q;
    }

    public static class Serializer {
        private static final String NBT_UUID = "UUID";
        private static final String NBT_RECIPE_TYPE = "recipe_type";
        private static final String NBT_COUNT = "count";
        private static final String NBT_RECIPE_ID = "recipe_id";
        private static final String NBT_FROM_RECIPE_ID = "from_recipe_id";
        private static final String NBT_STATUS = "status";
        private static final String NBT_COMPLETED_ON_DOORPOS_X = "doorpos_x";
        private static final String NBT_COMPLETED_ON_DOORPOS_Y = "doorpos_y";
        private static final String NBT_COMPLETED_ON_DOORPOS_Z = "doorpos_z";
        private static final String NBT_COMPLETED_ON_AA_X = "aa_x";
        private static final String NBT_COMPLETED_ON_AA_Z = "aa_z";
        private static final String NBT_COMPLETED_ON_BB_X = "bb_x";
        private static final String NBT_COMPLETED_ON_BB_Z = "bb_z";

        public CompoundTag serializeNBT(Quest<ResourceLocation, MCRoom> quest) {
            CompoundTag ct = new CompoundTag();
            if (quest.getUUID() != null) {
                quest.getUUID().writeToNBT(ct, NBT_UUID);
            }
            ct.m_128365_(NBT_RECIPE_TYPE, QuestTypes.serializeNBT(quest.getType()));
            ct.m_128405_(NBT_COUNT, quest.getCountNeeded());
            ct.m_128359_(NBT_RECIPE_ID, quest.getWantedId().toString());
            ct.m_128359_(NBT_STATUS, quest.getStatus().name());
            if (quest.completedOn != null) {
                ct.m_128405_(NBT_COMPLETED_ON_DOORPOS_X, ((MCRoom)quest.completedOn).getDoorPos().x);
                ct.m_128405_(NBT_COMPLETED_ON_DOORPOS_Y, ((MCRoom)quest.completedOn).yCoord);
                ct.m_128405_(NBT_COMPLETED_ON_DOORPOS_Z, ((MCRoom)quest.completedOn).getDoorPos().z);
                this.putSpace(quest, ct);
            }
            if (quest.fromRecipeID().isPresent()) {
                ct.m_128359_(NBT_FROM_RECIPE_ID, quest.fromRecipeID().get().toString());
            }
            return ct;
        }

        private void putSpace(Quest<ResourceLocation, MCRoom> quest, CompoundTag ct) {
            ct.m_128405_(NBT_COMPLETED_ON_AA_X, ((MCRoom)quest.completedOn).getSpace().getWestX());
            ct.m_128405_(NBT_COMPLETED_ON_AA_Z, ((MCRoom)quest.completedOn).getSpace().getNorthZ());
            ct.m_128405_(NBT_COMPLETED_ON_BB_X, ((MCRoom)quest.completedOn).getSpace().getEastX());
            ct.m_128405_(NBT_COMPLETED_ON_BB_Z, ((MCRoom)quest.completedOn).getSpace().getSouthZ());
        }

        public MCQuest deserializeNBT(CompoundTag nbt) {
            MCQuest quest = new MCQuest();
            VillagerUUID uuid = null;
            if (nbt.m_128441_(NBT_UUID)) {
                uuid = VillagerUUID.fromNBT(nbt, NBT_UUID);
            }
            Quest.QuestType type = Quest.QuestType.ROOM;
            if (nbt.m_128441_(NBT_RECIPE_TYPE)) {
                type = QuestTypes.deserializeNBT(nbt.m_128469_(NBT_RECIPE_TYPE));
            }
            int count = 1;
            if (nbt.m_128441_(NBT_COUNT)) {
                count = nbt.m_128451_(NBT_COUNT);
            }
            ResourceLocation recipeId = new ResourceLocation(nbt.m_128461_(NBT_RECIPE_ID));
            Quest.QuestStatus status = Quest.QuestStatus.valueOf(nbt.m_128461_(NBT_STATUS));
            int doorX = nbt.m_128451_(NBT_COMPLETED_ON_DOORPOS_X);
            int doorY = nbt.m_128451_(NBT_COMPLETED_ON_DOORPOS_Y);
            int doorZ = nbt.m_128451_(NBT_COMPLETED_ON_DOORPOS_Z);
            int aaX = nbt.m_128451_(NBT_COMPLETED_ON_AA_X);
            int aaZ = nbt.m_128451_(NBT_COMPLETED_ON_AA_Z);
            int bbX = nbt.m_128451_(NBT_COMPLETED_ON_BB_X);
            int bbZ = nbt.m_128451_(NBT_COMPLETED_ON_BB_Z);
            Position doorPos = new Position(doorX, doorZ);
            InclusiveSpace space = InclusiveSpace.from((int)aaX, (int)aaZ).to(bbX, bbZ);
            ResourceLocation fromRecipeId = null;
            if (nbt.m_128441_(NBT_FROM_RECIPE_ID)) {
                fromRecipeId = new ResourceLocation(nbt.m_128461_(NBT_FROM_RECIPE_ID));
            }
            quest.initialize(uuid, type, count, recipeId, status, new MCRoom(doorPos, (Collection)ImmutableList.of((Object)space), doorY), fromRecipeId);
            return quest;
        }
    }
}

