/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCQuest;
import ca.bradj.questown.town.quests.MCQuestBatch;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.QuestBatches;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class MCQuestBatches
extends QuestBatches<ResourceLocation, MCRoom, MCQuest, MCReward, MCQuestBatch> {
    public static final Serializer SERIALIZER = new Serializer();

    public MCQuestBatches(QuestBatches.Factory<MCQuestBatch, MCReward> factory) {
        super(factory);
    }

    public ImmutableList<MCQuestBatch> getAllBatches() {
        return ImmutableList.copyOf((Collection)this.batches);
    }

    public static class Serializer {
        private static final String NBT_NUM_BATCHES = "num_quest_batches";
        private static final String NBT_BATCHES = "quest_batches";

        public CompoundTag serializeNBT(MCQuestBatches batches) {
            CompoundTag ct = new CompoundTag();
            ImmutableList qb = ImmutableList.copyOf((Collection)batches.batches);
            ct.m_128405_(NBT_NUM_BATCHES, qb.size());
            ListTag aq = new ListTag();
            for (MCQuestBatch q : qb) {
                aq.add((Object)MCQuestBatch.SERIALIZER.serializeNBT(q));
            }
            ct.m_128365_(NBT_BATCHES, (Tag)aq);
            return ct;
        }

        public boolean deserializeNBT(TownInterface entity, CompoundTag nbt, MCQuestBatches batches) {
            ImmutableList.Builder aqs = ImmutableList.builder();
            int num = nbt.m_128451_(NBT_NUM_BATCHES);
            ListTag aq = nbt.m_128437_(NBT_BATCHES, 10);
            for (int i = 0; i < num; ++i) {
                CompoundTag tag = aq.m_128728_(i);
                MCQuestBatch q = MCQuestBatch.SERIALIZER.deserializeNBT(entity, tag);
                aqs.add((Object)q);
            }
            ImmutableList build = aqs.build();
            if (build.isEmpty() || build.stream().allMatch(v -> v.getAll().isEmpty())) {
                return false;
            }
            batches.initialize(entity, build);
            return true;
        }
    }
}

