/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.Registry;
import ca.bradj.questown.town.rewards.RewardType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class MCReward
extends Reward {
    public static final Serializer SERIALIZER = new Serializer();
    public final RewardType<? extends MCReward> rType;

    public MCReward(RewardType<? extends MCReward> rType) {
        this.rType = rType;
    }

    @Override
    protected String getName() {
        return this.rType.id.toString();
    }

    public abstract String toNiceString();

    public abstract boolean contains(@NotNull RewardType<?> var1);

    protected abstract CompoundTag serializeNbt();

    protected abstract void deserializeNbt(TownInterface var1, CompoundTag var2);

    public static class Serializer {
        private static final String NBT_REWARD_TYPE = "reward_type";
        private static final String NBT_REWARD_DATA = "reward_data";
        private static final String NBT_REWARD_APPLIED = "reward_applied";

        public MCReward deserializeNBT(TownInterface entity, CompoundTag tag) {
            ResourceLocation rewardType = new ResourceLocation(tag.m_128461_(NBT_REWARD_TYPE));
            RewardType rType = (RewardType)Registry.REWARD_TYPES.getValue(rewardType);
            if (rType == null) {
                rType = (RewardType)RewardsInit.VISITOR.get();
            }
            Object r = rType.create(rType, entity);
            ((MCReward)r).deserializeNbt(entity, tag.m_128469_(NBT_REWARD_DATA));
            if (tag.m_128441_(NBT_REWARD_APPLIED) && tag.m_128471_(NBT_REWARD_APPLIED)) {
                ((Reward)r).markApplied();
            }
            return r;
        }

        public Tag serializeNBT(MCReward reward) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(NBT_REWARD_TYPE, reward.rType.id.toString());
            tag.m_128365_(NBT_REWARD_DATA, (Tag)reward.serializeNbt());
            tag.m_128379_(NBT_REWARD_APPLIED, reward.isApplied());
            return tag;
        }
    }
}

