/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.QT;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.town.quests.Quest;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.roomrecipes.core.Room;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestBatch<KEY, ROOM extends Room, QUEST extends Quest<KEY, ROOM>, REWARD extends Reward> {
    private final List<QUEST> quests = new ArrayList<QUEST>();
    private final Quest.QuestFactory<KEY, ROOM, QUEST> questFactory;
    @NotNull
    protected REWARD reward;
    private ChangeListener<QUEST> changeListener = new ChangeListener<QUEST>(){

        @Override
        public void questCompleted(QUEST quest) {
        }

        @Override
        public void questBatchCompleted(QuestBatch<?, ?, ?, ?> quest) {
        }

        @Override
        public void questLost(QUEST foundQuest) {
        }
    };
    private UUID batchUUID;

    QuestBatch(Quest.QuestFactory<KEY, ROOM, QUEST> qf, @NotNull REWARD reward, @NotNull UUID batchUUID) {
        this.questFactory = qf;
        this.reward = reward;
        this.batchUUID = batchUUID;
    }

    public static <R extends Room, Q extends Quest<?, R>> Stream<Q> stream(QuestBatch<?, R, Q, ?> batch) {
        return batch.quests.stream();
    }

    @Nullable
    private static UUID dep(@Nullable VillagerUUID ownerId) {
        return VillagerUUID.get(ownerId);
    }

    public void addChangeListener(ChangeListener<QUEST> changeListener) {
        this.changeListener = changeListener;
    }

    public Collection<KEY> getCompletedRecipeIDs() {
        return this.quests.stream().filter(Quest::isComplete).map(Quest::getWantedId).toList();
    }

    public void addNewQuest(@Nullable VillagerUUID ownerId, KEY id) {
        this.quests.add(this.questFactory.newQuest(QuestBatch.dep(ownerId), id));
    }

    public void addJobChangeQuest(KEY id) {
        this.quests.add(this.questFactory.newJobQuest(id));
    }

    public void addNewUpgradeQuest(@Nullable VillagerUUID ownerId, KEY fromID, KEY toID) {
        this.quests.add(this.questFactory.newUpgradeQuest(QuestBatch.dep(ownerId), fromID, toID));
    }

    public void addItemQuest(@Nullable VillagerUUID ownerId, KEY itemId, int count) {
        this.quests.add(this.questFactory.newItemQuest(QuestBatch.dep(ownerId), itemId, count));
    }

    public ImmutableList<QUEST> getAll() {
        return ImmutableList.copyOf(this.quests);
    }

    void initialize(@Nullable UUID batchUUID, Collection<QUEST> aqs, REWARD reward) {
        if (!this.quests.isEmpty()) {
            throw new IllegalStateException("Quests already initialized");
        }
        this.batchUUID = batchUUID;
        this.quests.addAll(aqs.stream().peek(v -> {
            v.batchUUID = batchUUID;
        }).toList());
        this.reward = reward;
    }

    public boolean markRecipeAsComplete(ROOM room, KEY recipe) {
        Stream<Quest> matches = this.quests.stream().filter(v -> recipe.equals(v.getWantedId()));
        Optional<Quest> incomplete = matches.filter(v -> !v.isComplete()).findFirst();
        if (incomplete.isEmpty()) {
            return false;
        }
        Quest quest = incomplete.get();
        this.quests.remove(quest);
        Quest updated = this.questFactory.completed(room, quest);
        this.quests.add(updated);
        this.changeListener.questCompleted(updated);
        incomplete = this.quests.stream().filter(v -> !v.isComplete()).findFirst();
        if (incomplete.isEmpty()) {
            ((Reward)this.reward).claim();
            this.changeListener.questBatchCompleted(this);
        }
        return true;
    }

    public boolean canMarkRecipeAsConverted(KEY oldRecipeID, KEY newRecipeID) {
        Stream<Quest> newMatches = this.quests.stream().filter(v -> newRecipeID.equals(v.getWantedId()));
        Optional<Quest> incomplete = newMatches.filter(Predicate.not(Quest::isComplete)).findFirst();
        return incomplete.isPresent() && incomplete.get().fromRecipeID().map(v -> v.equals(oldRecipeID)).orElse(false) != false;
    }

    public boolean markRecipeAsConverted(ROOM newRoom, KEY oldRecipeID, KEY newRecipeID) {
        Stream<Quest> newMatches = this.quests.stream().filter(v -> newRecipeID.equals(v.getWantedId()));
        Optional<Quest> incomplete = newMatches.filter(Predicate.not(Quest::isComplete)).findFirst();
        if (incomplete.isEmpty()) {
            return false;
        }
        Quest converted = incomplete.get();
        Optional fr = converted.fromRecipeID();
        if (fr.isEmpty() || !fr.get().equals(oldRecipeID)) {
            return false;
        }
        this.quests.remove(converted);
        Quest convCompleted = this.questFactory.completed(newRoom, converted);
        this.quests.add(convCompleted);
        this.changeListener.questCompleted(convCompleted);
        incomplete = this.quests.stream().filter(v -> !v.isComplete()).findFirst();
        if (incomplete.isEmpty()) {
            ((Reward)this.reward).claim();
            this.changeListener.questBatchCompleted(this);
        }
        return true;
    }

    public REWARD getReward() {
        return this.reward;
    }

    public void setReward(REWARD reward) {
        this.reward = reward;
    }

    public int size() {
        return this.quests.size();
    }

    public void changeRoomOnly(ROOM oldRoom, ROOM newRoom) {
        ImmutableList snapshot = ImmutableList.copyOf(this.quests);
        this.quests.clear();
        this.quests.addAll(snapshot.stream().peek(v -> {
            if (oldRoom.equals(v.completedOn)) {
                QT.QUESTS_LOGGER.debug("Quest completion room updated after room size change. {} -> {}", oldRoom, newRoom);
                v.completedOn = newRoom;
            }
        }).toList());
    }

    @Nullable
    public QUEST findMatch(ROOM room, KEY oldRecipeID) {
        Optional<Quest> found = this.quests.stream().filter(v -> room.equals(v.completedOn) && oldRecipeID.equals(v.recipeId)).findFirst();
        return (QUEST)((Quest)found.orElse(null));
    }

    public void markConsumed(QUEST match) {
        this.quests.remove(match);
    }

    public boolean markRecipeAsLost(@NotNull ROOM oldRoom, @NotNull KEY recipeID) {
        Quest foundQuest = null;
        for (Quest q : this.quests) {
            if (!oldRoom.equals(q.completedOn) || !recipeID.equals(q.getWantedId())) continue;
            foundQuest = q;
            break;
        }
        if (foundQuest == null) {
            return false;
        }
        if (this.quests.remove(foundQuest)) {
            this.quests.add(this.questFactory.lost(foundQuest));
            this.changeListener.questLost(foundQuest);
            return true;
        }
        return false;
    }

    @Nullable
    public VillagerUUID getUUID() {
        if (this.quests.isEmpty()) {
            return null;
        }
        return ((Quest)this.quests.get(0)).getUUID();
    }

    public String toString() {
        return "QuestBatch[ID=" + String.valueOf(this.batchUUID) + "]{quests=" + String.join((CharSequence)", ", this.quests.stream().map(Object::toString).toList()) + ", reward=" + String.valueOf(this.reward) + ", questFactory=" + String.valueOf(this.questFactory) + ", changeListener=" + String.valueOf(this.changeListener) + "}";
    }

    public void assignTo(@NotNull VillagerUUID owner) {
        for (Quest q : this.quests) {
            q.ownerUUID = owner;
        }
    }

    public UUID getBatchUUID() {
        return this.batchUUID;
    }

    @Nullable
    public String getCompletionMessage() {
        return null;
    }

    public static interface ChangeListener<QUEST extends Quest<?, ?>> {
        public void questCompleted(QUEST var1);

        public void questBatchCompleted(QuestBatch<?, ?, ?, ?> var1);

        public void questLost(QUEST var1);
    }
}

