/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.quests;

import ca.bradj.questown.QT;
import org.jetbrains.annotations.NotNull;

public abstract class Reward {
    private boolean applied;

    protected void markApplied() {
        this.applied = true;
    }

    void claim() {
        if (this.applied) {
            QT.LOGGER.error("Refusing to apply reward more than once: {}", (Object)this.getName());
            return;
        }
        this.getApplier().apply();
        this.applied = true;
    }

    public boolean isApplied() {
        return this.applied;
    }

    protected abstract String getName();

    @NotNull
    protected abstract RewardApplier getApplier();

    public abstract boolean addsQuestsWhenApplied();

    public static interface RewardApplier {
        public void apply();
    }
}

