/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rewards;

import ca.bradj.questown.core.UtilClean;
import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddBatchOfQuestsForVisitorReward
extends MCReward {
    public static final String ID = "add_random_batch_of_quests";
    private static final String NBT_VISITOR_UUID = "visitor_uuid";
    private final TownInterface town;
    @Nullable
    private VillagerUUID visitorUUID;

    public AddBatchOfQuestsForVisitorReward(RewardType<? extends MCReward> rType, @NotNull TownInterface entity, @Nullable UUID visitorUUID) {
        super(rType);
        this.visitorUUID = VillagerUUID.from(visitorUUID);
        this.town = entity;
    }

    public AddBatchOfQuestsForVisitorReward(@NotNull TownInterface entity, @Nullable UUID visitorUUID) {
        this((RewardType)RewardsInit.RANDOM_BATCH_FOR_VILLAGER.get(), entity, visitorUUID);
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> this.town.getQuestHandle().addBatchOfQuestsForVisitor(this.visitorUUID);
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return true;
    }

    @Override
    protected CompoundTag serializeNbt() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.visitorUUID != null) {
            this.visitorUUID.writeToNBT(compoundTag, NBT_VISITOR_UUID);
        }
        return compoundTag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        if (tag.m_128441_(NBT_VISITOR_UUID)) {
            this.visitorUUID = VillagerUUID.fromNBT(tag, NBT_VISITOR_UUID);
        }
    }

    public String toString() {
        return "AddBatchOfRandomQuestsForVisitorReward{town=" + String.valueOf(this.town.getUUID()) + ", visitorUUID=" + String.valueOf(this.visitorUUID) + "}";
    }

    @Override
    public String toNiceString() {
        String vid = this.visitorUUID == null ? "unowned" : this.visitorUUID.toString();
        return "AddRandomQuestBatch[" + UtilClean.truncateMiddle(vid) + "]";
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return ((RewardType)RewardsInit.RANDOM_BATCH_FOR_VILLAGER.get()).equals(reward);
    }
}

