/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rewards;

import ca.bradj.questown.core.VillagerUUID;
import ca.bradj.questown.core.init.RewardsInit;
import ca.bradj.questown.town.interfaces.TownInterface;
import ca.bradj.questown.town.quests.MCReward;
import ca.bradj.questown.town.quests.Reward;
import ca.bradj.questown.town.rewards.RewardType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class AddRandomUpgradeQuest
extends MCReward {
    public static final String ID = "add_random_upgrade_quest";
    private static final String NBT_VISITOR_UUID = "visitor_uuid";
    private final TownInterface town;
    private VillagerUUID visitorUUID;

    private AddRandomUpgradeQuest(RewardType<? extends MCReward> rType, @NotNull TownInterface entity, VillagerUUID visitorUUID) {
        super(rType);
        this.visitorUUID = visitorUUID;
        this.town = entity;
    }

    @Deprecated(forRemoval=true)
    public AddRandomUpgradeQuest(@NotNull TownInterface entity, @NotNull UUID visitorUUID) {
        this((RewardType<? extends MCReward>)((RewardType)RewardsInit.RANDOM_UPGRADE_FOR_VILLAGER.get()), entity, VillagerUUID.from(visitorUUID));
    }

    public AddRandomUpgradeQuest(@NotNull TownInterface entity, @NotNull VillagerUUID visitorUUID) {
        this((RewardType<? extends MCReward>)((RewardType)RewardsInit.RANDOM_UPGRADE_FOR_VILLAGER.get()), entity, visitorUUID);
    }

    public AddRandomUpgradeQuest(RewardType<? extends MCReward> rType, TownInterface flag, RewardsInit reg) {
        this(rType, flag, (VillagerUUID)null);
    }

    @Override
    @NotNull
    protected Reward.RewardApplier getApplier() {
        return () -> this.town.getQuestHandle().addRandomUpgradeQuestForVisitor(this.visitorUUID);
    }

    @Override
    public boolean addsQuestsWhenApplied() {
        return true;
    }

    @Override
    protected CompoundTag serializeNbt() {
        CompoundTag compoundTag = new CompoundTag();
        this.visitorUUID.writeToNBT(compoundTag, NBT_VISITOR_UUID);
        return compoundTag;
    }

    @Override
    protected void deserializeNbt(TownInterface entity, CompoundTag tag) {
        if (tag.m_128441_(NBT_VISITOR_UUID)) {
            this.visitorUUID = VillagerUUID.fromNBT(tag, NBT_VISITOR_UUID);
        }
    }

    @Override
    public String toNiceString() {
        return "AddRandomUpgradeQuest";
    }

    @Override
    public boolean contains(@NotNull RewardType<?> reward) {
        return this.rType.equals(reward);
    }
}

