/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.questown.town.rooms;

import ca.bradj.questown.core.Config;
import ca.bradj.questown.town.entity.TownRooms;
import ca.bradj.questown.town.rooms.TownPosition;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.LevelRoomDetector;
import ca.bradj.roomrecipes.recipes.ActiveRecipes;
import ca.bradj.roomrecipes.recipes.RecipeDetection;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLevelRoomDetector {
    private final ServerLevel level;
    private final Map<Position, Optional<MCRoom>> foundRooms = new HashMap<Position, Optional<MCRoom>>();
    private final LinkedBlockingQueue<RoomWithlevel> roomsToScan = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<DetectorWithLevel> roomDetectors = new LinkedBlockingQueue();
    private final Function<Integer, ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>> recipes;
    private final int flagY;
    private final Predicate<TownPosition> isDoor;
    private final BiConsumer<Integer, ImmutableMap<Position, Optional<MCRoom>>> newRoomsHandler;
    @Nullable
    private Long trueStart;
    private BiConsumer<Integer, ImmutableMap<Position, String>> artSink;

    public void setArtSink(BiConsumer<Integer, ImmutableMap<Position, String>> artSink) {
        this.artSink = artSink;
    }

    public MultiLevelRoomDetector(ServerLevel level, int flagY, Predicate<TownPosition> isWall, Predicate<TownPosition> isDoor, BiConsumer<Integer, ImmutableMap<Position, Optional<MCRoom>>> newRoomsHandler, Function<Integer, ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>>> getRecipes, Map<Integer, Collection<Position>> doorsAtLevel, boolean enableDebugArt) {
        this.isDoor = isDoor;
        this.newRoomsHandler = newRoomsHandler;
        this.level = level;
        this.flagY = flagY;
        this.recipes = getRecipes;
        doorsAtLevel.forEach((yOffset, doors) -> this.roomDetectors.add(new DetectorWithLevel(new LevelRoomDetector(doors, ((Integer)Config.MAX_ROOM_DIMENSION.get()).intValue(), ((Integer)Config.MAX_ROOM_SCAN_ITERATIONS.get()).intValue(), p -> isWall.test(new TownPosition(p.x, p.z, (int)yOffset)), enableDebugArt, null), (Integer)yOffset)));
    }

    public boolean proceed(Function<Integer, @Nullable TownRooms> currentRoomsAtYOffset) {
        if (this.trueStart == null) {
            this.trueStart = System.currentTimeMillis();
        }
        if (this.roomDetectors.isEmpty() && this.roomsToScan.isEmpty() && this.foundRooms.isEmpty()) {
            return true;
        }
        if (!this.roomDetectors.isEmpty()) {
            DetectorWithLevel nextDetector = (DetectorWithLevel)this.roomDetectors.remove();
            TownRooms cur = currentRoomsAtYOffset.apply(nextDetector.scanLevel);
            @Nullable ImmutableMap result = cur != null ? nextDetector.detector.proceed(p -> cur.get((Position)p).map(v -> v)) : nextDetector.detector.proceed();
            if (result != null) {
                ImmutableMap<Position, Optional<MCRoom>> build = this.handleNewRooms((ImmutableMap<Position, Optional<Room>>)result, nextDetector.scanLevel);
                this.newRoomsHandler.accept(nextDetector.scanLevel, build);
                if (this.artSink != null) {
                    this.artSink.accept(nextDetector.scanLevel, (ImmutableMap<Position, String>)nextDetector.detector.getDebugArt(true));
                }
            } else {
                this.roomDetectors.add(nextDetector);
            }
        }
        if (!this.roomsToScan.isEmpty()) {
            RoomWithlevel room = (RoomWithlevel)this.roomsToScan.remove();
            Optional recipe = RecipeDetection.getActiveRecipes((Level)this.level, (MCRoom)room.room, (boolean)false);
            ActiveRecipes<MCRoom, RoomRecipeMatch<MCRoom>> rs = this.recipes.apply(room.scanLevel);
            rs.update((Room)room.room, (Room)room.room, (Object)recipe.orElse(null));
            return false;
        }
        return false;
    }

    @NotNull
    private ImmutableMap<Position, Optional<MCRoom>> handleNewRooms(@NotNull ImmutableMap<Position, Optional<Room>> result, int scanLevel) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        result.forEach((k, v) -> {
            Optional<MCRoom> value = v.map(z -> {
                MCRoom mcRoom = new MCRoom(z.getDoorPos(), (Collection)z.getSpaces(), this.flagY + scanLevel);
                return mcRoom;
            });
            b.put(k, value);
            value.ifPresent(r -> this.roomsToScan.add(new RoomWithlevel((MCRoom)r, scanLevel)));
        });
        ImmutableMap build = b.build();
        return build;
    }

    private record DetectorWithLevel(LevelRoomDetector detector, Integer scanLevel) {
    }

    private record RoomWithlevel(MCRoom room, Integer scanLevel) {
    }
}

