# =========================
# Variant: Deep Backrooms Complex (LARGE, multi-layer labyrinth)
# Area: ~ -70..+70 horizontally, vertical layers from y=1..y=30
tellraw @p {"text":"[AI World — Deep Backrooms] Generating (large multi-layer labyrinth)...","color":"gold"}

# create the overall shell (big box) to contain labyrinth spaces
execute at @p run fill ~-70 ~0 ~-70 ~70 ~30 ~70 minecraft:yellow_concrete_powder

# carve multiple layers of corridors by filling with air in patterns
# main entrance hall
execute at @p run fill ~-68 ~1 ~-2 ~-40 ~6 ~2 minecraft:air
# long winding corridors (three different wings)
execute at @p run fill ~-36 ~1 ~-30 ~-24 ~8 ~-6 minecraft:air
execute at @p run fill ~-20 ~1 ~10 ~0 ~10 ~26 minecraft:air
execute at @p run fill ~4 ~1 ~-64 ~40 ~8 ~-40 minecraft:air

# create low ceilings and carpet (to be eerie)
execute at @p run fill ~-68 ~4 ~-68 ~68 ~4 ~68 minecraft:white_carpet
execute at @p run fill ~-68 ~3 ~-68 ~68 ~3 ~68 minecraft:yellow_concrete

# break-up spaces with 'pocket rooms' and details
execute at @p run fill ~-56 ~1 ~-56 ~-40 ~6 ~-40 minecraft:red_concrete
execute at @p run setblock ~-48 ~2 ~-48 minecraft:chest[facing=south]{Items:[{Slot:0b,id:"minecraft:map",Count:1b},{Slot:1b,id:"minecraft:compass",Count:1b}]}
execute at @p run fill ~12 ~1 ~12 ~22 ~6 ~22 minecraft:blue_concrete
execute at @p run setblock ~16 ~2 ~16 minecraft:barrel[facing=north]

# flickering lights (sea lanterns + random air pockets with armor stands)
execute at @p run setblock ~-60 ~4 ~-60 minecraft:sea_lantern
execute at @p run setblock ~-20 ~4 ~-20 minecraft:sea_lantern
execute at @p run setblock ~20 ~4 ~20 minecraft:sea_lantern
execute at @p run summon minecraft:armor_stand ~-44 ~1 ~-24 {NoGravity:1b,Invisible:1b,ShowArms:0b}

# broken furniture & crates
execute at @p run setblock ~-30 ~1 ~-18 minecraft:bookshelf
execute at @p run setblock ~-28 ~1 ~-16 minecraft:barrel[facing=east]
execute at @p run setblock ~-26 ~1 ~-14 minecraft:lectern

# trapped alcove with hostile spawn (dangerous room)
execute at @p run fill ~38 ~1 ~-50 ~46 ~5 ~-42 minecraft:stone_bricks
execute at @p run summon minecraft:evoker ~42 ~2 ~-46
execute at @p run summon minecraft:vex ~42 ~3 ~-46
execute at @p run setblock ~40 ~2 ~-44 minecraft:chest[facing=west]{Items:[{Slot:0b,id:"minecraft:golden_apple",Count:1b},{Slot:1b,id:"minecraft:iron_sword",Count:1b}]}

# elevator shaft / vertical pillar rooms to emphasize scale
execute at @p run fill ~-4 ~1 ~-4 ~4 ~28 ~4 minecraft:air
execute at @p run setblock ~0 ~0 ~0 minecraft:stone

# signs of previous explorers (using lecterns + books)
execute at @p run setblock ~-10 ~1 ~-8 minecraft:lectern
execute at @p run setblock ~-12 ~1 ~-6 minecraft:lectern

# ambient mobs scattered
execute at @p run summon minecraft:zombie ~10 ~1 ~-10
execute at @p run summon minecraft:skeleton ~-14 ~1 ~12
execute at @p run summon minecraft:spider ~-22 ~1 ~34

tellraw @p {"text":"[AI World — Deep Backrooms] Done. Maze scale large — bring torches and maps.","color":"dark_purple"}
# =========================