/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.rendering;

import eva.replacer.RePlacerClient;
import eva.replacer.config.RePlacerConfig;
import eva.replacer.rendering.BoundingBoxMerger;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import java.util.Collection;
import java.util.HashSet;
import java.util.OptionalDouble;
import net.minecraft.class_10142;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class BlockHighlightRenderer {
    private static final class_1921 LINES_NORMAL = class_1921.method_24049((String)"replacer_buildbox_normal", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_29344, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(class_10142.field_53876)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(class_4668.field_21352).method_23615(class_4668.field_21370).method_23616(class_4668.field_21350).method_23603(class_4668.field_21344).method_23617(false));
    private static final class_1921 LINES_TRANSPARENT = class_1921.method_24049((String)"replacer_buildbox_transparent", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_29344, (int)1536, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(class_10142.field_53876)).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(class_4668.field_21352).method_23615(class_4668.field_21370).method_23616(class_4668.field_21349).method_23603(class_4668.field_21344).method_23604(class_4668.field_21346).method_23617(false));

    public static boolean renderRePlacerBox(class_4587 poseStack) {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        class_746 player = mc.field_1724;
        if (level == null || player == null) {
            return true;
        }
        if (!RePlacerClient.isHeldOrToggled()) {
            return true;
        }
        class_239 result = mc.field_1765;
        if (result == null || result.method_17783() != class_239.class_240.field_1332) {
            return true;
        }
        class_3965 blockRes = (class_3965)result;
        class_2338 origin = blockRes.method_17777().method_10093(blockRes.method_17780());
        HashSet<class_2338> blocksToHighlight = new HashSet<class_2338>();
        RelPos.setBase(origin);
        BuildHolder.setBaseDir(blockRes.method_17780());
        BuildHolder.setFacing(player.method_5735());
        try {
            BuildHolder holder = RePlacerConfig.getBuild();
            holder.rotateEach(ros -> blocksToHighlight.add(ros.pos()));
        }
        catch (NullPointerException ignored) {
            blocksToHighlight.add(origin);
        }
        if (blocksToHighlight.isEmpty()) {
            return true;
        }
        class_4184 renderInfo = mc.field_1773.method_19418();
        class_243 projectedView = renderInfo.method_19326();
        assert (poseStack != null);
        poseStack.method_22903();
        poseStack.method_22904((double)origin.method_10263() - projectedView.field_1352, (double)origin.method_10264() - projectedView.field_1351, (double)origin.method_10260() - projectedView.field_1350);
        Matrix4f matrix = poseStack.method_23760().method_23761();
        HashSet<class_265> shapes = new HashSet<class_265>();
        for (class_238 aabb : BoundingBoxMerger.merge(blocksToHighlight.stream().toList(), origin)) {
            shapes.add(class_259.method_1078((class_238)aabb.method_1014(0.005)));
        }
        class_4597.class_4598 buffers = mc.method_22940().method_23000();
        class_4588 vertexBuilder2 = buffers.getBuffer(LINES_TRANSPARENT);
        BlockHighlightRenderer.orShapes(shapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            double dx = x2 - x1;
            double dy = y2 - y1;
            double dz = z2 - z1;
            double invMag = 1.0 / Math.sqrt(dx * dx + dy * dy + dz * dz);
            float nx = (float)(dx * invMag);
            float ny = (float)(dy * invMag);
            float nz = (float)(dz * invMag);
            class_4587.class_4665 pose = poseStack.method_23760();
            vertexBuilder2.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_1336(10, 206, 245, 180).method_60831(pose, nx, ny, nz);
            vertexBuilder2.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_1336(10, 206, 245, 180).method_60831(pose, nx, ny, nz);
        });
        buffers.method_22994(LINES_TRANSPARENT);
        class_4588 vertexBuilder = buffers.getBuffer(LINES_NORMAL);
        BlockHighlightRenderer.orShapes(shapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            vertexBuilder.method_22918(matrix, (float)x1, (float)y1, (float)z1).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
            vertexBuilder.method_22918(matrix, (float)x2, (float)y2, (float)z2).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        });
        buffers.method_22994(LINES_NORMAL);
        poseStack.method_22909();
        return false;
    }

    static class_265 orShapes(Collection<class_265> shapes) {
        class_265 combinedShape = class_259.method_1073();
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)shape, (class_247)class_247.field_1366);
        }
        return combinedShape;
    }
}

