package eva.replacer;

import eva.replacer.config.JsonConfigHelper;
import eva.replacer.config.RePlacerConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static eva.replacer.config.RePlacerConfig.*;

public class RePlacerClient implements ClientModInitializer {
    public static final String MOD_ID = RePlacerMain.MOD_ID + "-client";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    private static boolean modMenu = false;
    public static final class_304 MOD_BIND;
    public static final class_304 CYCLE_BIND;
    public static final class_304 MOD_TOGGLE;
    public static final class_304 REC_BUT;
    public static final class_304 MENU_BUT;
    private static final class_304.class_11900 CATEGORY = new class_304.class_11900(class_2960.method_43902("eva", "replacer"));
    static {
        MOD_BIND = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Modifier Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_LEFT_ALT,
                CATEGORY
        ));
        CYCLE_BIND = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Cycle Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_Z,
                CATEGORY
        ));
        MOD_TOGGLE = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Modifier Toggle Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                CATEGORY
        ));
        REC_BUT = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Record Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                CATEGORY
        ));
        MENU_BUT = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Menu Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                CATEGORY
        ));
    }

    @Override
    public void onInitializeClient() {
        modMenu = FabricLoader.getInstance().isModLoaded("modmenu");

        JsonConfigHelper.init();
        bindInit();
        serverCheckInit();

    }

    private static void bindInit() {
        // This entrypoint is suitable for setting up client-specific logic, such as rendering.

    }

    private static void serverCheckInit() {
        ClientConfigurationConnectionEvents.COMPLETE.register((handler, server) -> RePlacerConfig.isServer = !server.method_1542());
        ClientConfigurationConnectionEvents.DISCONNECT.register((handler, server) -> {
            RePlacerConfig.isServer = null;
            deny = true;
            saveBuild();
        });
    }

    public static boolean modMenu() {
        return modMenu;
    }

}