package eva.replacer.config;

import eva.replacer.RePlacerClient;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.FileNotFoundException;
import java.util.*;
import java.util.function.Function;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;

import static eva.replacer.RePlacerClient.getQuickAccess;
import static eva.replacer.RePlacerClient.isQuickAccess;
import static eva.replacer.config.JsonConfigHelper.*;

public class RePlacerConfig {
    static final int ver = 0;
    private final int v = ver;
    private boolean rotateFace = true;
    private boolean rotatePlace = true;
    private boolean inclTail = false;
    private boolean exclude = false;
    private String defBuild = "";
    private SortOrder sortOrder = SortOrder.Near_player_last;

    private static final List<String> names =  new ArrayList<>(List.of("square"));
    private static final List<String> disabled = new ArrayList<>();
    private static final List<String> taillessNames = new ArrayList<>();
    private static final List<String> taillessDisabled = new ArrayList<>();
    public static Boolean isServer;
    static int selection = 0;
    static boolean reCording = false;
    static String buildName;
    private static List<RelPos> tempBuild;
    private static RePlacerConfig INSTANCE;
    private static class_2350 placeDir;
    private static class_2350 faceDir;
    static boolean isHollow = false;
    public static boolean deny = false;
    private static final Map<Integer, String> quickAccess = new HashMap<>();

    private static Boolean listSideCombinedErrorChecker = null;
    private static Boolean boolSideCombinedErrorChecker = null;
    private static final Set<Integer> namesSideInts = new HashSet<>();
    private static final Set<Integer> disabledSideInts = new HashSet<>();

    static final String SPIN = "s";
    static final String SNAP = "f";
    static final String NO = "n";
    static final String DIS = "d";
    static final String DIV = "--";
    static final String REGEX = "[" + SPIN + SNAP + NO + DIS + "]";
    static final String REGEXNUM = "[1-9]";

    public static RePlacerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RePlacerConfig();
        }
        return INSTANCE;
    }

    void updateConfigs(@NotNull RePlacerConfig config) {
        this.rotateFace = config.rotateFace;
        this.rotatePlace = config.rotatePlace;
        this.inclTail = config.inclTail;
        this.defBuild = config.defBuild;
        this.exclude = config.exclude;
        this.sortOrder = config.sortOrder;
    }

    public static boolean isSpin() {
        MutableObject<String> mute = new MutableObject<>();
        if (getRelevantName(mute)) return false;
        String name = mute.getValue();
        if (!hasTail(name) || (!tail(name).toLowerCase().contains(NO) && !tail(name).toLowerCase().contains(SPIN))) return getInstance().rotateFace;
        return tail(name).toLowerCase().contains(SPIN);
    }
    static boolean spin() {
        return getInstance().rotateFace;
    }
    static void setSpin(boolean rotate) {
        getInstance().rotateFace = rotate;
    }

    public static boolean isSnap() {
        MutableObject<String> mute = new MutableObject<>();
        if (getRelevantName(mute)) return false;
        String name = mute.getValue();
        if (!hasTail(name) || (!tail(name).toLowerCase().contains(NO) && !tail(name).toLowerCase().contains(SNAP))) return getInstance().rotatePlace;
        return tail(name).toLowerCase().contains(SNAP);
    }
    static boolean snap() {
        return getInstance().rotatePlace;
    }
    static void setSnap(boolean rotate) {
        getInstance().rotatePlace = rotate;
    }

    public static List<String> getNames() {
        return new ArrayList<>(names);
    }
    static List<String> getTaillessNames() {
        return taillessNames;
    }

    static void setNames(List<String> newNames) {
        newNames = new ArrayList<>(new HashSet<>(newNames));
        if (newNames.isEmpty() || new HashSet<>(newNames).equals(new HashSet<>(names))) return;
        List<String> forRemoval = new ArrayList<>();
        Set<String> tempDisabled = new HashSet<>(disabled);
        for (String name : newNames) {
            if (hasTail(name) && tail(name).toLowerCase().contains(DIS)) {
                tempDisabled.add(name);
                forRemoval.add(name);
            }
        }
        newNames.removeAll(forRemoval);
        names.clear();
        names.addAll(newNames);
        taillessNames.clear();
        for (String name : names) {
            if (parseAccess(name) != -1) {
                quickAccess.put(parseAccess(name), name);
            }
            taillessNames.add(removeTail(name));
        }
        if (quickAccess.size() == names.size()) setExclude(false);
        if (!tempDisabled.equals(new HashSet<>(disabled))) setDisabled(new ArrayList<>(tempDisabled));
    }
    static List<String> getDisabled() {
        return disabled;
    }
    static List<String> getTaillessDisabled() {
        return taillessDisabled;
    }
    static void setDisabled(List<String> newDisabled) {
        newDisabled = new ArrayList<>(new HashSet<>(newDisabled));
        if (newDisabled.isEmpty() || new HashSet<>(newDisabled).equals(new HashSet<>(disabled))) return;
        List<String> tempNames = new ArrayList<>(getNames());
        List<String> tempDisabled = new ArrayList<>();
        List<String> tempTaillessDisabled = new ArrayList<>();
        for (String name : newDisabled) {
            if (!hasTail(name) || !tail(name).toLowerCase().contains(DIS))
                tempNames.add(removeTail(name));
            else {
                tempDisabled.add(name);
                tempTaillessDisabled.add(removeTail(name));
            }
        }
        disabled.clear();
        disabled.addAll(tempDisabled);
        taillessDisabled.clear();
        taillessDisabled.addAll(tempTaillessDisabled);
        if (!tempNames.equals(names)) setNames(tempNames);
    }

    public static String getDefBuild() {
        return getInstance().defBuild;
    }
    static void setDefBuild(String defBuild) {
        getInstance().defBuild = defBuild;
    }

    public static boolean isServer() {return isServer;}

    public static boolean isInclTail() {
        return getInstance().inclTail;
    }
    static void setInclTail(boolean inclTail) {
        getInstance().inclTail = inclTail;
    }
    
    static boolean isExclude() {
        return getInstance().exclude;
    }
    static void setExclude(boolean exclude) {
        getInstance().exclude = exclude;
    }

    public static SortOrder getSortOrder() {
        return getInstance().sortOrder;
    }

    static void setSortOrder(SortOrder sortOrder) {
        getInstance().sortOrder = sortOrder;
    }

    public static void cycleSelection(boolean isNeg, int i) {
        if (names.isEmpty()) {
            if (taillessDisabled.contains("square")) {
                String oldName = disabled.remove(taillessDisabled.indexOf("square"));
                taillessDisabled.remove("square");
                String newName = removeTail(oldName) + DIV + tail(oldName).toLowerCase().replace(DIS, "");
                names.add(newName);
                taillessNames.add("square");
                renameBuild(oldName, newName);
            } else {
                names.add("square");
                taillessNames.add("square");
            }
        }
        if (i > names.size()) return;
        if (isNeg) {
            selection--;
            if (selection < 0) selection = getNames().size() - 1;
        } else {
            selection++;
            selection %= getNames().size();
        }
        if (isExclude() && quickAccess.containsValue(names.get(selection))) cycleSelection(isNeg, i + 1);
    }

    public static int getSelection() {
        return selection;
    }

    public static void tareSelection() {
        selection = 0;
    }

    public static @Nullable BuildHolder handleGetBuild() {
        return isQuickAccess() ? getQuickBuild() : getBuild();
    }

    private static @Nullable BuildHolder getBuild() {
        try {
            String name = names.get(selection);
            if (removeTail(name).equals("square")) return buildDefault();
            return readBuild(name);
        } catch (Exception e) {
            if (e instanceof IndexOutOfBoundsException) return null;
            writeSquare();
            return null;
        }
    }

    private static @Nullable BuildHolder getQuickBuild() {
        try {
            String name = quickAccess.get(getQuickAccess());
            if (removeTail(name).equals("square")) return buildDefault();
            return readBuild(name);
        } catch (NullPointerException e) {
            return null;
        }
    }

    public static void saveBuild() {
        if (!deny && class_310.method_1551().field_1724 != null) {
            try {
                if (isHollow) tempBuild.removeFirst();
                writeBuild(buildName, new BuildHolder(placeDir, faceDir, tempBuild.toArray(new RelPos[0])));
                RePlacerClient.LOGGER.info("Saved {}!", tailless(buildName));
                List<String> temp = names;
                temp.add(buildName);
                setNames(temp);
            } catch (Exception e) {
                if (e instanceof NullPointerException) RePlacerClient.LOGGER.warn("Could not save build! Build was likely empty!");
                else RePlacerClient.LOGGER.warn("Could not save build! Build name wass likely empty!");
            }
        }
        buildName = null;
        tempBuild = null;
        reCording = false;
        placeDir = null;
        faceDir = null;
        isHollow = false;
        deny = false;
        RePlacerClient.LOGGER.info("Purged temp vars");
        writeToConfig();
    }

    static void buildDeleter(@NotNull List<String> list) {
        if (list.equals(names)) return;
        setNames(deleter(list, names, taillessNames));
        if (selection > names.size()) {
            if (!getDefBuild().isEmpty()) selection = names.indexOf(getDefBuild());
            else selection = names.size();
            if (selection < 0) selection = 0;
        }
    }

    static void disabledDeleter(@NotNull List<String> list) {
        if (list.equals(disabled)) return;
        setDisabled(deleter(list, disabled, taillessDisabled));
    }

    private static List<String> deleter(@NotNull List<String> list, List<String> names, List<String> taillessNames) {
        List<String> tempNames = new ArrayList<>(new HashSet<>(list));
        list.forEach(build -> {
            if (!list.contains(build)) {
                try {
                    if (hasTail(build)) {
                        if (!taillessNames.contains(removeTail(build))) reAddBuild(build);
                        String tail = tail(build);
                        String name = removeTail(build);
                        String oldName = getCachedVer(build);
                        if (!build.equals(oldName)) {
                            if (!tail.isEmpty()) {
                                renameBuild(oldName, name + DIV + tail);
                                tempNames.remove(oldName);
                                tempNames.add(name + DIV + tail);
                            } else {
                                pullBuild(oldName);
                                tempNames.remove(build);
                                tempNames.add(oldName);
                            }
                        }
                    } else if (taillessNames.contains(build)) {
                        String oldName = getCachedVer(build);
                        renameBuild(oldName, build);
                        tempNames.remove(oldName);
                        tempNames.add(build);
                    } else {
                        pullBuild(build);
                    }

                } catch (FileNotFoundException e) {
                    if (!(build.equals("square") || (hasTail(build) && removeTail(build).equals("square"))))
                        tempNames.remove(build);
                }
            }
        });
        names.forEach(name -> {
            if (!tempNames.contains(name)) {
                deleteBuild(name);
            }
        });
        return tempNames;
    }

    public static boolean buildSaver(@NotNull class_1750 context) {
        class_2338 pos = context.method_8037();
        boolean disp = false;
        if (tempBuild == null) {
            placeDir = context.method_8038();
            assert context.method_8036() != null;
            class_243 v0 = context.method_8036().method_5720();
            double[] v1 = {v0.field_1352, v0.field_1351, v0.field_1350};
            v1[placeDir.method_10166().ordinal()] = 0.0;
            faceDir = class_2350.method_58251(new class_243(v1[0], v1[1], v1[2]).method_1029());
            tempBuild = new ArrayList<>();
            RelPos.setBase(pos);
            disp = true;
        }
        RelPos rel = new RelPos(pos);
        final boolean[] containerCheck = {true};
        tempBuild.forEach(r -> {
            if (r.equals(rel)) containerCheck[0] = false;
        });
        if (containerCheck[0]) tempBuild.add(rel);
        return disp;
    }

    public static void buildRemover(class_2338 pos) {
        RelPos r = new RelPos(pos);
        if (r.equals(RelPos.ORIGIN)) return;
        tempBuild.removeIf(rel -> rel.equals(r));
    }

    static boolean isValidTail(String tail) {
        if (!tail.trim().equals(tail)) return false;
        tail = tail.toLowerCase();
        if (tail.isEmpty() || tail.length() > REGEX.length() - 2) return false;
        if (!tail.toLowerCase().replaceAll(REGEX, "").replaceAll(REGEXNUM, "").isEmpty()) return false;
        tail = tail.toLowerCase().replaceAll(REGEXNUM, "");
        if (tail.length() <= 1) return true;
        if (tail.toLowerCase().replaceAll(SNAP,"").isEmpty()) return false;
        if (tail.toLowerCase().replaceAll(SPIN, "").isEmpty()) return false;
        if (tail.toLowerCase().replaceAll(NO, "").isEmpty()) return false;
        if (tail.toLowerCase().replaceAll(DIS, "").isEmpty()) return false;
        return true;
    }

    static boolean hasTail(String build) {
        if (build == null) return false;
        if (!build.contains(DIV)) return false;
        if (tail(build).isEmpty()) return true;
        return isValidTail(tail(build));
    }

    static String tail(String build) {
        String tail = build.substring(build.indexOf(DIV) + 2).trim().toLowerCase();
        switch (tail) {
            case NO + NO -> {
                return NO;
            }
            case SPIN + SPIN -> {
                return SPIN;
            }
            case SNAP + SNAP -> {
                return SNAP;
            }
        }
        if (isValidTail(tail)) return tail;
        return "";
    }

    public static String tailless(String build) {
        if (isInclTail() || !hasTail(build)) return build;
        return removeTail(build);
    }

    static String removeTail(String build) {
        if (!hasTail(build)) return build;
        return build.substring(0, build.indexOf(DIV));
    }

    static int parseAccess(String name) {
        if (!hasTail(name) || !isValidTail(tail(name))) return -1;
        String remainder = tail(name).toLowerCase().replaceAll(REGEX, "");
        if (remainder.isEmpty()) return -1;
        return Integer.parseInt(remainder);
    }

    public static boolean hasQuickAccess(int slot) {
        return quickAccess.containsKey(slot);
    }

    public static String getQuickAccessName() {
        return quickAccess.get(getQuickAccess());
    }

    public static void setReCording(boolean val) {
        if (class_310.method_1551().field_1724 == null) return;
        reCording = val;
    }

    public static boolean isReCording() {
        return reCording;
    }

    private static boolean getRelevantName(MutableObject<String> holder) {
        if (names.isEmpty()) return true;
        String name;
        try {
            name = isQuickAccess() ? getQuickAccessName() : names.get(selection);
        } catch (IndexOutOfBoundsException e) {
            if (!getDefBuild().isEmpty()) {
                selection = names.indexOf(getDefBuild());
                name = getDefBuild();
            } else {
                selection = 0;
                name = names.getFirst();
            }
        }
        holder.setValue(name);
        return false;
    }

    @Contract(value = " -> new", pure = true)
    public static @NotNull BuildHolder buildDefault() {
        return new BuildHolder(
                class_2350.field_11036,
                class_2350.field_11043,
                new RelPos(0, 0, 0),
                new RelPos(0, 0, 1),
                new RelPos(0, 0, -1),
                new RelPos(1, 0, 0),
                new RelPos(1, 0, 1),
                new RelPos(1, 0, -1),
                new RelPos(-1, 0, 0),
                new RelPos(-1, 0, 1),
                new RelPos(-1, 0, -1)
        );
    }

    static CellErrorSupplier getCellErrorSupplier() {
        return new CellErrorSupplier();
    }

    private static class CellErrorSupplier implements Function<String, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(String entry) {
            entry = entry.toLowerCase();
            if (entry.indexOf(DIV) != entry.lastIndexOf(DIV))
                return Optional.of(class_2561.method_43470("You cannot have more than one modifier tail! error code: 0"));
            if (!hasTail(entry) || isValidTail(tail(entry))) return Optional.empty();
            else {
                if (tail(entry).isEmpty()) return Optional.of(class_2561.method_43470("Tail is empty! error code: 1"));
                return Optional.of(class_2561.method_43470("Illegal characters:" + entry.replaceFirst(SPIN, "").replaceFirst(SNAP, "").replaceFirst(NO, "").replaceFirst(REGEXNUM, "") + " error code: 2"));
            }
        }
    }

    static DefaultErrorSupplier getDefaultErrorSupplier() {
        return new DefaultErrorSupplier();
    }

    private static class DefaultErrorSupplier implements Function<String, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(String entry) {
            if (entry.isEmpty()) return Optional.empty();
            if (hasTail(entry)) return Optional.of(class_2561.method_43470("Enter tailless version! error code: 8"));
            if (!getTaillessNames().contains(entry)) return Optional.of(class_2561.method_43470("Build does not exist! error code: 9"));
            return Optional.empty();
        }
    }

    static NameErrorSupplier getNameErrorSupplier() {
        return new NameErrorSupplier();
    }

    private static class NameErrorSupplier implements Function<String, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(String entry) {
            if (!hasTail(entry) || isValidTail(tail(entry))) {
                if (getTaillessNames().contains(removeTail(entry))) return Optional.of(class_2561.method_43470("Duplicate name! error code: 6"));
                if (hasQuickAccess(parseAccess(entry))) return Optional.of(class_2561.method_43470("Duplicate quick access value! error code: 13"));
                return Optional.empty();
            }
            if (tail(entry).isEmpty()) return Optional.of(class_2561.method_43470("Cannot have empty tail! error code: 12"));
            return Optional.of(class_2561.method_43470("Illegal characters in tail:" + tail(entry).toLowerCase().replaceFirst(SPIN, "").replaceFirst(SNAP, "").replaceFirst(NO, "").replaceFirst(DIS, "").replaceFirst(REGEXNUM, "") + " error code: 7"));
        }
    }

    static BoolErrorSupplier getBoolErrorSupplier() {
        return new BoolErrorSupplier();
    }

    private static class BoolErrorSupplier implements Function<Boolean, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(Boolean entry) {
            boolSideCombinedErrorChecker = false;
            if (entry && listSideCombinedErrorChecker == true) return Optional.of(class_2561.method_43470("Can't turn this on if all your builds are quickaccess! error code: 10"));
            return Optional.empty();
        }
    }

    static NamesErrorSupplier getNamesErrorSupplier() {
        return new NamesErrorSupplier();
    }

    private static class NamesErrorSupplier implements Function<List<String>, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(List<String> entry) {
            listSideCombinedErrorChecker = false;
            namesSideInts.clear();
            if (entry.isEmpty()) return Optional.empty();
            Set<String> taillessNames = new HashSet<>(getTaillessNames());
            Set<String> names = new HashSet<>();
            int disabled = 0;
            for (String build : entry) {
                if (build.equals("square") || (hasTail(build) && removeTail(build).equals("square"))) continue;
                String tailless = removeTail(build);
                if (names.contains(tailless)) return Optional.of(class_2561.method_43470("Duplicate build name: " + tailless + "! error code: 3"));
                if (!taillessNames.contains(tailless)) {
                    if (!isCachedBuild(build))
                        return Optional.of(class_2561.method_43470("You cannot add builds or change their names here! error code: 4"));
                }
                names.add(tailless);
                if (hasTail(build)) {
                    String tail = tail(build);
                    if (tail.contains(DIS)) {
                        disabled++;
                        if (disabled >= entry.size()) return Optional.of(class_2561.method_43470("You may not disable all builds! error code: 14"));
                    }
                    if (!tail.toLowerCase().replaceAll(REGEX, "").isEmpty()) {
                        int i = Integer.parseInt(tail.toLowerCase().replaceAll(REGEX, ""));
                        if (disabledSideInts.contains(i)) return Optional.of(class_2561.method_43470(i + "can only be bound to one build! error code: 20"));
                        if (!namesSideInts.add(i)) return Optional.of(class_2561.method_43470(i + "can only be bound to one build! error code: 5"));
                        if (namesSideInts.size() == entry.size()) {
                            if (boolSideCombinedErrorChecker == true) return Optional.of(class_2561.method_43470("Cannot remove all builds from cycling! error code: 11"));
                            else listSideCombinedErrorChecker = true;
                        }
                    }
                }
            }
            return Optional.empty();
        }
    }

    static DisabledErrorSupplier getDisabledErrorSupplier() {
        return new DisabledErrorSupplier();
    }

    private static class DisabledErrorSupplier implements Function<List<String>, Optional<class_2561>> {
        @Override
        public Optional<class_2561> apply(List<String> entry) {
            if (entry.isEmpty()) return Optional.empty();
            disabledSideInts.clear();
            Set<String> dis = new HashSet<>(getTaillessDisabled());
            Set<String> names = new HashSet<>();

            for (String build : entry) {
                if (build.equals("square") || (hasTail(build) && removeTail(build).equals("square"))) continue;
                String tailless = removeTail(build);
                if (names.contains(tailless)) return Optional.of(class_2561.method_43470("Duplicate disabled build name: " + tailless + "! error code: 17"));
                if (!dis.contains(tailless)) {
                    if (!isCachedBuild(build))
                        return Optional.of(class_2561.method_43470("You cannot add builds or change their names here! error code: 16"));
                }
                names.add(tailless);
                if (hasTail(build)) {
                    String tail = tail(build);
                    if (!tail.toLowerCase().replaceAll(REGEX, "").isEmpty()) {
                        int i = Integer.parseInt(tail.toLowerCase().replaceAll(REGEX, ""));
                        if (namesSideInts.contains(i)) return Optional.of(class_2561.method_43470(i + "can only be bound to one build! error code: 18"));
                        if (!disabledSideInts.add(i)) return Optional.of(class_2561.method_43470(i + "can only be bound to one build! error code: 19"));
                    }
                }
            }
            return Optional.empty();
        }
    }
}
