package eva.replacer.mixin.client;

import eva.replacer.config.RePlacerConfig;
import eva.replacer.rendering.BlockHighlightRenderer;
import eva.replacer.util.BuildInProgress;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_761.class)
public class LevelRendererMixin {
    @Inject(
            method = "renderBlockOutline",
            at = @At("HEAD")
    )
    private void renderInProgressBuild(class_4184 camera, class_4597.class_4598 bufferSource, class_4587 poseStack, boolean sort, CallbackInfo ci) {
        if (RePlacerConfig.isReCording() || BuildInProgress.rePlacing()) {
            BlockHighlightRenderer.renderRePlacerBox(poseStack);
        }
    }

    @Inject(
            method = "renderBlockOutline",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/renderer/LevelRenderer;renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)V"
            ),
            cancellable = true
    )
    private void renderBoxes(class_4184 camera, class_4597.class_4598 bufferSource, class_4587 poseStack, boolean sort, CallbackInfo ci) {
        if (RePlacerConfig.isReCording() || BuildInProgress.rePlacing()) return;
        if (!BlockHighlightRenderer.renderRePlacerBox(poseStack))
            ci.cancel();
    }
}
