/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.replacer.RePlacerClient;
import eva.replacer.config.RePlacerConfig;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.BuildHolderDep;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static final File buildFolder = new File(folder, "RePlacer Builds");
    private static File rePlacerConfig;
    public static final Gson configGson;
    private static final File square;

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
        JsonConfigHelper.createBuilds();
        JsonConfigHelper.writeSquare();
    }

    private static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            rePlacerConfig = new File(folder, "replacer.json");
            if (rePlacerConfig.exists()) {
                try {
                    String templateConfigJson = Files.readString(Path.of(rePlacerConfig.getPath(), new String[0]));
                    seemsValid = templateConfigJson.trim().startsWith("{\n  \"v\": 0,");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!rePlacerConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    RePlacerClient.LOGGER.info("Found invalid config file, creating new config file at './config/replacer.json'.");
                }
                try {
                    rePlacerConfig.createNewFile();
                    String json = configGson.toJson((Object)RePlacerConfig.getInstance());
                    FileWriter writer = new FileWriter(rePlacerConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void readFromConfig() {
        try {
            RePlacerConfig config = (RePlacerConfig)configGson.fromJson((Reader)new FileReader(rePlacerConfig), RePlacerConfig.class);
            RePlacerConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)RePlacerConfig.getInstance());
            FileWriter writer = new FileWriter(rePlacerConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void createBuilds() {
        if (!buildFolder.exists()) {
            buildFolder.mkdir();
        }
        if (buildFolder.isDirectory()) {
            ArrayList<String> names = new ArrayList<String>();
            File[] files = new File("config/RePlacer Builds").listFiles();
            if (files == null) {
                return;
            }
            try {
                for (File file : files) {
                    boolean seemsValid;
                    if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                    if (file.exists()) {
                        try {
                            JsonConfigHelper.pullBuild(file.getName().replace(".json", ""));
                            seemsValid = true;
                        }
                        catch (FileNotFoundException e) {
                            seemsValid = false;
                        }
                    } else {
                        seemsValid = true;
                    }
                    if (!seemsValid) {
                        RePlacerClient.LOGGER.info("Found invalid build file, purging.");
                        file.delete();
                        continue;
                    }
                    names.add(file.getName().replace(".json", ""));
                }
                RePlacerConfig.setNames(names);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    static void deleteBuild(String name) {
        new File(buildFolder, name + ".json").delete();
    }

    static void writeBuild(String name, BuildHolder holder) {
        try {
            String json = configGson.toJson((Object)holder);
            FileWriter writer = new FileWriter(new File(buildFolder, name + ".json"), false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeSquare() {
        try {
            configGson.fromJson((Reader)new FileReader(square), BuildHolder.class);
            if (RePlacerConfig.getNames().isEmpty()) {
                RePlacerConfig.getNames().add("square");
            }
        }
        catch (Exception ignored) {
            try {
                RePlacerClient.LOGGER.info("Writing default build at './config/RePlacerBuilds/square.json'.");
                FileWriter writer = new FileWriter(square, false);
                writer.write(configGson.toJson((Object)RePlacerConfig.buildDefault()));
                writer.close();
                RePlacerConfig.getNames().add("square");
            }
            catch (Exception f) {
                throw new RuntimeException(f);
            }
        }
    }

    static BuildHolder readBuild(String name) {
        try {
            BuildHolder holder = JsonConfigHelper.pullBuild(name);
            if (holder.x().length != holder.y().length || holder.z().length != holder.x().length) {
                throw new IllegalArgumentException();
            }
            return holder;
        }
        catch (FileNotFoundException e) {
            RePlacerConfig.getNames().remove(name);
            RePlacerClient.LOGGER.info("Invalid buildname found! Purging!");
            RePlacerConfig.selection = 0;
            return null;
        }
    }

    static BuildHolder pullBuild(String name) throws FileNotFoundException {
        File toRead = new File(buildFolder, name + ".json");
        BuildHolder holder = (BuildHolder)configGson.fromJson((Reader)new FileReader(toRead), BuildHolder.class);
        if (holder.x() == null || holder.y() == null || holder.z() == null) {
            holder = ((BuildHolderDep)configGson.fromJson((Reader)new FileReader(toRead), BuildHolderDep.class)).asBuildHolder();
            JsonConfigHelper.writeBuild(name, holder);
        }
        return holder;
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
        square = new File(buildFolder, "square.json");
    }
}

