package eva.replacer.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;
import java.util.ArrayList;
import java.util.List;


public class RePlacerConfigScreen implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("RePlacer Config"))
                .setEditable(true);
        if (RePlacerConfig.reCording) {
            builder.setSavingRunnable(RePlacerConfig::saveBuild);
            builder.getOrCreateCategory(class_2561.method_43470("Confirm build save?"))
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Build Name:"), "")
                            .setTooltip(class_2561.method_43470("This will be the build's name.\nThe build is what you just made!"))
                            .setSaveConsumer(newName -> RePlacerConfig.buildName = newName)
                            .setErrorSupplier(RePlacerConfig.getNameErrorSupplier())
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Should the first block be included?"), true)
                            .setTooltip(class_2561.method_43470("If this says no, building this will\nnot require that any given block\nactually placeable."))
                            .setSaveConsumer(newVal -> RePlacerConfig.isHollow = !newVal)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Click this to allow current build to be discarded"), false)
                            .setTooltip(class_2561.method_43470("If this is positive, your build will be deleted!"))
                            .setSaveConsumer(newVal -> RePlacerConfig.deny = newVal)
                            .build()
                    );
        } else {
            builder.setSavingRunnable(JsonConfigHelper::writeToConfig);
            builder.getOrCreateCategory(class_2561.method_43470("Options"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Snap:"), RePlacerConfig.snap())
                            .setTooltip(class_2561.method_43470("Builds rotate such that they snap to\n" +
                                    "the face you're placing them on"))
                            .setSaveConsumer(RePlacerConfig::setSnap)
                            .setDefaultValue(true)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Spin:"), RePlacerConfig.spin())
                            .setTooltip(class_2561.method_43470("""
                                    Builds go spin
                                    They will spin along the axis perpendicular
                                    to the face you're placing them on, if snap
                                    is on for the build.
                                    If snap is off, may exhibit odd behaviors
                                    when placing on other planes"""))
                            .setSaveConsumer(RePlacerConfig::setSpin)
                            .setDefaultValue(true)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Block sort order:"), SortOrder.class, RePlacerConfig.getSortOrder())
                            .setSaveConsumer(RePlacerConfig::setSortOrder)
                            .setDefaultValue(SortOrder.Near_player_last)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Display build tails in text popup:"), RePlacerConfig.isInclTail())
                            .setTooltip(class_2561.method_43470("This is the difference between the game displaying 'square' and 'square--fn1'"))
                            .setSaveConsumer(RePlacerConfig::setInclTail)
                            .setDefaultValue(false)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Exclude quick builds from cycling:"), RePlacerConfig.isExclude())
                            .setSaveConsumer(RePlacerConfig::setExclude)
                            .setDefaultValue(false)
                            .setErrorSupplier(RePlacerConfig.getBoolErrorSupplier())
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Default Build:"), RePlacerConfig.getDefBuild())
                            .setSaveConsumer(RePlacerConfig::setDefBuild)
                            .setErrorSupplier(RePlacerConfig.getDefaultErrorSupplier())
                            .setDefaultValue("")
                            .build()
                    )
            ;
            builder.getOrCreateCategory(class_2561.method_43470("Build Management"))
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Build Names:"), RePlacerConfig.getNames())
                            .setDeleteButtonEnabled(true)
                            .setRemoveButtonTooltip(class_2561.method_43470("This will cache the build until end of session."))
                            .setAddButtonTooltip(class_2561.method_43470("This won't let you add new builds,\n" +
                                    "but it will let you restore them from the cache."))
                            .setTooltip(class_2561.method_43470("Check the wiki for details regarding naming utilities"))
                            .setExpanded(true)
                            .setCellErrorSupplier(RePlacerConfig.getCellErrorSupplier())
                            .setErrorSupplier(RePlacerConfig.getNamesErrorSupplier())
                            .setSaveConsumer(RePlacerConfig::buildDeleter)
                            .setDefaultValue(new ArrayList<>(List.of("square")))
                            .build()
                    );
            if (!RePlacerConfig.getDisabled().isEmpty())
                builder.getOrCreateCategory(class_2561.method_43470("Disabled Builds"))
                        .addEntry(builder.entryBuilder()
                                .startStrList(class_2561.method_43470("Build Names:"), RePlacerConfig.getDisabled())
                                .setDeleteButtonEnabled(true)
                                .setRemoveButtonTooltip(class_2561.method_43470("This will cache the build until end of session."))
                                .setAddButtonTooltip(class_2561.method_43470("This won't let you add new builds,\n" +
                                        "but it will let you restore them from the cache."))
                                .setTooltip(class_2561.method_43470("Check the wiki for details regarding naming utilities"))
                                .setExpanded(true)
                                .setCellErrorSupplier(RePlacerConfig.getCellErrorSupplier())
                                .setErrorSupplier(RePlacerConfig.getDisabledErrorSupplier())
                                .setSaveConsumer(RePlacerConfig::disabledDeleter)
                                .setDefaultValue(new ArrayList<>())
                                .build()
                        );
            if (JsonConfigHelper.hasBuildsCached())
                builder.getOrCreateCategory(class_2561.method_43470("Cached Builds"))
                        .addEntry(builder.entryBuilder().startStrList(class_2561.method_43470("This list is unmodifiable."), JsonConfigHelper.getCachedBuilds())
                                .setExpanded(true)
                                .setTooltip(class_2561.method_43470("This list is just here to show you which\n" +
                                        "builds are available for re-addition"))
                                .setDeleteButtonEnabled(false)
                                .build()
                    );
        }
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        JsonConfigHelper.checkUpdates();
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }

}