package eva.replacer.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import static eva.replacer.RePlacerClient.isHoldingEither;
import static eva.replacer.RePlacerClient.setQuickAccess;
import static eva.replacer.config.RePlacerConfig.getQuickAccessName;
import static eva.replacer.config.RePlacerConfig.hasQuickAccess;

import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Mixin(class_310.class)
public class MinecraftMixin {
    @Redirect(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/player/Inventory;setSelectedSlot(I)V"
            )
    )
    private void quickAccessBuilds(class_1661 instance, int slot) {
        if (isHoldingEither() && hasQuickAccess(slot + 1 % class_1661.field_30641)) {
            assert class_310.method_1551().field_1724 != null;
            setQuickAccess(slot + 1 % class_1661.field_30641);
            class_310.method_1551().field_1724.method_7353(class_2561.method_43470("Activated " + getQuickAccessName() + " for quick access"), true);
        }
        else instance.method_61496(slot);
    }
}
