package eva.replacer.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class RePlacerConfigScreen implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("RePlacer Config"))
                .setEditable(true);
        if (RePlacerConfig.reCording) {
            builder.setSavingRunnable(RePlacerConfig::saveBuild);
            builder.getOrCreateCategory(class_2561.method_43470("Confirm build save?"))
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Build Name:"), "")
                            .setTooltip(class_2561.method_43470("This will be the build's name.\nThe build is what you just made!"))
                            .setSaveConsumer(newName -> RePlacerConfig.buildName = newName)
                            .setErrorSupplier(new RePlacerConfig.NameErrorSupplier())
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Include origin?"), true)
                            .setTooltip(class_2561.method_43470("Should the build include the first block?\n" +
                                    "It will remain the initiation point of the build regardless."))
                            .setSaveConsumer(newVal -> RePlacerConfig.isHollow = !newVal)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Discard on exit?"), false)
                            .setTooltip(class_2561.method_43470("If this is positive, your build will be deleted\n" +
                                    "when you save the config!"))
                            .setSaveConsumer(newVal -> RePlacerConfig.deny = newVal)
                            .build()
                    );
        } else {
            builder.setSavingRunnable(JsonConfigHelper::writeToConfig);
            builder.getOrCreateCategory(class_2561.method_43470("Options"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Snap:"), RePlacerConfig.snap())
                            .setTooltip(class_2561.method_43470("Builds rotate such that they snap to\n" +
                                    "the face you're placing them on"))
                            .setSaveConsumer(RePlacerConfig::setSnap)
                            .setDefaultValue(true)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Spin:"), RePlacerConfig.spin())
                            .setTooltip(class_2561.method_43470("""
                                    Builds go spin
                                    They will spin along the axis perpendicular
                                    to the face you're placing them on, if snap
                                    is on for the build.
                                    If snap is off, may exhibit odd behaviors
                                    when placing on other planes"""))
                            .setSaveConsumer(RePlacerConfig::setSpin)
                            .setDefaultValue(true)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startEnumSelector(class_2561.method_43470("Block sort order:"), SortOrder.class, RePlacerConfig.getSortOrder())
                            .setSaveConsumer(RePlacerConfig::setSortOrder)
                            .setDefaultValue(SortOrder.Near_player_last)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Blocks per tick (can be sub-1):"), RePlacerConfig.getRatioStr())
                            .setTooltip(class_2561.method_43470("Feature in beta! Going higher than 1 may result\n" +
                                    "in blocks not being placed properly!"))
                            .setSaveConsumer(RePlacerConfig::setRatio)
                            .setErrorSupplier(new RePlacerConfig.RatErrorSupplier())
                            .setDefaultValue("1:1")
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startIntField(class_2561.method_43470("Failsafe Delay Duration:"), RePlacerConfig.getFailsafeTicks())
                            .setTooltip(class_2561.method_43470("""
                                    If RePlacer fails to place the next block this many times
                                    for one of a few reasons - out of range, no blocks selected - it will
                                    cancel the build.
                                    If this is -1, attempts will go on indefinitely."""))
                            .setErrorSupplier(val -> {
                                if (val == -1 || val > 0) return Optional.empty();
                                return Optional.of(class_2561.method_43470("Value must be -1 or greater than 0! error code: 26"));
                            })
                            .setMin(-1)
                            .setDefaultValue(6)
                            .setSaveConsumer(RePlacerConfig::setFailsafeTicks)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Display build tails in text popup:"), RePlacerConfig.isInclTail())
                            .setTooltip(class_2561.method_43470("This is the difference between the game displaying\n" +
                                    "'square' and 'square--fn1,' for example."))
                            .setSaveConsumer(RePlacerConfig::setInclTail)
                            .setDefaultValue(false)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Exclude quick builds from cycling:"), RePlacerConfig.isExclude())
                            .setSaveConsumer(RePlacerConfig::setExclude)
                            .setDefaultValue(false)
                            .setErrorSupplier(new RePlacerConfig.BoolErrorSupplier())
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Default Build:"), RePlacerConfig.getDefBuild())
                            .setSaveConsumer(RePlacerConfig::setDefBuild)
                            .setErrorSupplier(new RePlacerConfig.DefaultErrorSupplier())
                            .setDefaultValue("")
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Linearize axis order:"), RePlacerConfig.linearize())
                            .setSaveConsumer(RePlacerConfig::setLinearize)
                            .setErrorSupplier(lin -> {
                                if (lin.isEmpty()) return Optional.of(class_2561.method_43470("Must not be empty! error code: 27"));
                                if (lin.length() > 6) return Optional.of(class_2561.method_43470("Must not be longer than 6 characters! error code: 27"));
                                if (!lin.replaceAll("[-xyzXYZ]", "").isEmpty()) return Optional.of(class_2561.method_43470("Invalid characters: " + lin.toLowerCase().replaceAll("[-xyzXYZ]", "") + " error code: 28"));
                                if (lin.endsWith("-")) return Optional.of(class_2561.method_43470("- may only go before an axis letter! error code: 29"));
                                for (char c : "xyz".toCharArray()) if (lin.toLowerCase().indexOf(c) != lin.lastIndexOf(c)) return Optional.of(class_2561.method_43470("Repeat axes not allowed! error code: 30"));
                                return Optional.empty();
                            })
                            .setDefaultValue("xyz")
                            .build()
                    )
            ;
            builder.getOrCreateCategory(class_2561.method_43470("Build Management"))
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Build Names:"), RePlacerConfig.getNames())
                            .setDeleteButtonEnabled(true)
                            .setRemoveButtonTooltip(class_2561.method_43470("This will cache the build until end of session."))
                            .setAddButtonTooltip(class_2561.method_43470("This won't let you add new builds,\n" +
                                    "but it will let you restore them from the cache."))
                            .setTooltip(class_2561.method_43470("Check the wiki for details regarding naming utilities"))
                            .setExpanded(true)
                            .setCellErrorSupplier(new RePlacerConfig.CellErrorSupplier())
                            .setErrorSupplier(new RePlacerConfig.NamesErrorSupplier())
                            .setSaveConsumer(RePlacerConfig::buildDeleter)
                            .setDefaultValue(new ArrayList<>(List.of("square")))
                            .build()
                    )
            ;
            if (!RePlacerConfig.getDisabled().isEmpty()) {
                builder.getOrCreateCategory(class_2561.method_43470("Disabled Builds"))
                        .addEntry(builder.entryBuilder()
                                .startStrList(class_2561.method_43470("Build Names:"), RePlacerConfig.getDisabled())
                                .setDeleteButtonEnabled(true)
                                .setRemoveButtonTooltip(class_2561.method_43470("This will cache the build until end of session."))
                                .setAddButtonTooltip(class_2561.method_43470("This won't let you add new builds,\n" +
                                        "but it will let you restore them from the cache."))
                                .setTooltip(class_2561.method_43470("Check the wiki for details regarding naming utilities"))
                                .setExpanded(true)
                                .setCellErrorSupplier(new RePlacerConfig.CellErrorSupplier())
                                .setErrorSupplier(new RePlacerConfig.DisabledErrorSupplier())
                                .setSaveConsumer(RePlacerConfig::disabledDeleter)
                                .setDefaultValue(new ArrayList<>())
                                .build()
                        )
                ;
            }
            if (JsonConfigHelper.hasBuildsCached()) {
                builder.getOrCreateCategory(class_2561.method_43470("Cached Builds"))
                        .addEntry(builder.entryBuilder().startStrList(class_2561.method_43470("This list is unmodifiable."), JsonConfigHelper.getCachedBuilds())
                                .setExpanded(true)
                                .setTooltip(class_2561.method_43470("This list is just here to show you which\n" +
                                        "builds are available for re-addition"))
                                .setDeleteButtonEnabled(false)
                                .build()
                        )
                ;
            }
            builder.getOrCreateCategory(class_2561.method_43470("Colors"))
                    .addEntry(builder.entryBuilder().startAlphaColorField(class_2561.method_43470("Main:"), RePlacerConfig.getBorderColor().getColor())
                            .setDefaultValue2(() -> RePlacerConfig.getDefColors(0))
                            .setSaveConsumer2(RePlacerConfig::setBorderColor)
                            .build()
                    )
                    .addEntry(builder.entryBuilder().startAlphaColorField(class_2561.method_43470("Behind Blocks:"), RePlacerConfig.getTransparentBorderColor().getColor())
                            .setDefaultValue2(() -> RePlacerConfig.getDefColors(1))
                            .setSaveConsumer2(RePlacerConfig::setTransparentBorderColor)
                            .build()
                    )
                    .addEntry(builder.entryBuilder().startAlphaColorField(class_2561.method_43470("Excluded:"), RePlacerConfig.getExcludedColor().getColor())
                            .setDefaultValue2(() -> RePlacerConfig.getDefColors(2))
                            .setSaveConsumer2(RePlacerConfig::setExcludedColor)
                            .build()
                    )
                    .addEntry(builder.entryBuilder().startAlphaColorField(class_2561.method_43470("Excluded & Behind Blocks:"), RePlacerConfig.getTransparentExcludedColor().getColor())
                            .setDefaultValue2(() -> RePlacerConfig.getDefColors(3))
                            .setSaveConsumer2(RePlacerConfig::setTransparentExcludedColor)
                            .build()
                    )
            ;
        }
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        JsonConfigHelper.checkUpdates();
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }

}