package eva.replacer.util;

import eva.replacer.config.RePlacerConfig;
import eva.replacer.config.SortOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;

import static eva.replacer.config.RePlacerConfig.*;

public record BuildHolder(class_2350 firstDir, @Nullable class_2350 faceDir, int[] x, int[] y, int[] z) {
    private static class_2350 baseDir;
    private static class_2350 facing;
    private static class_2350 rotCor;

//    private static final Map<Direction, List<Direction>> ROT = new HashMap<>();

    private BuildHolder(class_2350 firstDir, class_2350 faceDir, int @NotNull [][] tri) {
        this(firstDir, faceDir, tri[0], tri[1], tri[2]);
    }
    public BuildHolder(class_2350 firstDir, class_2350 faceDir, RelPos... posList) {
        this(firstDir, faceDir, split(posList));
    }

    public static void setBaseDir(class_2350 baseDir) {
        BuildHolder.baseDir = baseDir;
    }
    public static void setFacing(@NotNull class_243 v0) {
        double[] v1 = {v0.field_1352, v0.field_1351, v0.field_1350};
        v1[baseDir.method_10166().ordinal()] = 0.0;
        facing = class_2350.method_58251(new class_243(v1[0], v1[1], v1[2]));
    }

    /// When there are problems with rotation, this one is never the culprit. Look elsewhere.
    RelPos snap(RelPos pos) {
        if (!isSnap() || this.firstDir == baseDir)
             return pos;
        if (this.firstDir().method_10166() == baseDir.method_10166()) {
            int[] vals = {pos.vals()[0], pos.vals()[1], pos.vals()[2]};
            vals[this.firstDir().method_10166().ordinal()] *= -1;
            return new RelPos(vals);
        }
        int[] ind = {this.firstDir().method_10166().ordinal(), baseDir.method_10166().ordinal()};
        int[] neg;
        if (this.firstDir().method_10171() != baseDir.method_10171())
            neg = new int[]{-1, 1};
        else
            neg = new int[]{1, -1};
        int[] vals = new int[3];
        vals[ind[0]] = pos.vals()[ind[1]] * neg[1];
        vals[ind[1]] = pos.vals()[ind[0]] * neg[0];
        vals[3 - ind[0] - ind[1]] = pos.vals()[3 - ind[0] - ind[1]];
        return new RelPos(vals);
    }

    RelPos spin(RelPos pos) {
        if (!isSpin() || this.faceDir == null || pos.equals(RelPos.ORIGIN))
            return pos;
        class_2350 rotCor = BuildHolder.rotCor;
        assert rotCor != null;
        int[] vals = pos.vals();
        class_2350.class_2351 ax = firstDir.method_10166();
        RelPos pos2 = pos;
        boolean bl = rotCor.method_10153().equals(this.faceDir);
        if (!rotCor.method_10166().equals(faceDir.method_10166())) {
            bl = rotCor.method_35833(ax) != this.faceDir;
            pos2 = switch (ax) {
                case field_11048 -> new RelPos(vals[0], -vals[2], vals[1]);
                case field_11052 -> new RelPos(vals[2], vals[1], -vals[0]);
                case field_11051 -> new RelPos(-vals[1], vals[0], vals[2]);
            };
        }
        if (!bl)
            return pos2;
        int[] vals2 = pos2.vals();
        return switch (ax) {
            case field_11048 -> new RelPos(vals2[0], -vals2[1], -vals2[2]);
            case field_11052 -> new RelPos(-vals2[0], vals2[1], -vals2[2]);
            case field_11051 -> new RelPos(-vals2[0], -vals2[1], vals2[2]);
        };
    }

    private @Nullable class_2350 rot() {
        if (this.faceDir == null) return null;
        if (this.firstDir.method_10166().equals(baseDir.method_10166())) return facing;
        class_2350 tempBase = baseDir;
        class_2350 tempFacing = facing;
        class_2350.class_2351 ax = class_2350.class_2351.values()[3 - this.firstDir.method_10166().ordinal() - baseDir.method_10166().ordinal()];
        while (!tempBase.equals(firstDir)) {
            tempBase = tempBase.method_35834(ax);
            tempFacing = tempFacing.method_35834(ax);
        }
        return tempFacing;
    }

    public void rotateEach(Consumer<RelPos> action) {
        rotCor = rot();
        for (int i = 0; i < this.x.length; i++) {
            RelPos pos = pos(i);
            if (!(isSnap() || isSpin()))
                action.accept(pos);
            else
                action.accept(snap(spin(pos)));
        }
        rotCor = null;
    }

    public void forEach(Consumer<RelPos> action) {
        for (int i = 0; i < this.x.length; i++) {
            action.accept(pos(i));
        }
    }

    private RelPos pos(int i) {
        return new RelPos(this.x[i], this.y[i], this.z[i]);
    }

    private static int @NotNull [][] split(RelPos @NotNull [] posList) {
        int[][] ret = new int[3][posList.length];
        for (int i = 0; i < 3; i++)
            for (int j = 0; j < posList.length; j++)
                ret[i][j] = posList[j].vals()[i];
        return ret;
    }

    public RelPos @NotNull [] posList() {
        thrower();
        RelPos[] posList = new RelPos[this.x.length];
        for (int i = 0; i < this.x.length; i++) {
            posList[i] = new RelPos(this.x[i], this.y[i], this.z[i]);
        }
        return posList;
    }

    @NotNull
    public BuildHolder handleSort(class_1657 player) {
        return switch (getSortOrder()) {
            case Near_block_first, Near_block_last -> sort();
            case Near_player_first, Near_player_last -> sort(player);
            case Random -> random();
            case Top_down, Bottom_up, Linearize -> linearize();
        };
    }

    private BuildHolder sort() {
        thrower();
        RelPos[] posList = new RelPos[this.x.length];
        Comparator<RelPos> comp = Comparator.comparingDouble(RelPos::dist);
        if (!getSortOrder().equals(SortOrder.Near_block_first))
            comp = Collections.reverseOrder(comp);
        rewrite(posList, comp);
        return this;
    }

    private BuildHolder sort(class_1657 player) {
        thrower();
        RelPos[] posList = this.posList();
        class_243 v = player.method_33571();
        Comparator<RelPos> comp = Comparator.comparingDouble(pos -> pos.dist(v));
        if (!getSortOrder().equals(SortOrder.Near_player_first))
            comp = Collections.reverseOrder(comp);
        rewrite(posList, comp);
        return this;
    }

    private BuildHolder random() {
        thrower();
        RelPos[] posList = this.posList();
        Collections.shuffle(Arrays.asList(posList));
        subRewrite(posList);
        return this;
    }

    private BuildHolder linearize() {
        thrower();
        RelPos[] posList = this.posList();
        String orders = RePlacerConfig.getLinearize();
        for (; !orders.isEmpty(); orders = orders.substring(1)) {
            boolean bl = orders.startsWith("-");
            if (bl) {
                orders = orders.substring(1);
            }
            char c = orders.charAt(0);
            Comparator<RelPos> comp = Comparator.comparingInt(pos -> pos.vals()[switch(c) {
                case 'x' -> 0;
                case 'y' -> 1;
                case 'z' -> 2;
                default -> throw new IllegalArgumentException();
                    }]);
            if (bl) comp = Collections.reverseOrder(comp);
            Arrays.sort(posList, comp);
        }
        subRewrite(posList);
        return this;
    }

    private void rewrite(RelPos[] posList, Comparator<RelPos> comp) {
        Arrays.sort(posList, comp);
        subRewrite(posList);
    }

    private void subRewrite(RelPos[] posList) {
        for (int i = 0; i < posList.length; i++) {
            this.x[i] = posList[i].vals()[0];
            this.y[i] = posList[i].vals()[1];
            this.z[i] = posList[i].vals()[2];
        }
    }

    private void thrower() {
        if (this.x.length != this.y.length || this.z.length != this.x.length) throw new IllegalArgumentException();
    }

    public boolean containsOrigin() {
        for (RelPos pos : this.posList()) {
            if (pos.equals(RelPos.ORIGIN)) return true;
        }
        return false;
    }

    static void clear() {
        baseDir = null;
        facing = null;
    }

//    static {
//        ROT.put(Direction.DOWN, plane(Direction.DOWN, Direction.SOUTH));
//        ROT.put(Direction.UP, plane(Direction.UP, Direction.NORTH));
//        ROT.put(Direction.NORTH, plane(Direction.NORTH, Direction.WEST));
//        ROT.put(Direction.SOUTH, plane(Direction.SOUTH, Direction.EAST));
//        ROT.put(Direction.WEST, plane(Direction.EAST, Direction.UP));
//        ROT.put(Direction.EAST, plane(Direction.WEST, Direction.DOWN));
//    }

    private static @NotNull List<class_2350> plane(@NotNull class_2350 axDir, class_2350 first) {
        if (axDir.method_10171().equals(class_2350.class_2352.field_11060))
            return Arrays.asList(
                    first,
                    first.method_35834(axDir.method_10166()),
                    first.method_10153(),
                    first.method_35833(axDir.method_10166())
            );
        else
            return Arrays.asList(
                    first,
                    first.method_35833(axDir.method_10166()),
                    first.method_10153(),
                    first.method_35834(axDir.method_10166())
            );
    }
}
