package eva.replacer;

import eva.replacer.config.JsonConfigHelper;
import eva.replacer.config.RePlacerConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static eva.replacer.config.RePlacerConfig.deny;
import static eva.replacer.config.RePlacerConfig.saveBuild;

public class RePlacerClient implements ClientModInitializer {
    public static final String MOD_ID = RePlacerMain.MOD_ID + "-client";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    private static boolean modMenu = false;
    public static final class_304 MOD_BIND;
    public static final class_304 CYCLE_BIND;
    public static final class_304 MOD_TOGGLE;
    public static final class_304 REC_BUT;
    public static final class_304 MENU_BUT;
    private static final String CATEGORY = "RePlacer";
    static {
        MOD_BIND = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Modifier Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_LEFT_ALT,
                CATEGORY
        ));
        CYCLE_BIND = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Cycle Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_Z,
                CATEGORY
        ));
        MOD_TOGGLE = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Modifier Toggle Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                CATEGORY
        ));
        REC_BUT = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Record Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                CATEGORY
        ));
        MENU_BUT = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Menu Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                CATEGORY
        ));
    }

    @Override
    public void onInitializeClient() {
        modMenu = FabricLoader.getInstance().isModLoaded("modmenu");
        JsonConfigHelper.init();
        serverCheckInit();
    }

    private static void serverCheckInit() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> RePlacerConfig.isServer = !client.method_1542());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            RePlacerConfig.isServer = null;
            deny = true;
            saveBuild();
        });
    }

    public static boolean modMenu() {
        return modMenu;
    }

}