package eva.replacer.mixin.client;

import eva.replacer.config.RePlacerConfig;
import eva.replacer.rendering.BlockHighlightRenderer;
import eva.replacer.util.BuildInProgress;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_761.class)
public class LevelRendererMixin {
    @Inject(
            method = "renderLevel",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V"
            )
    )
    private void renderInProgressBuild(class_4587 poseStack, float partialTick, long finishNanoTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projectionMatrix, CallbackInfo ci) {
        if (RePlacerConfig.isReCording() || BuildInProgress.rePlacing()) {
            BlockHighlightRenderer.renderRePlacerBox(poseStack);
        }
    }

    @Inject(
            method = "renderHitOutline",
            at = @At("HEAD"),
            cancellable = true
    )
    private void renderBoxes(class_4587 poseStack, class_4588 consumer, class_1297 entity, double camX, double camY, double camZ, class_2338 pos, class_2680 state, CallbackInfo ci) {
        if (RePlacerConfig.isReCording() || BuildInProgress.rePlacing()) return;
        if (!BlockHighlightRenderer.renderRePlacerBox(poseStack))
            ci.cancel();
    }
}
