package eva.replacer.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import eva.replacer.util.KeybindHandler;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static eva.replacer.config.RePlacerConfig.getQuickAccessName;
import static eva.replacer.config.RePlacerConfig.hasQuickAccess;

@Mixin(class_310.class)
public class MinecraftMixin {
    @Unique
    class_310 mc = (class_310)(Object) this;
    @ModifyExpressionValue(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/KeyMapping;consumeClick()Z",
                    ordinal = 2
            )
    )
    private boolean quickAccessBuilds(boolean original, @Local(ordinal = 0) int slot) {
        assert mc.field_1724 != null;
        if (mc.field_1724.method_7325()) return original;
        if (original && KeybindHandler.isHoldingEither() && hasQuickAccess(slot + 1 % class_1661.method_7368())) {
            KeybindHandler.setQuickAccess(slot + 1 % class_1661.method_7368());
            mc.field_1724.method_7353(class_2561.method_43470("Activated " + getQuickAccessName() + " for quick access"), true);
            return false;
        }
        else return original;
    }

    @Inject(
            method = "handleKeybinds",
            at = @At("TAIL")
    )
    private void binds(CallbackInfo ci) {
        KeybindHandler.binds();
    }
}