package eva.replacer.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;
import eva.replacer.RePlacerClient;
import eva.replacer.config.RePlacerConfig;
import eva.replacer.mixin.client.access.MultiPlayerGameModeInvoker;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.BuildInProgress;
import eva.replacer.util.KeybindHandler;
import eva.replacer.util.RelPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2885;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_7204;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
@Mixin(class_636.class)
public abstract class MultiPlayerGameModeMixin {
    @Final @Shadow @NotNull private class_310 minecraft;
    @Unique @NotNull private final class_636 gameMode = (class_636) (Object) this;
    @Unique private class_746 player;

    @Inject(
            method = "tick",
            at = @At("HEAD")
    )
    private void placeAgain(CallbackInfo ci) {
        assert minecraft.field_1724 != null;
        if (player == null) player = minecraft.field_1724;
        BuildInProgress.placeHandler(player);
    }

    @Redirect(
            method = "useItemOn",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;startPrediction(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/client/multiplayer/prediction/PredictiveAction;)V"
            )
    )
    private void reUseItemOn(
            class_636 instance,
            class_638 level,
            class_7204 action,
            @Local MutableObject<class_1269> mutableObject,
            @Local(argsOnly = true) class_1268 hand,
            @Local(argsOnly = true) class_3965 result
    ) {
        mutableObject.setValue(class_1269.field_5811);
        if (BuildInProgress.rePlacing()) return;

        if (!(player.method_5998(hand).method_7909() instanceof class_1747) || RePlacerConfig.isReCording() || BuildInProgress.rePlacing() || !KeybindHandler.isHeldOrToggled()) {
            ((MultiPlayerGameModeInvoker) gameMode).invokeStartPrediction(this.minecraft.field_1687, i -> {
                mutableObject.setValue(((MultiPlayerGameModeInvoker) gameMode).invokePerformUseItemOn(player, hand, result));
                return new class_2885(hand, result, i);
            });
            if (mutableObject.getValue().equals(class_1269.field_5812) && RePlacerConfig.isReCording()) {
                class_1750 context = new class_1750(
                        player,
                        hand,
                        player.method_5998(hand),
                        result
                );
                if (RePlacerConfig.buildSaver(context)) {
                    assert context.method_8036() != null;
                    context.method_8036().method_7353(class_2561.method_43470("Origin saved!"), true);
                }
            }
        } else {
            class_1750 context = new class_1750(
                    player,
                    hand,
                    player.method_5998(hand),
                    result
            );
            BuildHolder holder = RePlacerConfig.handleGetBuild();
            if (KeybindHandler.isQuickAccess()) KeybindHandler.setQuickAccess(-1);
            if (holder == null) {
                RePlacerClient.LOGGER.info("Failed to get build!");
                player.method_7353(class_2561.method_43470("Failed to get build!"), true);
                player.method_7353(class_2561.method_43470("Writing default build."), false);
                return;
            }
            BuildInProgress.rePlacing(true);
            RelPos.setBase(context.method_17698(), context.method_8037());
            try {
//                BuildHolder.setBaseDir(context.getClickedFace());
//                BuildHolder.setFacing(player.getLookAngle());
                //Formerly compat mode
                BuildInProgress.pass(context);
                List<RelPos> poss = new ArrayList<>();
                holder.rotateEach(poss::add);
                BuildHolder build = new BuildHolder(holder.firstDir(), holder.faceDir(), poss.toArray(new RelPos[0]));
                if (poss.isEmpty()) {
                    mutableObject.setValue(class_1269.field_5814);
                    return;
                }
                player.method_6104(hand);
                mutableObject.setValue(class_1269.field_5812);
                BuildInProgress.setReadyForBlock(true);
                build.handleSort(player).forEach(BuildInProgress::pass);
                BuildInProgress.placeHandler(player);
            } catch (Exception e) {
                mutableObject.setValue(class_1269.field_5814);
            }
        }
    }

    @Inject(
            method = "destroyBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/block/Block;destroy(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"
            )
    )
    private void removeBlock(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (RePlacerConfig.isReCording()) RePlacerConfig.buildRemover(pos);
    }
}