package eva.replacer.util;

import eva.replacer.config.RePlacerConfig;
import eva.replacer.mixin.client.access.BlockHitResultAccess;
import eva.replacer.mixin.client.access.MultiPlayerGameModeInvoker;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Unique;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2885;
import net.minecraft.class_310;
import net.minecraft.class_3468;
import net.minecraft.class_3965;

import static eva.replacer.config.RePlacerConfig.getRatio;
import static eva.replacer.config.RePlacerConfig.isServer;
import static eva.replacer.util.RelPos.ORIGIN;
import static net.minecraft.class_3244.field_37280;

public class BuildInProgress {
    private static final List<RelPos> posList = new ArrayList<>();
    private static class_1750 context;
    private static final List<RelPos> placedList = new ArrayList<>();
    private static boolean rePlacing = false;
    private static boolean readyForBlock = false;

    public static boolean rePlacing() {
        return rePlacing;
    }

    public static void rePlacing(boolean re) {
        rePlacing = re;
    }

    public static void pass(@NotNull RelPos pos) {
        assert context.method_8036() != null;
        posList.add(pos);
    }
    public static void pass(class_1750 cont) {
        context = cont;
    }

    public static void clear() {
        posList.clear();
        context = null;
        placedList.clear();
        BuildHolder.clear();
    }

    public static boolean isClear() {
        return posList.size() + placedList.size() == 0;
    }

    public static class_1750 context() {return context;}

    private static RelPos next() {
        placedList.add(posList.removeFirst());
        return placedList.getLast();
    }

    private static void undoNext() {
        posList.addFirst(placedList.removeLast());
    }

    public static RelPos last() {
        if (placedList.isEmpty()) return ORIGIN;
        return placedList.getLast();
    }

    public static @NotNull List<RelPos> remaining() {
        return new ArrayList<>(posList);
    }

    public static boolean isEmpty() {
        return posList.isEmpty();
    }

    @Unique private static double delayer;
    @Unique private static int waiter = 0;

    public static void placeHandler(class_1657 player) {
        if (rePlacing()) {
            if (RePlacerConfig.getFailsafeTicks() != -1 && waiter > RePlacerConfig.getFailsafeTicks()) {
                cancel();
                return;
            }
            delayer += getRatio();
            for (; delayer >= 1; delayer--) {
                if (player.method_5998(context().method_20287()).method_7960()) {
                    delayer = 0.0;
                    return;
                }
                waiter++;
                if (isServer() && !isReadyForBlock()) {
                    delayer = 0.0;
                    return;
                }
                if (!(player.method_5998(context().method_20287()).method_7909() instanceof class_1747 item)) {
                    delayer = 0.0;
                    return;
                }
                waiter = 0;
                RelPos pos;
                do {
                    if (BuildInProgress.isEmpty()) {
                        cancel();
                        return;
                    }
                    pos = next();
                    if (!canInteractWithBlock(pos.pos(), player)) {
                        undoNext();
                        delayer = 0.0;
                        return;
                    }
                } while (!context.method_8045().method_8320(pos.pos()).method_26166(context));
                class_3965 result = BuildInProgress.place(pos, player, item);
                if (!((BlockHitResultAccess) result).isMiss()) {
                    setReadyForBlock(false);
                    player.method_7259(class_3468.field_15372.method_14956(player.method_5998(context().method_20287()).method_7909()));
                }
            }
        } else {
            if (delayer != 1.0D) delayer = 1.0D;
            if (waiter != 0) waiter = 0;
        }
    }

    private static void cancel() {
        if (!isClear()) BuildInProgress.clear();
        rePlacing(false);
        waiter = 0;
    }

    public static @NotNull class_3965 place(RelPos pos, class_1657 player, class_1747 blit) {
        assert class_310.method_1551().field_1761 != null;
        if (!player.method_5998(context.method_20287()).method_7960())
            if (context.method_8045().method_8320(pos.pos()).method_26166(context)) {
                return realPlace(pos, player, blit);
            }
        return class_3965.method_17778(pos.vec(), context.method_8038(), pos.pos());
    }

    private static @NotNull class_3965 realPlace(@NotNull RelPos pos, class_1657 player, @NotNull class_1747 blit) {
        class_3965 res = new class_3965(
                pos.vec(),
                context.method_8038(),
                pos.pos(),
                context.method_17699()
        );
        blit.method_7712(
                new class_1750(
                        player,
                        context.method_20287(),
                        player.method_5998(context.method_20287()),
                        res
                )
        );
        assert class_310.method_1551().field_1761 != null;
        ((MultiPlayerGameModeInvoker) class_310.method_1551().field_1761).invokeStartPrediction(class_310.method_1551().field_1687, i -> new class_2885(context().method_20287(), res, i));
        return res;
    }

    public static boolean isReadyForBlock() {
        return readyForBlock;
    }

    public static void setReadyForBlock(boolean readyForBlock) {
        BuildInProgress.readyForBlock = readyForBlock;
    }

    public static boolean canInteractWithBlock(class_2338 blockPos, class_1657 player) {
        class_243 vec3 = blockPos.method_46558();
        class_243 vec32 = class_243.method_24953(blockPos);
        if (!(player.method_33571().method_1025(vec32) > field_37280)) {
            class_243 vec33 = vec3.method_1020(vec32);
            double d = 1.0000001;
            return Math.abs(vec33.method_10216()) < d && Math.abs(vec33.method_10214()) < d && Math.abs(vec33.method_10215()) < d;
        }
        return false;
    }
}
