package eva.multiplacer.mixin.client;


import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static eva.multiplacer.MultiPlacerClient.modifierBind;

@Mixin(class_1799.class)
public class ItemStackMixin {

    @Unique class_1799 itstck = (class_1799) (Object) this;
    @Unique boolean rePlacing = false;
    @Unique int[][] poslist = {{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};

    @Inject(
            method = "useOn",
            at = @At(
                    value = "RETURN",
                    ordinal = 1
            )
    )
    private void placeAgain(class_1838 context, CallbackInfoReturnable<class_1269> cir, @Local class_1269 result) {
        if (!modifierBind.method_1434()) return;
        if (!(result instanceof class_1269.class_9860) || rePlacing || !(itstck.method_7909() instanceof class_1747)) return;

        class_1657 player = context.method_8036();
        assert player != null;
        int c = itstck.method_7947();
        if (player.method_56992()) c = 8;
        class_2338 pos = context.method_8037();
        class_2350 direction = context.method_8038();

        pos = pos.method_30513(direction.method_10166(), switch (direction.method_10171()) {
            case field_11056 -> 1;
            case field_11060 -> -1;
        });

        class_2350.class_2351[] axes = new class_2350.class_2351[2];
        int i = 0;
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            if (axis != direction.method_10166()) {
                axes[i++] = axis;
            }
        }

        class_2350[] dirs = new class_2350[4];
        i = 0;
        for (class_2350 dir : class_2350.values()) {
            if (dir.method_10166() != direction.method_10166())
                dirs[i++] = dir;
        }


        rePlacing = true;

        class_243 ref = pos.method_46558();

        for (i = 0; i < poslist.length; i++) {
            class_2338 rePos = pos.method_30513(axes[0], poslist[i][0]).method_30513(axes[1], poslist[i][1]);
            if (!player.method_37908().method_8320(rePos).method_45474()) continue;
            class_3965 hit = new class_3965(
                    ref,
                    dirs[i % 4],
                    rePos,
                    false
            );
            class_1838 reContext = new class_1838(player, context.method_20287(), hit);
            itstck.method_7981(reContext);
        }

        rePlacing = false;
    }

}