/*
 * Decompiled with CFR 0.152.
 */
package eva.multiplacer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.multiplacer.MultiPlacerClient;
import eva.multiplacer.config.MultiPlacerConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static File templateConfig;
    public static Gson configGson;

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
    }

    public static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            templateConfig = new File(folder, "multiplacer.json");
            if (templateConfig.exists()) {
                try {
                    String templateConfigJson = Files.readString(Path.of(templateConfig.getPath(), new String[0]));
                    seemsValid = templateConfigJson.trim().startsWith("{");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!templateConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    MultiPlacerClient.LOGGER.info("Found invalid config file, creating new config file at './config/moreshieldvariants.json'.");
                }
                try {
                    templateConfig.createNewFile();
                    String json = configGson.toJson((Object)MultiPlacerConfig.getInstance());
                    FileWriter writer = new FileWriter(templateConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void readFromConfig() {
        try {
            MultiPlacerConfig config = (MultiPlacerConfig)configGson.fromJson((Reader)new FileReader(templateConfig), MultiPlacerConfig.class);
            MultiPlacerConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)MultiPlacerConfig.getInstance());
            FileWriter writer = new FileWriter(templateConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
    }
}

