package eva.replacer.config;

import java.util.*;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class RePlacerConfig {

    private boolean rotate = true;

    private Hashtable<String, Set<RelPos>> builds = new Hashtable<>();

    public static List<String> names =  new ArrayList<>();
    public static int selection = 0;
    public static boolean reCording = false;
    public static boolean reFirst = true;
    public static String buildName;
    public static List<RelPos> build;
    private static RePlacerConfig INSTANCE;

    public static RePlacerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RePlacerConfig();
        }
        return INSTANCE;
    }

    public void updateConfigs(RePlacerConfig config) {
        this.rotate = config.rotate;
        this.builds = config.builds;
        names = buildNames();
    }

    public static boolean isRotate() {
        return getInstance().rotate;
    }

    static void setRotate(boolean rotate) {
        getInstance().rotate = rotate;
    }

    public static Hashtable<String, Set<RelPos>> getBuilds() {return getInstance().builds;}

    public static void saveBuild(boolean confirm) {
        getInstance().builds.put(buildName, new HashSet<>(build));
        buildName = null;
        build = null;
        reFirst = true;
        reCording = false;
    }

    static void saveBuilds(List<String> list) {
        final List<String> names2 = list;
        Hashtable<String, Set<RelPos>> buildict = new Hashtable<>();
        list.forEach(name -> {
             try {
                 buildict.put(name, getInstance().builds.get(name));
             } catch (NullPointerException ignored) {
                 names2.remove(name);
             }
        });
        RePlacerConfig.names = names2;
        getInstance().builds = buildict;
    }

    public static List<String> buildNames() {
        List<String> buildNames = new ArrayList<>();
        Enumeration<String> it = getInstance().builds.keys();
        while (it.hasMoreElements())
            buildNames.add(it.nextElement());
        names = buildNames;
        return names;
    }

    public static class RelPos {
        private final double[] vec = new double[3];
        private final class_2350 dir;
        private final int[] pos = new int[3];
        private static double[] baseVec;
        private static int[] basePos;

        public static void setBase(class_243 v, class_2338 p) {
            baseVec = new double[]{v.field_1352, v.field_1351, v.field_1350};
            basePos = new int[]{p.method_10263(), p.method_10264(), p.method_10260()};
        }
        public RelPos(class_243 vec, class_2350 dir, class_2338 pos) {
            this.vec[0] = vec.field_1352 - baseVec[0];
            this.vec[1] = vec.field_1351 - baseVec[1];
            this.vec[2] = vec.field_1350 - baseVec[2];
            this.dir = dir;
            this.pos[0] = pos.method_10263() - basePos[0];
            this.pos[1] = pos.method_10264() - basePos[1];
            this.pos[2] = pos.method_10260() - basePos[2];
        }

        public class_243 vec() {
            return new class_243(this.vec[0] + baseVec[0], this.vec[1] + baseVec[1], this.vec[2] + baseVec[2]);
        }
        public class_2350 dir() {return dir;}
        public class_2338 pos() {
            return new class_2338(this.pos[0] + basePos[0], this.pos[1] + basePos[1], this.pos[2] + basePos[2]);
        }
    }

    public static void buildSaver(class_1838 context) {
        if (reFirst) {
            build = new ArrayList<>();
        }
        class_2338 pos = context.method_8037();
        class_2350 dir = context.method_8038();
        class_243 vec = context.method_17698();
        if (reFirst) {
            RelPos.setBase(vec, pos);
            reFirst = false;
        }
        build.add(new RelPos(vec, dir, pos));
    }
}
