package eva.replacer.config;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;

import static eva.replacer.config.RePlacerConfig.*;

public class RePlacerConfigScreen implements ModMenuApi {
    public static ConfigBuilder builder() {
        ConfigBuilder builder = ConfigBuilder.create()
                .setTitle(class_2561.method_43470("RePlacer Config"))
                .setSavingRunnable(JsonConfigHelper::writeToConfig)
                .setEditable(true);
        RePlacerConfig INSTANCE = getInstance();
        if (reCording)
            builder.getOrCreateCategory(class_2561.method_43470("Confirm build save?"))
                            .addEntry(builder.entryBuilder()
                                    .startBooleanToggle(class_2561.method_43470("Are you sure you want to save " + buildName + " as a build?"), false)
                                    .setSaveConsumer(RePlacerConfig::saveBuild)
                                    .build()
                            );
        else {
            builder.getOrCreateCategory(class_2561.method_43470("Options"))
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("Rotate builds:"), isRotate())
                            .setTooltip(class_2561.method_43470("Rotate builds along all three axes"))
                            .setSaveConsumer(RePlacerConfig::setRotate)
                            .build()
                    );
            builder.getOrCreateCategory(class_2561.method_43470("ReCorder"))
                    .addEntry(builder.entryBuilder()
                            .startStrField(class_2561.method_43470("Build Name:"), "")
                            .setTooltip(class_2561.method_43470("When you save a build,\nwhatever's in this field\nwill be its name."))
                            .setSaveConsumer(newName -> buildName = newName)
                            .build()
                    )
                    .addEntry(builder.entryBuilder()
                            .startBooleanToggle(class_2561.method_43470("ReCord on Menu Close:"), reCording)
                            .setSaveConsumer(value -> reCording = value)
                            .setTooltip(class_2561.method_43470("If this is on, your block\nplacements will be recorded\nas a build until you turn\nit off"))
                            .build()
                    );
            builder.getOrCreateCategory(class_2561.method_43470("Build Management"))
                    .addEntry(builder.entryBuilder()
                            .startStrList(class_2561.method_43470("Build Names:"), buildNames())
                            .setDeleteButtonEnabled(true)
                            .setRemoveButtonTooltip(class_2561.method_43470("Deleting this will delete the build!"))
                            .setExpanded(true)
                            .setSaveConsumer(RePlacerConfig::saveBuilds)
                            .build()
                    );
        }
        return builder;
    }

    @Override
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            // Return the screen here with the one you created from Cloth Config Builder
            return builder().setParentScreen(parent).build();
        };
    }
}