package eva.replacer.mixin.client;

import eva.replacer.RePlacerClient;
import eva.replacer.util.RelPos;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static eva.replacer.RePlacerClient.isHeldOrToggled;
import static eva.replacer.config.JsonConfigHelper.writeSquare;
import static eva.replacer.config.RePlacerConfig.*;
import static eva.replacer.util.BuildHolder.setBaseDir;
import static eva.replacer.util.BuildHolder.setFacing;

@Mixin(class_1747.class)
public class BlockItemMixin {

    @Unique private final class_1747 blit = (class_1747) (Object) this;
    @Unique private boolean rePlacing = false;
    @Unique private boolean no = false;
    @Inject(
            method = "place",
            at = @At("TAIL")
    )
    private void placeAgain(class_1750 context, CallbackInfoReturnable<class_1269> cir) {
        if (no) {
            no = false;
            return;
        }
        if (rePlacing)
            return;
        if (reCording) {
            if (buildSaver(context)) {
                assert context.method_8036() != null;
                context.method_8036().method_7353(class_2561.method_43470("Central block saved!"), true);
            }
            return;
        }
        if (!isHeldOrToggled()) return;
        class_1657 player = context.method_8036();
        assert player != null;
        if (getBuild() == null) {
            RePlacerClient.LOGGER.info("Failed to get build!");
            player.method_7353(class_2561.method_43470("Failed to get build!"), true);
            player.method_7353(class_2561.method_43470("Writing default build."), false);
            writeSquare();
            no = true;
            return;
        }
        rePlacing = true;
        RelPos.setBase(context.method_17698(), context.method_8037());
        try {
            if (isRotatePlace())
                setBaseDir(context.method_8038());
            if (isRotateFace()) {
                class_243 v0 = context.method_8036().method_5720();
                double[] v1 = {v0.field_1352, v0.field_1351, v0.field_1350};
                v1[context.method_8038().method_10166().ordinal()] = 0.0;
                setFacing(class_2350.method_58251(new class_243(v1[0], v1[1], v1[2]).method_1029()));
            }
            getBuild().rotateEach(pos -> {
                if (!context.method_8041().method_7960())
                    if (player.method_56093(pos.pos(), player.method_55754() * 1.2))
                        if (!pos.equals(new RelPos(0, 0, 0)))
                            if (player.method_37908().method_8320(pos.pos()).method_45474()) {
                                blit.method_7712(new class_1750(
                                        player,
                                        context.method_20287(),
                                        player.method_5998(context.method_20287()),
                                        new class_3965(
                                                pos.vec(),
                                                context.method_8038(),
                                                pos.pos(),
                                                context.method_17699()
                                                )
                                        )
                                );
                                player.method_7259(class_3468.field_15372.method_14956(blit));
                            }
            });
        } catch (Exception ignored) {}
        setBaseDir(null);
        rePlacing = false;
    }
}
