package eva.replacer.util;

import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_2350;

import static eva.replacer.config.RePlacerConfig.isRotateFace;
import static eva.replacer.config.RePlacerConfig.isRotatePlace;

public record BuildHolder(class_2350 firstDir, @Nullable class_2350 faceDir, RelPos[] posList) {
    private static class_2350 baseDir;
    private static class_2350 facing;

    public BuildHolder(class_2350 firstDir, RelPos[] posList) {
        this(firstDir, null, posList);
    }

    public static void setBaseDir(class_2350 baseDir) {
        BuildHolder.baseDir = baseDir;
    }
    public static void setFacing(class_2350 facing) {BuildHolder.facing = facing;}

    private RelPos rotatePlace(RelPos pos) {
        if (!isRotatePlace() || this.firstDir == baseDir)
            return pos;
        if (this.firstDir().method_10166() == baseDir.method_10166()) {
            int ind = this.firstDir().method_10166().ordinal();
            int[] vals = new int[3];
            vals[0] = pos.vals()[0];
            vals[1] = pos.vals()[1];
            vals[2] = pos.vals()[2];
            vals[ind] *= -1;
            return new RelPos(vals);
        }
        int[] ind = {this.firstDir().method_10166().ordinal(), baseDir.method_10166().ordinal()};
        int[] neg;
        if (this.firstDir().method_10171() == baseDir.method_10171())
            neg = new int[]{-1, 1};
        else
            neg = new int[]{1, -1};
        int[] vals = new int[3];
        vals[ind[0]] = pos.vals()[ind[1]] * neg[1];
        vals[ind[1]] = pos.vals()[ind[0]] * neg[0];
        vals[3 - ind[0] - ind[1]] = pos.vals()[3 - ind[0] - ind[1]];
        return new RelPos(vals);
    }

    private RelPos rotateFace(RelPos pos) {
        class_2350 tempDir = rot();
        if (!isRotateFace() || facing == tempDir || this.faceDir == null)
            return pos;
        if (facing.method_10166() == tempDir.method_10166()) {
            if (facing.method_10166() != class_2350.class_2351.field_11052)
                return new RelPos(-pos.vals()[0], pos.vals()[1], -pos.vals()[2]);
            return new RelPos(pos.vals()[0], -pos.vals()[1], pos.vals()[2]);
        } else {
            class_2350.class_2351 ax = class_2350.class_2351.values()[3 - tempDir.method_10166().ordinal() - facing.method_10166().ordinal()];
            if ((tempDir.method_35833(ax) == facing && ax == class_2350.class_2351.field_11052) || (tempDir.method_35834(ax) == facing && ax != class_2350.class_2351.field_11052)) {
                if (ax == class_2350.class_2351.field_11052)
                    return new RelPos(-pos.vals()[2], pos.vals()[1], pos.vals()[0]);
                else if (ax == class_2350.class_2351.field_11048) {
                    return new RelPos(pos.vals()[0], -pos.vals()[2], -pos.vals()[1]);
                } else
                    return new RelPos(pos.vals()[1], pos.vals()[0], pos.vals()[2]);
            } else {
                if (ax == class_2350.class_2351.field_11052)
                    return new RelPos(pos.vals()[2], pos.vals()[1], -pos.vals()[0]);
                else if (ax == class_2350.class_2351.field_11048)
                    return new RelPos(pos.vals()[0], pos.vals()[2], pos.vals()[1]);
                else
                    return new RelPos(-pos.vals()[1], -pos.vals()[0], pos.vals()[2]);
            }
        }
    }

    public void rotateEach(Consumer<RelPos> action) {
        for (RelPos pos : this.posList) {
            if (!(isRotatePlace() || isRotateFace()))
                action.accept(pos);
            else //if (baseDir.getAxis() == Direction.Axis.Y)
                action.accept(rotateFace(rotatePlace(pos)));
//            else {
//                if (isRotateFace()) {
//                    Direction temp = baseDir;
//                    baseDir = firstDir();
//                    pos = rotateFace(pos);
//                    baseDir = temp;
////                    if (firstDir.getAxis() == Direction.Axis.Y)
////                        pos = new RelPos(-pos.vals()[0], pos.vals()[1], -pos.vals()[2]);
//                }
//                action.accept(rotatePlace(pos));
//            }
        }
    }

    private class_2350 rot() {
        try {
            if (this.firstDir == baseDir) return this.faceDir;
            if (this.firstDir.method_10166() == baseDir.method_10166()) return this.faceDir.method_10153();
            if (!(this.firstDir.method_10166() == this.faceDir.method_10166() || baseDir.method_10166() == this.faceDir.method_10166())) return this.faceDir;
            class_2350.class_2351 ax = class_2350.class_2351.values()[3 - this.firstDir.method_10166().ordinal() - baseDir.method_10166().ordinal()];
            if (this.firstDir.method_35833(ax) == baseDir) return this.faceDir.method_35833(ax);
            return this.faceDir.method_35834(ax);
        } catch (NullPointerException e) {
            return this.faceDir;
        }
    }
}
