package eva.replacer.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import static eva.replacer.RePlacerClient.isHoldingEither;
import static eva.replacer.RePlacerClient.setQuickAccess;
import static eva.replacer.config.RePlacerConfig.getQuickAccessName;
import static eva.replacer.config.RePlacerConfig.hasQuickAccess;

@Mixin(class_310.class)
public class MinecraftMixin {
    @Unique
    class_310 mc = (class_310)(Object) this;
    @ModifyExpressionValue(
            method = "handleKeybinds",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/KeyMapping;consumeClick()Z",
                    ordinal = 2
            )
    )
    private boolean quickAccessBuilds(boolean original, @Local(ordinal = 0) int slot) {
        assert mc.field_1724 != null;
        if (mc.field_1724.method_7325()) return original;
        if (isHoldingEither() && hasQuickAccess(slot + 1 % class_1661.field_30641)) {
            setQuickAccess(slot + 1 % class_1661.field_30641);
            mc.field_1724.method_7353(class_2561.method_43470("Activated " + getQuickAccessName() + " for quick access"), true);
            return false;
        }
        else return original;
    }
}