/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.config;

import eva.replacer.RePlacerClient;
import eva.replacer.config.JsonConfigHelper;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RePlacerConfig {
    static final int ver = 0;
    private final int v = 0;
    private boolean rotateFace = true;
    private boolean rotatePlace = true;
    private boolean inclTail = false;
    private static List<String> names = new ArrayList<String>();
    private static final List<String> taillessNames = new ArrayList<String>();
    public static Boolean isServer;
    public static int selection;
    public static boolean reCording;
    static String buildName;
    private static List<RelPos> tempBuild;
    private static RePlacerConfig INSTANCE;
    private static class_2350 placeDir;
    private static class_2350 faceDir;
    static boolean isHollow;
    public static boolean deny;
    private static final Map<Integer, String> quickAccess;
    static final String SPIN = "s";
    static final String SNAP = "f";
    static final String NO = "n";
    static final String DIV = "--";
    static final String REGEX = "[sfn]";
    static final String REGEXNUM = "[1-9]";

    public static RePlacerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RePlacerConfig();
        }
        return INSTANCE;
    }

    void updateConfigs(@NotNull RePlacerConfig config) {
        this.rotateFace = config.rotateFace;
        this.rotatePlace = config.rotatePlace;
    }

    public static boolean isSpin() {
        if (names.isEmpty()) {
            return false;
        }
        if (!RePlacerConfig.hasTail(names.get(selection)) || !RePlacerConfig.tail(names.get(selection)).contains(NO) && !RePlacerConfig.tail(names.get(selection)).contains(SPIN)) {
            return RePlacerConfig.getInstance().rotateFace;
        }
        return RePlacerConfig.tail(names.get(selection)).contains(SPIN);
    }

    static boolean spin() {
        return RePlacerConfig.getInstance().rotateFace;
    }

    static void setSpin(boolean rotate) {
        RePlacerConfig.getInstance().rotateFace = rotate;
    }

    public static boolean isSnap() {
        if (names.isEmpty()) {
            return false;
        }
        if (!RePlacerConfig.hasTail(names.get(selection)) || !RePlacerConfig.tail(names.get(selection)).contains(NO) && !RePlacerConfig.tail(names.get(selection)).contains(SNAP)) {
            return RePlacerConfig.getInstance().rotatePlace;
        }
        return RePlacerConfig.tail(names.get(selection)).contains(SNAP);
    }

    static boolean snap() {
        return RePlacerConfig.getInstance().rotatePlace;
    }

    static void setSnap(boolean rotate) {
        RePlacerConfig.getInstance().rotatePlace = rotate;
    }

    public static List<String> getNames() {
        return new ArrayList<String>(names);
    }

    static List<String> getTaillessNames() {
        return taillessNames;
    }

    static void setNames(List<String> newNames) {
        names = new ArrayList<String>(newNames);
        taillessNames.clear();
        for (String name : newNames) {
            if (RePlacerConfig.parseAccess(name) != -1) {
                quickAccess.put(RePlacerConfig.parseAccess(name), name);
            }
            taillessNames.add(RePlacerConfig.removeTail(name));
        }
    }

    public static boolean isServer() {
        return isServer;
    }

    public static boolean isInclTail() {
        return RePlacerConfig.getInstance().inclTail;
    }

    static void setInclTail(boolean inclTail) {
        RePlacerConfig.getInstance().inclTail = inclTail;
    }

    @Nullable
    public static BuildHolder getBuild() {
        try {
            BuildHolder build = JsonConfigHelper.readBuild(names.get(selection));
            if (build.sort()) {
                JsonConfigHelper.writeBuild(names.get(selection), build);
            }
            return build;
        }
        catch (Exception e) {
            if (e instanceof IndexOutOfBoundsException) {
                return null;
            }
            JsonConfigHelper.writeSquare();
            return null;
        }
    }

    @Nullable
    public static BuildHolder getQuickBuild() {
        try {
            return JsonConfigHelper.readBuild(quickAccess.get(RePlacerClient.getQuickAccess()));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static void saveBuild() {
        if (!deny && class_310.method_1551().field_1724 != null) {
            try {
                if (isHollow) {
                    tempBuild.removeFirst();
                }
                JsonConfigHelper.writeBuild(buildName, new BuildHolder(placeDir, faceDir, tempBuild.toArray(new RelPos[0])));
                RePlacerClient.LOGGER.info("Saved {}!", (Object)RePlacerConfig.tailless(buildName));
                List<String> temp = names;
                temp.add(buildName);
                RePlacerConfig.setNames(temp);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    RePlacerClient.LOGGER.warn("Could not save build! Build was likely empty!");
                }
                RePlacerClient.LOGGER.warn("Could not save build! Build name wass likely empty!");
            }
        }
        buildName = null;
        tempBuild = null;
        reCording = false;
        placeDir = null;
        faceDir = null;
        isHollow = false;
        deny = false;
        RePlacerClient.LOGGER.info("Purged temp vars");
        JsonConfigHelper.writeToConfig();
    }

    static void buildDeleter(@NotNull List<String> list) {
        if (list.equals(names)) {
            return;
        }
        ArrayList<String> list2 = new ArrayList<String>(list);
        list.forEach(build -> {
            try {
                if (build.contains(DIV)) {
                    String tail = RePlacerConfig.tail(build);
                    String name = build.substring(0, build.indexOf(DIV));
                    int ind = names.contains(name) ? names.indexOf(name) : RePlacerConfig.getTaillessNames().indexOf(name);
                    String oldName = names.get(ind);
                    if (!tail.isEmpty()) {
                        JsonConfigHelper.renameBuild(oldName, name + DIV + tail);
                    } else {
                        JsonConfigHelper.pullBuild(oldName);
                        list2.remove(build);
                        list2.add(oldName);
                    }
                } else {
                    JsonConfigHelper.pullBuild(build);
                }
            }
            catch (FileNotFoundException e) {
                list2.remove(build);
            }
        });
        names.forEach(name -> {
            if (!list2.contains(name)) {
                JsonConfigHelper.deleteBuild(name);
            }
        });
        RePlacerConfig.setNames(list2);
        if (selection > names.size()) {
            selection = names.size();
        }
    }

    public static boolean buildSaver(@NotNull class_1750 context) {
        class_2338 pos = context.method_8037();
        boolean disp = false;
        if (tempBuild == null) {
            placeDir = context.method_8038();
            assert (context.method_8036() != null);
            class_243 v0 = context.method_8036().method_5720();
            double[] v1 = new double[]{v0.field_1352, v0.field_1351, v0.field_1350};
            v1[RePlacerConfig.placeDir.method_10166().ordinal()] = 0.0;
            faceDir = class_2350.method_58251((class_243)new class_243(v1[0], v1[1], v1[2]).method_1029());
            tempBuild = new ArrayList<RelPos>();
            RelPos.setBase(pos);
            disp = true;
        }
        RelPos rel = new RelPos(pos);
        boolean[] containerCheck = new boolean[]{true};
        tempBuild.forEach(r -> {
            if (r.equals(rel)) {
                containerCheck[0] = false;
            }
        });
        if (containerCheck[0]) {
            tempBuild.add(rel);
        }
        return disp;
    }

    static boolean isValidTail(String tail) {
        if (!tail.trim().equals(tail)) {
            return false;
        }
        if ((tail = tail.toLowerCase()).isEmpty() || tail.length() > 3) {
            return false;
        }
        if (!tail.replaceAll(REGEX, "").replaceAll(REGEXNUM, "").isEmpty()) {
            return false;
        }
        if ((tail = tail.replaceAll(REGEXNUM, "")).length() <= 1) {
            return true;
        }
        if (tail.replaceAll(SNAP, "").isEmpty()) {
            return false;
        }
        if (tail.replaceAll(SPIN, "").isEmpty()) {
            return false;
        }
        return !tail.replaceAll(NO, "").isEmpty();
    }

    static boolean hasTail(String build) {
        if (!build.contains(DIV)) {
            return false;
        }
        if (RePlacerConfig.tail(build).isEmpty()) {
            return true;
        }
        return RePlacerConfig.isValidTail(RePlacerConfig.tail(build));
    }

    static String tail(String build) {
        String tail;
        switch (tail = build.substring(build.indexOf(DIV) + 2).trim()) {
            case "nn": {
                return NO;
            }
            case "ss": {
                return SPIN;
            }
            case "ff": {
                return SNAP;
            }
        }
        if (RePlacerConfig.isValidTail(tail)) {
            return tail;
        }
        return "";
    }

    public static String tailless(String build) {
        if (RePlacerConfig.isInclTail() || !RePlacerConfig.hasTail(build)) {
            return build;
        }
        return RePlacerConfig.removeTail(build);
    }

    static String removeTail(String build) {
        if (!RePlacerConfig.hasTail(build)) {
            return build;
        }
        return build.substring(0, build.indexOf(DIV));
    }

    static int parseAccess(String name) {
        if (!RePlacerConfig.hasTail(name) || !RePlacerConfig.isValidTail(RePlacerConfig.tail(name))) {
            return -1;
        }
        String remainder = RePlacerConfig.tail(name).replaceAll(REGEX, "");
        if (remainder.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(remainder) - 1;
    }

    public static boolean hasQuickAccess(int slot) {
        return quickAccess.containsKey(slot);
    }

    static void startReCording(boolean val) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        reCording = val;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static BuildHolder buildDefault() {
        return new BuildHolder(class_2350.field_11036, class_2350.field_11043, new RelPos(0, 0, 0), new RelPos(0, 0, 1), new RelPos(0, 0, -1), new RelPos(1, 0, 0), new RelPos(1, 0, 1), new RelPos(1, 0, -1), new RelPos(-1, 0, 0), new RelPos(-1, 0, 1), new RelPos(-1, 0, -1));
    }

    static CellErrorSupplier getCellErrorSupplier() {
        return new CellErrorSupplier();
    }

    static NameErrorSupplier getNameErrorSupplier() {
        return new NameErrorSupplier();
    }

    static ErrorSupplier getErrorSupplier() {
        return new ErrorSupplier();
    }

    static {
        selection = 0;
        reCording = false;
        isHollow = false;
        deny = false;
        quickAccess = new HashMap<Integer, String>();
    }

    private static class CellErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private CellErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if ((entry = entry.toLowerCase()).indexOf(RePlacerConfig.DIV) != entry.lastIndexOf(RePlacerConfig.DIV)) {
                return Optional.of(class_2561.method_43470((String)"You cannot have more than one modifier tail! error code: 0"));
            }
            if (!RePlacerConfig.hasTail(entry) || RePlacerConfig.isValidTail(RePlacerConfig.tail(entry))) {
                return Optional.empty();
            }
            if (RePlacerConfig.tail(entry).isEmpty()) {
                return Optional.of(class_2561.method_43470((String)"Tail is empty! error code: 1"));
            }
            return Optional.of(class_2561.method_43470((String)"Invalid tail! error code: 2"));
        }
    }

    private static class NameErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private NameErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if (!RePlacerConfig.hasTail(entry) || RePlacerConfig.isValidTail(RePlacerConfig.tail(entry))) {
                if (RePlacerConfig.getTaillessNames().contains(RePlacerConfig.removeTail(entry))) {
                    return Optional.of(class_2561.method_43470((String)"Duplicate name! error code: 6"));
                }
                return Optional.empty();
            }
            return Optional.of(class_2561.method_43470((String)"Invalid tail! error code: 7"));
        }
    }

    private static class ErrorSupplier
    implements Function<List<String>, Optional<class_2561>> {
        private ErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(List<String> entry) {
            if (entry.isEmpty()) {
                return Optional.empty();
            }
            HashSet<Integer> quickInts = new HashSet<Integer>();
            HashSet<String> taillessNames = new HashSet<String>(RePlacerConfig.getTaillessNames());
            HashSet<String> names = new HashSet<String>();
            for (String build : entry) {
                int i;
                String tail;
                String tailless = RePlacerConfig.removeTail(build);
                if (names.contains(tailless)) {
                    return Optional.of(class_2561.method_43470((String)"Duplicate build name! error code: 3"));
                }
                if (!taillessNames.contains(tailless)) {
                    return Optional.of(class_2561.method_43470((String)"You cannot add builds or change their names here! error code: 4"));
                }
                names.add(tailless);
                if (!RePlacerConfig.hasTail(build) || (tail = RePlacerConfig.tail(build)).replaceAll(RePlacerConfig.REGEX, "").isEmpty() || quickInts.add(i = Integer.parseInt(tail))) continue;
                return Optional.of(class_2561.method_43470((String)"Each build can have a max of one quickaccess number! error code: 5"));
            }
            return Optional.empty();
        }
    }
}

