package eva.replacer;

import com.terraformersmc.modmenu.ModMenu;
import eva.replacer.config.JsonConfigHelper;
import eva.replacer.rendering.BlockHighlightRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static eva.replacer.config.JsonConfigHelper.writeSquare;
import static eva.replacer.config.RePlacerConfig.*;

public class RePlacerClient implements ClientModInitializer {
    public static final String MOD_ID = RePlacerMain.MOD_ID + "-client";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static class_304 modifierBind;
    public static class_304 cycleBind;
    public static class_304 modifierToggle;
    private static boolean toggled = false;
    private static boolean modMenu = false;
    @Override
    public void onInitializeClient() {

        JsonConfigHelper.init();

        modMenu = FabricLoader.getInstance().isModLoaded("modmenu");
        // This entrypoint is suitable for setting up client-specific logic, such as rendering.
         modifierBind = KeyBindingHelper.registerKeyBinding(new class_304(
                "RePlacer Modifier Key",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_LEFT_ALT,
                "RePlacer"
         ));
         cycleBind = KeyBindingHelper.registerKeyBinding(new class_304(
                 "RePlacer Cycle Key",
                 class_3675.class_307.field_1668,
                 GLFW.GLFW_KEY_Z,
                 "RePlacer"
         ));
         modifierToggle = KeyBindingHelper.registerKeyBinding(new class_304(
                 "RePlacer Modifier Toggle Key",
                 class_3675.class_307.field_1668,
                 GLFW.GLFW_KEY_UNKNOWN,
                 "RePlacer"
         ));

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            assert client.field_1724 != null;
            if (modMenu && modifierBind.method_1434() && cycleBind.method_1436()) {
                if (reCording) {
                    client.method_1507(ModMenu.getConfigScreen("rp", client.field_1755));
                } else {
                    client.field_1724.method_7353(class_2561.method_43470("Recording started!"), true);
                    reCording = true;
                }
            } else if (cycleBind.method_1436()) {
                if (client.field_1724.method_5715()) {
                    selection--;
                    if (selection < 0) selection = getNames().size() - 1;
                } else {
                    selection++;
                    if (selection >= getNames().size()) selection = 0;
                }
                try {
                    client.field_1724.method_7353(class_2561.method_43470("swapped to " + getNames().get(selection)), true);
                } catch (Exception ignored) {
                    client.field_1724.method_7353(class_2561.method_43470("No builds registered!"), false);
                    client.field_1724.method_7353(class_2561.method_43470("Loading default build"), false);
                    writeSquare();
                    selection = 0;
                    client.field_1724.method_7353(class_2561.method_43470("swapped to square"), true);
                }
            }
            if (modifierToggle.method_1436()) {
                toggled = !toggled;
            }
        });

        WorldRenderEvents.BLOCK_OUTLINE.register((worldRenderContext, blockOutlineContext) -> BlockHighlightRenderer.renderRePlacerBox(
                worldRenderContext.matrixStack()));
    }

    public static boolean isHeldOrToggled() {
        return toggled || modifierBind.method_1434();
    }
}