/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eva.replacer.RePlacerClient;
import eva.replacer.config.RePlacerConfig;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.BuildHolderDep;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class JsonConfigHelper {
    private static final File folder = new File("config");
    private static final File buildFolder = new File(folder, "RePlacer Builds");
    private static List<File> files;
    private static File rePlacerConfig;
    public static final Gson configGson;
    private static final File square;
    private static final Map<String, BuildHolder> cache;
    private static final String EXT = ".json";
    private static final String EXT_OLD = ".json";

    public static void init() {
        JsonConfigHelper.createConfig();
        JsonConfigHelper.readFromConfig();
        JsonConfigHelper.writeToConfig();
        JsonConfigHelper.createBuilds();
    }

    private static void createConfig() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            boolean seemsValid;
            rePlacerConfig = new File(folder, "replacer.json");
            if (rePlacerConfig.exists()) {
                try {
                    String templateConfigJson = Files.readString(Path.of(rePlacerConfig.getPath(), new String[0]));
                    seemsValid = templateConfigJson.trim().startsWith("{\n  \"v\": 0,");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                seemsValid = true;
            }
            if (!rePlacerConfig.exists() || !seemsValid) {
                if (!seemsValid) {
                    RePlacerClient.LOGGER.info("Found invalid config file, creating new config file at './config/replacer.json'.");
                }
                try {
                    rePlacerConfig.createNewFile();
                    String json = configGson.toJson((Object)RePlacerConfig.getInstance());
                    FileWriter writer = new FileWriter(rePlacerConfig);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void readFromConfig() {
        try {
            RePlacerConfig config = (RePlacerConfig)configGson.fromJson((Reader)new FileReader(rePlacerConfig), RePlacerConfig.class);
            RePlacerConfig.getInstance().updateConfigs(config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeToConfig() {
        try {
            String json = configGson.toJson((Object)RePlacerConfig.getInstance());
            FileWriter writer = new FileWriter(rePlacerConfig, false);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void createBuilds() {
        if (!buildFolder.exists()) {
            buildFolder.mkdir();
        }
        if (buildFolder.isDirectory()) {
            ArrayList<String> names = new ArrayList<String>();
            files = new ArrayList<File>(List.of(Objects.requireNonNull(new File("config/RePlacer Builds").listFiles())));
            ArrayList<File> markedForDeletion = new ArrayList<File>();
            if (files.isEmpty()) {
                return;
            }
            try {
                for (File file : files) {
                    boolean seemsValid;
                    if (!file.isFile()) continue;
                    String fileName = file.getName();
                    if (!file.getName().endsWith(".json")) continue;
                    String name = fileName.replace(".json", "");
                    BuildHolder build = null;
                    if (file.exists()) {
                        try {
                            build = JsonConfigHelper.pullBuild(name);
                            seemsValid = build != null;
                        }
                        catch (FileNotFoundException e) {
                            seemsValid = false;
                        }
                    } else {
                        seemsValid = true;
                    }
                    if (!seemsValid) {
                        RePlacerClient.LOGGER.info("Found invalid build file : " + name + ", ignoring.");
                        markedForDeletion.add(file);
                        continue;
                    }
                    if (RePlacerConfig.hasTail(name) && !RePlacerConfig.isValidTail(RePlacerConfig.tail(name))) {
                        RePlacerClient.LOGGER.info("Found invalid build file tail (" + name + "), removing. Resulting file name: " + RePlacerConfig.removeTail(name));
                        file.renameTo(new File(buildFolder, RePlacerConfig.removeTail(name)));
                        name = RePlacerConfig.removeTail(name);
                    }
                    names.add(name);
                    cache.put(name, build);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            RePlacerConfig.setNames(names);
            files.removeAll(markedForDeletion);
            if (RePlacerConfig.getTaillessNames().contains(RePlacerConfig.getDefBuild())) {
                RePlacerConfig.selection = RePlacerConfig.getTaillessNames().indexOf(RePlacerConfig.getDefBuild());
            } else {
                RePlacerConfig.selection = 0;
                RePlacerConfig.setDefBuild("");
            }
        }
    }

    static void deleteBuild(String name) {
        File forDeletion = new File(buildFolder, name + ".json");
        files.remove(forDeletion);
        cache.put(RePlacerConfig.removeTail(name), cache.remove(name));
        forDeletion.delete();
    }

    static void writeBuild(String name, BuildHolder holder) {
        try {
            String json = configGson.toJson((Object)holder);
            File forCreation = new File(buildFolder, name + ".json");
            FileWriter writer = new FileWriter(forCreation, false);
            writer.write(json);
            writer.close();
            files.add(forCreation);
            cache.put(name, holder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeSquare() {
        if (!RePlacerConfig.getTaillessNames().contains("square") && !RePlacerConfig.getTaillessDisabled().contains("square")) {
            try {
                configGson.fromJson((Reader)new FileReader(square), BuildHolder.class);
                if (RePlacerConfig.getNames().isEmpty()) {
                    List<String> names = RePlacerConfig.getNames();
                    names.add("square");
                    RePlacerConfig.setNames(names);
                }
            }
            catch (Exception ignored) {
                try {
                    RePlacerClient.LOGGER.info("Writing default build at './config/RePlacerBuilds/square.json'.");
                    FileWriter writer = new FileWriter(square, false);
                    writer.write(configGson.toJson((Object)RePlacerConfig.buildDefault()));
                    writer.close();
                    List<String> names = RePlacerConfig.getNames();
                    names.add("square");
                    RePlacerConfig.setNames(names);
                }
                catch (Exception f) {
                    throw new RuntimeException(f);
                }
            }
            if (!files.contains(square)) {
                files.add(square);
                cache.put("square", RePlacerConfig.buildDefault());
            }
        }
    }

    static BuildHolder readBuild(String name) {
        if (!cache.containsKey(name)) {
            RePlacerClient.LOGGER.info("Invalid buildname found! Purging!");
            List<String> temp = RePlacerConfig.getNames();
            temp.remove(name);
            RePlacerConfig.setNames(temp);
            files.remove(new File(buildFolder, name + ".json"));
            RePlacerConfig.selection = 0;
            return null;
        }
        return cache.get(name);
    }

    @Nullable
    static BuildHolder pullBuild(String name) throws FileNotFoundException {
        File toRead = new File(buildFolder, name + ".json");
        BuildHolder holder = (BuildHolder)configGson.fromJson((Reader)new FileReader(toRead), BuildHolder.class);
        if (holder.x() == null || holder.y() == null || holder.z() == null) {
            holder = ((BuildHolderDep)configGson.fromJson((Reader)new FileReader(toRead), BuildHolderDep.class)).asBuildHolder();
            JsonConfigHelper.writeBuild(name, holder);
        }
        return holder;
    }

    static boolean renameBuild(String oldName, String newName) {
        File oldFile = new File(buildFolder, oldName + ".json");
        if (!oldFile.exists()) {
            return false;
        }
        File newFile = new File(buildFolder, newName + ".json");
        if (newFile.exists()) {
            return false;
        }
        if (!oldFile.renameTo(newFile)) {
            return false;
        }
        cache.put(newName, cache.remove(oldName));
        files.remove(oldFile);
        files.add(newFile);
        return true;
    }

    static boolean reAddBuild(String name) {
        JsonConfigHelper.checkUpdates();
        HashMap mappedNames = new HashMap();
        cache.keySet().forEach(build -> mappedNames.put(RePlacerConfig.removeTail(build), build));
        if (mappedNames.containsKey(RePlacerConfig.removeTail(name)) || mappedNames.containsValue(name)) {
            boolean bl = cache.containsKey(name);
            JsonConfigHelper.writeBuild(name, cache.get(bl ? name : mappedNames.get(RePlacerConfig.removeTail(name))));
            return true;
        }
        return false;
    }

    static boolean isCachedBuild(String buildName) {
        if (cache.containsKey(RePlacerConfig.removeTail(buildName))) {
            return true;
        }
        HashSet mappedNames = new HashSet();
        cache.keySet().forEach(build -> mappedNames.add(RePlacerConfig.removeTail(build)));
        return mappedNames.contains(RePlacerConfig.removeTail(buildName));
    }

    static String getCachedVer(String name) {
        if (cache.containsKey(RePlacerConfig.removeTail(name))) {
            return RePlacerConfig.removeTail(name);
        }
        HashMap mappedNames = new HashMap();
        cache.keySet().forEach(build -> mappedNames.put(RePlacerConfig.removeTail(build), build));
        return (String)mappedNames.get(RePlacerConfig.removeTail(name));
    }

    static boolean hasBuildsCached() {
        HashSet<String> comp = new HashSet<String>(cache.keySet());
        RePlacerConfig.getNames().forEach(comp::remove);
        RePlacerConfig.getDisabled().forEach(comp::remove);
        RePlacerConfig.getTaillessNames().forEach(comp::remove);
        RePlacerConfig.getTaillessDisabled().forEach(comp::remove);
        return !comp.isEmpty();
    }

    static List<String> getCachedBuilds() {
        ArrayList<String> list = new ArrayList<String>(cache.keySet());
        list.removeAll(RePlacerConfig.getNames());
        list.removeAll(RePlacerConfig.getTaillessNames());
        list.removeAll(RePlacerConfig.getDisabled());
        list.removeAll(RePlacerConfig.getTaillessDisabled());
        for (int i = 0; i < list.size(); ++i) {
            String build = (String)list.get(i);
            if (!RePlacerConfig.hasTail(build)) continue;
            list.remove(build);
            list.add(i, RePlacerConfig.removeTail(build));
        }
        return new ArrayList<String>(new HashSet<String>(list));
    }

    public static void checkUpdates() {
        try {
            try {
                String name = RePlacerConfig.getNames().get(RePlacerConfig.selection);
                List<File> newFiles = List.of(Objects.requireNonNull(new File("config/RePlacer Builds").listFiles()));
                if (files.equals(newFiles)) {
                    return;
                }
                JsonConfigHelper.createBuilds();
                if (RePlacerConfig.getNames().contains(name)) {
                    RePlacerConfig.selection = RePlacerConfig.getNames().indexOf(name);
                }
            }
            catch (IndexOutOfBoundsException e) {
                JsonConfigHelper.writeSquare();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static {
        configGson = new GsonBuilder().setPrettyPrinting().create();
        square = new File(buildFolder, "square.json");
        cache = new HashMap<String, BuildHolder>();
    }
}

