/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.config;

import eva.replacer.RePlacerClient;
import eva.replacer.config.JsonConfigHelper;
import eva.replacer.config.SortOrder;
import eva.replacer.util.BuildHolder;
import eva.replacer.util.RelPos;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import me.shedaniel.math.Color;
import net.minecraft.class_1750;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RePlacerConfig {
    static final int ver = 0;
    private final int v = 0;
    private boolean rotateFace = true;
    private boolean rotatePlace = true;
    private boolean inclTail = false;
    private boolean exclude = false;
    private String defBuild = "";
    private SortOrder sortOrder = SortOrder.Near_player_last;
    private final int[] rat = new int[]{1, 1};
    private Color borderColor = defaultColors[0];
    private Color transparentBorderColor = defaultColors[1];
    private Color excludedColor = defaultColors[2];
    private Color transparentExcludedColor = defaultColors[3];
    private static final List<String> names = new ArrayList<String>(List.of("square"));
    private static final List<String> disabled = new ArrayList<String>();
    private static final List<String> taillessNames = new ArrayList<String>();
    private static final List<String> taillessDisabled = new ArrayList<String>();
    public static Boolean isServer;
    static int selection;
    static boolean reCording;
    static String buildName;
    private static Set<RelPos> tempBuild;
    private static RePlacerConfig INSTANCE;
    private static class_2350 placeDir;
    private static class_2350 faceDir;
    static boolean isHollow;
    public static boolean deny;
    private static final Map<Integer, String> quickAccess;
    private static final Color[] defaultColors;
    private static Boolean listSideCombinedErrorChecker;
    private static Boolean boolSideCombinedErrorChecker;
    private static final Set<Integer> namesSideInts;
    private static final Set<Integer> disabledSideInts;
    static final String SPIN = "s";
    static final String SNAP = "f";
    static final String NO = "n";
    static final String DIS = "d";
    static final String DIV = "--";
    static final String REGEX = "[sfnd]";
    static final String REGEXNUM = "[1-9]";
    static final String RAT = ":";
    static final String RAT2 = "/";

    public static Color getDefColors(int i) {
        return defaultColors[i];
    }

    public static RePlacerConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RePlacerConfig();
        }
        return INSTANCE;
    }

    void updateConfigs(@NotNull RePlacerConfig config) {
        this.rotateFace = config.rotateFace;
        this.rotatePlace = config.rotatePlace;
        this.inclTail = config.inclTail;
        this.defBuild = config.defBuild;
        this.exclude = config.exclude;
        this.sortOrder = config.sortOrder;
        this.rat[0] = config.rat[0];
        this.rat[1] = config.rat[1];
        this.borderColor = config.borderColor;
        this.transparentBorderColor = config.transparentBorderColor;
        this.excludedColor = config.excludedColor;
        this.transparentExcludedColor = config.transparentExcludedColor;
    }

    public static double getRatio() {
        return (double)RePlacerConfig.getInstance().rat[0] / (double)RePlacerConfig.getInstance().rat[1];
    }

    public static String getRatioStr() {
        return RePlacerConfig.getInstance().rat[0] + RAT + RePlacerConfig.getInstance().rat[1];
    }

    public static void setRatio(String entry) {
        int ticks;
        int blocks;
        if (entry.contains(RAT)) {
            blocks = Integer.parseInt(entry.substring(0, entry.indexOf(RAT)));
            ticks = Integer.parseInt(entry.substring(entry.indexOf(RAT) + 1));
        } else {
            blocks = Integer.parseInt(entry.substring(0, entry.indexOf(RAT2)));
            ticks = Integer.parseInt(entry.substring(entry.indexOf(RAT2) + 1));
        }
        int a = blocks;
        int b = ticks;
        while (a > 0 && b > 0 && a != b) {
            if (a > b) {
                a -= b;
                continue;
            }
            b -= a;
        }
        RePlacerConfig.getInstance().rat[0] = blocks / Math.max(a, b);
        RePlacerConfig.getInstance().rat[1] = ticks / Math.max(a, b);
    }

    public static boolean isSpin() {
        MutableObject mute = new MutableObject();
        if (RePlacerConfig.getRelevantName((MutableObject<String>)mute)) {
            return false;
        }
        String name = (String)mute.getValue();
        if (!RePlacerConfig.hasTail(name) || !RePlacerConfig.tail(name).toLowerCase().contains(NO) && !RePlacerConfig.tail(name).toLowerCase().contains(SPIN)) {
            return RePlacerConfig.getInstance().rotateFace;
        }
        return RePlacerConfig.tail(name).toLowerCase().contains(SPIN);
    }

    static boolean spin() {
        return RePlacerConfig.getInstance().rotateFace;
    }

    static void setSpin(boolean rotate) {
        RePlacerConfig.getInstance().rotateFace = rotate;
    }

    public static boolean isSnap() {
        MutableObject mute = new MutableObject();
        if (RePlacerConfig.getRelevantName((MutableObject<String>)mute)) {
            return false;
        }
        String name = (String)mute.getValue();
        if (!RePlacerConfig.hasTail(name) || !RePlacerConfig.tail(name).toLowerCase().contains(NO) && !RePlacerConfig.tail(name).toLowerCase().contains(SNAP)) {
            return RePlacerConfig.getInstance().rotatePlace;
        }
        return RePlacerConfig.tail(name).toLowerCase().contains(SNAP);
    }

    static boolean snap() {
        return RePlacerConfig.getInstance().rotatePlace;
    }

    static void setSnap(boolean rotate) {
        RePlacerConfig.getInstance().rotatePlace = rotate;
    }

    public static List<String> getNames() {
        return new ArrayList<String>(names);
    }

    static List<String> getTaillessNames() {
        return taillessNames;
    }

    static void setNames(List<String> newNames) {
        if ((newNames = new ArrayList<String>(new HashSet<String>(newNames))).isEmpty() || new HashSet<String>(newNames).equals(new HashSet<String>(names))) {
            return;
        }
        ArrayList<String> forRemoval = new ArrayList<String>();
        HashSet<String> tempDisabled = new HashSet<String>(disabled);
        for (String name : newNames) {
            if (!RePlacerConfig.hasTail(name) || !RePlacerConfig.tail(name).toLowerCase().contains(DIS)) continue;
            tempDisabled.add(name);
            forRemoval.add(name);
        }
        newNames.removeAll(forRemoval);
        names.clear();
        names.addAll(newNames);
        taillessNames.clear();
        for (String name : names) {
            if (RePlacerConfig.parseAccess(name) != -1) {
                quickAccess.put(RePlacerConfig.parseAccess(name), name);
            }
            taillessNames.add(RePlacerConfig.removeTail(name));
        }
        if (quickAccess.size() == names.size()) {
            RePlacerConfig.setExclude(false);
        }
        if (!tempDisabled.equals(new HashSet<String>(disabled))) {
            RePlacerConfig.setDisabled(new ArrayList<String>(tempDisabled));
        }
    }

    static List<String> getDisabled() {
        return disabled;
    }

    static List<String> getTaillessDisabled() {
        return taillessDisabled;
    }

    static void setDisabled(List<String> newDisabled) {
        if ((newDisabled = new ArrayList<String>(new HashSet<String>(newDisabled))).isEmpty() || new HashSet<String>(newDisabled).equals(new HashSet<String>(disabled))) {
            return;
        }
        ArrayList<String> tempNames = new ArrayList<String>(RePlacerConfig.getNames());
        ArrayList<String> tempDisabled = new ArrayList<String>();
        ArrayList<String> tempTaillessDisabled = new ArrayList<String>();
        for (String name : newDisabled) {
            if (!RePlacerConfig.hasTail(name) || !RePlacerConfig.tail(name).toLowerCase().contains(DIS)) {
                tempNames.add(RePlacerConfig.removeTail(name));
                continue;
            }
            tempDisabled.add(name);
            tempTaillessDisabled.add(RePlacerConfig.removeTail(name));
        }
        disabled.clear();
        disabled.addAll(tempDisabled);
        taillessDisabled.clear();
        taillessDisabled.addAll(tempTaillessDisabled);
        if (!tempNames.equals(names)) {
            RePlacerConfig.setNames(tempNames);
        }
    }

    public static String getDefBuild() {
        return RePlacerConfig.getInstance().defBuild;
    }

    static void setDefBuild(String defBuild) {
        RePlacerConfig.getInstance().defBuild = defBuild;
    }

    public static boolean isServer() {
        return isServer;
    }

    public static boolean isInclTail() {
        return RePlacerConfig.getInstance().inclTail;
    }

    static void setInclTail(boolean inclTail) {
        RePlacerConfig.getInstance().inclTail = inclTail;
    }

    static boolean isExclude() {
        return RePlacerConfig.getInstance().exclude;
    }

    static void setExclude(boolean exclude) {
        RePlacerConfig.getInstance().exclude = exclude;
    }

    public static SortOrder getSortOrder() {
        return RePlacerConfig.getInstance().sortOrder;
    }

    static void setSortOrder(SortOrder sortOrder) {
        RePlacerConfig.getInstance().sortOrder = sortOrder;
    }

    @Nullable
    public static Set<RelPos> getTempBuildForRendering() {
        if (tempBuild == null || tempBuild.isEmpty()) {
            return null;
        }
        return new HashSet<RelPos>(tempBuild);
    }

    public static void cycleSelection(boolean isNeg, int i) {
        if (names.isEmpty()) {
            if (taillessDisabled.contains("square")) {
                String oldName = disabled.remove(taillessDisabled.indexOf("square"));
                taillessDisabled.remove("square");
                String newName = RePlacerConfig.removeTail(oldName) + DIV + RePlacerConfig.tail(oldName).toLowerCase().replace(DIS, "");
                names.add(newName);
                taillessNames.add("square");
                JsonConfigHelper.renameBuild(oldName, newName);
            } else {
                names.add("square");
                taillessNames.add("square");
            }
        }
        if (i > names.size()) {
            return;
        }
        if (isNeg) {
            if (--selection < 0) {
                selection = RePlacerConfig.getNames().size() - 1;
            }
        } else {
            ++selection;
            selection %= RePlacerConfig.getNames().size();
        }
        if (RePlacerConfig.isExclude() && quickAccess.containsValue(names.get(selection))) {
            RePlacerConfig.cycleSelection(isNeg, i + 1);
        }
    }

    public static int getSelection() {
        return selection;
    }

    public static void tareSelection() {
        selection = 0;
    }

    @Nullable
    public static BuildHolder handleGetBuild() {
        return RePlacerClient.isQuickAccess() ? RePlacerConfig.getQuickBuild() : RePlacerConfig.getBuild();
    }

    @Nullable
    private static BuildHolder getBuild() {
        try {
            String name = names.get(selection);
            if (RePlacerConfig.removeTail(name).equals("square")) {
                return RePlacerConfig.buildDefault();
            }
            return JsonConfigHelper.readBuild(name);
        }
        catch (Exception e) {
            if (e instanceof IndexOutOfBoundsException) {
                return null;
            }
            JsonConfigHelper.writeSquare();
            return null;
        }
    }

    @Nullable
    private static BuildHolder getQuickBuild() {
        try {
            String name = quickAccess.get(RePlacerClient.getQuickAccess());
            if (RePlacerConfig.removeTail(name).equals("square")) {
                return RePlacerConfig.buildDefault();
            }
            return JsonConfigHelper.readBuild(name);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static void saveBuild() {
        if (!deny && class_310.method_1551().field_1724 != null) {
            try {
                if (isHollow) {
                    tempBuild.remove(RelPos.ORIGIN);
                }
                JsonConfigHelper.writeBuild(buildName, new BuildHolder(placeDir, faceDir, tempBuild.toArray(new RelPos[0])));
                RePlacerClient.LOGGER.info("Saved {}!", (Object)RePlacerConfig.tailless(buildName));
                List<String> temp = names;
                temp.add(buildName);
                RePlacerConfig.setNames(temp);
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) {
                    RePlacerClient.LOGGER.warn("Could not save build! Build was likely empty!");
                }
                RePlacerClient.LOGGER.warn("Could not save build! Build name wass likely empty!");
            }
        }
        buildName = null;
        tempBuild = null;
        reCording = false;
        placeDir = null;
        faceDir = null;
        isHollow = false;
        deny = false;
        RePlacerClient.LOGGER.info("Purged temp vars");
        JsonConfigHelper.writeToConfig();
    }

    static void buildDeleter(@NotNull List<String> list) {
        if (list.equals(names)) {
            return;
        }
        RePlacerConfig.setNames(RePlacerConfig.deleter(list, names, taillessNames));
        if (selection > names.size() && (selection = !RePlacerConfig.getDefBuild().isEmpty() ? names.indexOf(RePlacerConfig.getDefBuild()) : names.size()) < 0) {
            selection = 0;
        }
    }

    static void disabledDeleter(@NotNull List<String> list) {
        if (list.equals(disabled)) {
            return;
        }
        RePlacerConfig.setDisabled(RePlacerConfig.deleter(list, disabled, taillessDisabled));
    }

    private static List<String> deleter(@NotNull List<String> list, List<String> names, List<String> taillessNames) {
        ArrayList<String> tempNames = new ArrayList<String>(new HashSet<String>(list));
        list.forEach(build -> {
            block11: {
                if (!names.contains(build)) {
                    try {
                        if (RePlacerConfig.hasTail(build)) {
                            if (!taillessNames.contains(RePlacerConfig.removeTail(build))) {
                                JsonConfigHelper.reAddBuild(build);
                            }
                            String tail = RePlacerConfig.tail(build);
                            String name = RePlacerConfig.removeTail(build);
                            String oldName = JsonConfigHelper.getCachedVer(build);
                            if (!build.equals(oldName)) {
                                if (!tail.isEmpty()) {
                                    JsonConfigHelper.renameBuild(oldName, name + DIV + tail);
                                    tempNames.remove(oldName);
                                    tempNames.add(name + DIV + tail);
                                } else {
                                    JsonConfigHelper.pullBuild(oldName);
                                    tempNames.remove(build);
                                    tempNames.add(oldName);
                                }
                            }
                        } else if (taillessNames.contains(build)) {
                            String oldName = JsonConfigHelper.getCachedVer(build);
                            JsonConfigHelper.renameBuild(oldName, build);
                            tempNames.remove(oldName);
                            tempNames.add((String)build);
                        } else {
                            JsonConfigHelper.pullBuild(build);
                        }
                    }
                    catch (FileNotFoundException e) {
                        if (build.equals("square") || RePlacerConfig.hasTail(build) && RePlacerConfig.removeTail(build).equals("square")) break block11;
                        tempNames.remove(build);
                    }
                }
            }
        });
        names.forEach(name -> {
            if (!tempNames.contains(name)) {
                JsonConfigHelper.deleteBuild(name);
            }
        });
        return tempNames;
    }

    public static boolean buildSaver(@NotNull class_1750 context) {
        class_2338 pos = context.method_8037();
        boolean disp = false;
        if (tempBuild == null) {
            placeDir = context.method_8038();
            assert (context.method_8036() != null);
            class_243 v0 = context.method_8036().method_5720();
            double[] v1 = new double[]{v0.field_1352, v0.field_1351, v0.field_1350};
            v1[RePlacerConfig.placeDir.method_10166().ordinal()] = 0.0;
            faceDir = class_2350.method_58251((class_243)new class_243(v1[0], v1[1], v1[2]).method_1029());
            tempBuild = new HashSet<RelPos>();
            RelPos.setBase(pos);
            disp = true;
        }
        RelPos rel = new RelPos(pos);
        boolean[] containerCheck = new boolean[]{true};
        tempBuild.forEach(r -> {
            if (r.equals(rel)) {
                containerCheck[0] = false;
            }
        });
        if (containerCheck[0]) {
            tempBuild.add(rel);
        }
        return disp;
    }

    public static void buildRemover(class_2338 pos) {
        RelPos r = new RelPos(pos);
        if (r.equals(RelPos.ORIGIN)) {
            return;
        }
        tempBuild.removeIf(rel -> rel.equals(r));
    }

    static boolean isValidTail(String tail) {
        if (!tail.trim().equals(tail)) {
            return false;
        }
        if ((tail = tail.toLowerCase()).isEmpty() || tail.length() > REGEX.length() - 2) {
            return false;
        }
        if (!tail.toLowerCase().replaceAll(REGEX, "").replaceAll(REGEXNUM, "").isEmpty()) {
            return false;
        }
        if ((tail = tail.toLowerCase().replaceAll(REGEXNUM, "")).length() <= 1) {
            return true;
        }
        if (tail.toLowerCase().replaceAll(SNAP, "").isEmpty()) {
            return false;
        }
        if (tail.toLowerCase().replaceAll(SPIN, "").isEmpty()) {
            return false;
        }
        if (tail.toLowerCase().replaceAll(NO, "").isEmpty()) {
            return false;
        }
        return !tail.toLowerCase().replaceAll(DIS, "").isEmpty();
    }

    static boolean hasTail(String build) {
        if (build == null) {
            return false;
        }
        if (!build.contains(DIV)) {
            return false;
        }
        if (RePlacerConfig.tail(build).isEmpty()) {
            return true;
        }
        return RePlacerConfig.isValidTail(RePlacerConfig.tail(build));
    }

    static String tail(String build) {
        String tail;
        switch (tail = build.substring(build.indexOf(DIV) + 2).trim().toLowerCase()) {
            case "nn": {
                return NO;
            }
            case "ss": {
                return SPIN;
            }
            case "ff": {
                return SNAP;
            }
        }
        if (RePlacerConfig.isValidTail(tail)) {
            return tail;
        }
        return "";
    }

    public static String tailless(String build) {
        if (RePlacerConfig.isInclTail() || !RePlacerConfig.hasTail(build)) {
            return build;
        }
        return RePlacerConfig.removeTail(build);
    }

    static String removeTail(String build) {
        if (!RePlacerConfig.hasTail(build)) {
            return build;
        }
        return build.substring(0, build.indexOf(DIV));
    }

    static int parseAccess(String name) {
        if (!RePlacerConfig.hasTail(name) || !RePlacerConfig.isValidTail(RePlacerConfig.tail(name))) {
            return -1;
        }
        String remainder = RePlacerConfig.tail(name).toLowerCase().replaceAll(REGEX, "");
        if (remainder.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(remainder);
    }

    public static boolean hasQuickAccess(int slot) {
        return quickAccess.containsKey(slot);
    }

    public static String getQuickAccessName() {
        return quickAccess.get(RePlacerClient.getQuickAccess());
    }

    public static boolean setReCording(boolean val) {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        boolean bl = reCording;
        reCording = val;
        return bl;
    }

    public static boolean isReCording() {
        if (class_310.method_1551().field_1724 == null) {
            return false;
        }
        return reCording;
    }

    private static boolean getRelevantName(MutableObject<String> holder) {
        String name;
        if (names.isEmpty()) {
            return true;
        }
        try {
            name = RePlacerClient.isQuickAccess() ? RePlacerConfig.getQuickAccessName() : names.get(selection);
        }
        catch (IndexOutOfBoundsException e) {
            if (!RePlacerConfig.getDefBuild().isEmpty()) {
                selection = names.indexOf(RePlacerConfig.getDefBuild());
                name = RePlacerConfig.getDefBuild();
            }
            selection = 0;
            name = names.getFirst();
        }
        holder.setValue((Object)name);
        return false;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static BuildHolder buildDefault() {
        return new BuildHolder(class_2350.field_11036, class_2350.field_11043, new RelPos(0, 0, 0), new RelPos(0, 0, 1), new RelPos(0, 0, -1), new RelPos(1, 0, 0), new RelPos(1, 0, 1), new RelPos(1, 0, -1), new RelPos(-1, 0, 0), new RelPos(-1, 0, 1), new RelPos(-1, 0, -1));
    }

    static CellErrorSupplier getCellErrorSupplier() {
        return new CellErrorSupplier();
    }

    public static Color getBorderColor() {
        return RePlacerConfig.getInstance().borderColor;
    }

    public static void setBorderColor(Color borderColor) {
        RePlacerConfig.getInstance().borderColor = borderColor;
    }

    public static Color getTransparentBorderColor() {
        return RePlacerConfig.getInstance().transparentBorderColor;
    }

    public static void setTransparentBorderColor(Color transparentBorderColor) {
        RePlacerConfig.getInstance().transparentBorderColor = transparentBorderColor;
    }

    public static Color getExcludedColor() {
        return RePlacerConfig.getInstance().excludedColor;
    }

    public static void setExcludedColor(Color excludedColor) {
        RePlacerConfig.getInstance().excludedColor = excludedColor;
    }

    public static Color getTransparentExcludedColor() {
        return RePlacerConfig.getInstance().transparentExcludedColor;
    }

    public static void setTransparentExcludedColor(Color transparentExcludedColor) {
        RePlacerConfig.getInstance().transparentExcludedColor = transparentExcludedColor;
    }

    static DefaultErrorSupplier getDefaultErrorSupplier() {
        return new DefaultErrorSupplier();
    }

    static NameErrorSupplier getNameErrorSupplier() {
        return new NameErrorSupplier();
    }

    static BoolErrorSupplier getBoolErrorSupplier() {
        return new BoolErrorSupplier();
    }

    static NamesErrorSupplier getNamesErrorSupplier() {
        return new NamesErrorSupplier();
    }

    static DisabledErrorSupplier getDisabledErrorSupplier() {
        return new DisabledErrorSupplier();
    }

    static RatErrorSupplier getRatErrorSupplier() {
        return new RatErrorSupplier();
    }

    static {
        selection = 0;
        reCording = false;
        isHollow = false;
        deny = false;
        quickAccess = new HashMap<Integer, String>();
        defaultColors = new Color[]{Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f), Color.ofRGBA((int)10, (int)206, (int)245, (int)180), Color.ofRGBA((float)5.0f, (float)0.5f, (float)0.5f, (float)1.0f), Color.ofRGBA((int)206, (int)100, (int)100, (int)180)};
        listSideCombinedErrorChecker = null;
        boolSideCombinedErrorChecker = null;
        namesSideInts = new HashSet<Integer>();
        disabledSideInts = new HashSet<Integer>();
    }

    private static class CellErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private CellErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if ((entry = entry.toLowerCase()).indexOf(RePlacerConfig.DIV) != entry.lastIndexOf(RePlacerConfig.DIV)) {
                return Optional.of(class_2561.method_43470((String)"You cannot have more than one modifier tail! error code: 0"));
            }
            if (!RePlacerConfig.hasTail(entry) || RePlacerConfig.isValidTail(RePlacerConfig.tail(entry))) {
                return Optional.empty();
            }
            if (RePlacerConfig.tail(entry).isEmpty()) {
                return Optional.of(class_2561.method_43470((String)"Tail is empty! error code: 1"));
            }
            return Optional.of(class_2561.method_43470((String)("Illegal characters:" + entry.replaceFirst(RePlacerConfig.SPIN, "").replaceFirst(RePlacerConfig.SNAP, "").replaceFirst(RePlacerConfig.NO, "").replaceFirst(RePlacerConfig.REGEXNUM, "") + " error code: 2")));
        }
    }

    private static class DefaultErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private DefaultErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if (entry.isEmpty()) {
                return Optional.empty();
            }
            if (RePlacerConfig.hasTail(entry)) {
                return Optional.of(class_2561.method_43470((String)"Enter tailless version! error code: 8"));
            }
            if (!RePlacerConfig.getTaillessNames().contains(entry)) {
                return Optional.of(class_2561.method_43470((String)"Build does not exist! error code: 9"));
            }
            return Optional.empty();
        }
    }

    private static class NameErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private NameErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            if (!RePlacerConfig.hasTail(entry) || RePlacerConfig.isValidTail(RePlacerConfig.tail(entry))) {
                if (RePlacerConfig.getTaillessNames().contains(RePlacerConfig.removeTail(entry))) {
                    return Optional.of(class_2561.method_43470((String)"Duplicate name! error code: 6"));
                }
                if (RePlacerConfig.hasQuickAccess(RePlacerConfig.parseAccess(entry))) {
                    return Optional.of(class_2561.method_43470((String)"Duplicate quick access value! error code: 13"));
                }
                return Optional.empty();
            }
            if (RePlacerConfig.tail(entry).isEmpty()) {
                return Optional.of(class_2561.method_43470((String)"Cannot have empty tail! error code: 12"));
            }
            return Optional.of(class_2561.method_43470((String)("Illegal characters in tail:" + RePlacerConfig.tail(entry).toLowerCase().replaceFirst(RePlacerConfig.SPIN, "").replaceFirst(RePlacerConfig.SNAP, "").replaceFirst(RePlacerConfig.NO, "").replaceFirst(RePlacerConfig.DIS, "").replaceFirst(RePlacerConfig.REGEXNUM, "") + " error code: 7")));
        }
    }

    private static class BoolErrorSupplier
    implements Function<Boolean, Optional<class_2561>> {
        private BoolErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(Boolean entry) {
            boolSideCombinedErrorChecker = false;
            if (entry.booleanValue() && listSideCombinedErrorChecker.booleanValue()) {
                return Optional.of(class_2561.method_43470((String)"Can't turn this on if all your builds are quickaccess! error code: 10"));
            }
            return Optional.empty();
        }
    }

    private static class NamesErrorSupplier
    implements Function<List<String>, Optional<class_2561>> {
        private NamesErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(List<String> entry) {
            listSideCombinedErrorChecker = false;
            namesSideInts.clear();
            if (entry.isEmpty()) {
                return Optional.empty();
            }
            HashSet<String> taillessNames = new HashSet<String>(RePlacerConfig.getTaillessNames());
            HashSet<String> names = new HashSet<String>();
            int disabled = 0;
            for (String build : entry) {
                if (build.equals("square") || RePlacerConfig.hasTail(build) && RePlacerConfig.removeTail(build).equals("square")) continue;
                String tailless = RePlacerConfig.removeTail(build);
                if (names.contains(tailless)) {
                    return Optional.of(class_2561.method_43470((String)("Duplicate build name: " + tailless + "! error code: 3")));
                }
                if (!taillessNames.contains(tailless) && !JsonConfigHelper.isCachedBuild(build)) {
                    return Optional.of(class_2561.method_43470((String)"You cannot add builds or change their names here! error code: 4"));
                }
                names.add(tailless);
                if (!RePlacerConfig.hasTail(build)) continue;
                String tail = RePlacerConfig.tail(build);
                if (tail.contains(RePlacerConfig.DIS) && ++disabled >= entry.size()) {
                    return Optional.of(class_2561.method_43470((String)"You may not disable all builds! error code: 14"));
                }
                if (tail.toLowerCase().replaceAll(RePlacerConfig.REGEX, "").isEmpty()) continue;
                int i = Integer.parseInt(tail.toLowerCase().replaceAll(RePlacerConfig.REGEX, ""));
                if (disabledSideInts.contains(i)) {
                    return Optional.of(class_2561.method_43470((String)(i + "can only be bound to one build! error code: 20")));
                }
                if (!namesSideInts.add(i)) {
                    return Optional.of(class_2561.method_43470((String)(i + "can only be bound to one build! error code: 5")));
                }
                if (namesSideInts.size() != entry.size()) continue;
                if (boolSideCombinedErrorChecker.booleanValue()) {
                    return Optional.of(class_2561.method_43470((String)"Cannot remove all builds from cycling! error code: 11"));
                }
                listSideCombinedErrorChecker = true;
            }
            return Optional.empty();
        }
    }

    private static class DisabledErrorSupplier
    implements Function<List<String>, Optional<class_2561>> {
        private DisabledErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(List<String> entry) {
            if (entry.isEmpty()) {
                return Optional.empty();
            }
            disabledSideInts.clear();
            HashSet<String> dis = new HashSet<String>(RePlacerConfig.getTaillessDisabled());
            HashSet<String> names = new HashSet<String>();
            for (String build : entry) {
                String tail;
                if (build.equals("square") || RePlacerConfig.hasTail(build) && RePlacerConfig.removeTail(build).equals("square")) continue;
                String tailless = RePlacerConfig.removeTail(build);
                if (names.contains(tailless)) {
                    return Optional.of(class_2561.method_43470((String)("Duplicate disabled build name: " + tailless + "! error code: 17")));
                }
                if (!dis.contains(tailless) && !JsonConfigHelper.isCachedBuild(build)) {
                    return Optional.of(class_2561.method_43470((String)"You cannot add builds or change their names here! error code: 16"));
                }
                names.add(tailless);
                if (!RePlacerConfig.hasTail(build) || (tail = RePlacerConfig.tail(build)).toLowerCase().replaceAll(RePlacerConfig.REGEX, "").isEmpty()) continue;
                int i = Integer.parseInt(tail.toLowerCase().replaceAll(RePlacerConfig.REGEX, ""));
                if (namesSideInts.contains(i)) {
                    return Optional.of(class_2561.method_43470((String)(i + "can only be bound to one build! error code: 18")));
                }
                if (disabledSideInts.add(i)) continue;
                return Optional.of(class_2561.method_43470((String)(i + "can only be bound to one build! error code: 19")));
            }
            return Optional.empty();
        }
    }

    private static class RatErrorSupplier
    implements Function<String, Optional<class_2561>> {
        private RatErrorSupplier() {
        }

        @Override
        public Optional<class_2561> apply(String entry) {
            String ticks;
            String blocks;
            if (!entry.contains(RePlacerConfig.RAT) && !entry.contains(RePlacerConfig.RAT2)) {
                return Optional.of(class_2561.method_43470((String)"Ratio must contain :or/ between two ints! error code: 21"));
            }
            if (entry.contains(RePlacerConfig.RAT)) {
                blocks = entry.substring(0, entry.indexOf(RePlacerConfig.RAT));
                ticks = entry.substring(entry.indexOf(RePlacerConfig.RAT) + 1);
            } else {
                blocks = entry.substring(0, entry.indexOf(RePlacerConfig.RAT2));
                ticks = entry.substring(entry.indexOf(RePlacerConfig.RAT2) + 1);
            }
            try {
                if (Integer.parseInt(blocks) <= 0) {
                    return Optional.of(class_2561.method_43470((String)(blocks + " must be greater than 0! error code: 24")));
                }
            }
            catch (NumberFormatException e) {
                return Optional.of(class_2561.method_43470((String)(blocks + " must be an int! error code: 22")));
            }
            try {
                if (Integer.parseInt(ticks) <= 0) {
                    return Optional.of(class_2561.method_43470((String)(ticks + " must be greater than 0! error code: 25")));
                }
            }
            catch (NumberFormatException e) {
                return Optional.of(class_2561.method_43470((String)(ticks + " must be an int! error code: 23")));
            }
            return Optional.empty();
        }
    }
}

