/*
 * Decompiled with CFR 0.152.
 */
package eva.replacer.util;

import eva.replacer.config.RePlacerConfig;
import eva.replacer.config.SortOrder;
import eva.replacer.util.RelPos;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BuildHolder(class_2350 firstDir, @Nullable class_2350 faceDir, int[] x, int[] y, int[] z) {
    private static class_2350 baseDir;
    private static class_2350 facing;

    private BuildHolder(class_2350 firstDir, class_2350 faceDir, int @NotNull [][] tri) {
        this(firstDir, faceDir, tri[0], tri[1], tri[2]);
    }

    public BuildHolder(class_2350 firstDir, class_2350 faceDir, RelPos ... posList) {
        this(firstDir, faceDir, BuildHolder.split(BuildHolder.sort(posList)));
    }

    public static void setBaseDir(class_2350 baseDir) {
        BuildHolder.baseDir = baseDir;
    }

    public static void setFacing(@NotNull class_243 v0, @NotNull class_2350 placeFace) {
        try {
            double[] v1 = new double[]{v0.field_1352, v0.field_1351, v0.field_1350};
            if (!RePlacerConfig.isSnap()) {
                v1[placeFace.method_10166().ordinal()] = 0.0;
            } else {
                v1[RePlacerConfig.handleGetBuild().firstDir().method_10166().ordinal()] = 0.0;
            }
            facing = class_2350.method_58251((class_243)new class_243(v1[0], v1[1], v1[2]).method_1029());
        }
        catch (NullPointerException e) {
            facing = class_2350.method_58251((class_243)v0);
        }
    }

    RelPos snap(RelPos pos) {
        if (!RePlacerConfig.isSnap() || this.firstDir == baseDir) {
            return pos;
        }
        if (this.firstDir().method_10166() == baseDir.method_10166()) {
            int[] vals = new int[]{pos.vals()[0], pos.vals()[1], pos.vals()[2]};
            int n = this.firstDir().method_10166().ordinal();
            vals[n] = vals[n] * -1;
            return new RelPos(vals);
        }
        int[] ind = new int[]{this.firstDir().method_10166().ordinal(), baseDir.method_10166().ordinal()};
        int[] neg = this.firstDir().method_10171() != baseDir.method_10171() ? new int[]{-1, 1} : new int[]{1, -1};
        int[] vals = new int[3];
        vals[ind[0]] = pos.vals()[ind[1]] * neg[1];
        vals[ind[1]] = pos.vals()[ind[0]] * neg[0];
        vals[3 - ind[0] - ind[1]] = pos.vals()[3 - ind[0] - ind[1]];
        return new RelPos(vals);
    }

    RelPos spin(RelPos pos) {
        if (!RePlacerConfig.isSpin() || this.faceDir == null) {
            return pos;
        }
        class_2350 tempDir = this.rot();
        if (facing == tempDir) {
            return pos;
        }
        assert (tempDir != null);
        if (facing.method_10166() == tempDir.method_10166()) {
            int[] vals = new int[3];
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                vals[0] = pos.vals()[0];
                vals[1] = -pos.vals()[1];
                vals[2] = pos.vals()[2];
            } else if (facing.method_10166() == class_2350.class_2351.field_11048) {
                vals[0] = -pos.vals()[0];
                vals[1] = pos.vals()[1];
                vals[2] = pos.vals()[2];
            } else {
                vals[0] = pos.vals()[0];
                vals[1] = pos.vals()[1];
                vals[2] = -pos.vals()[2];
            }
            return new RelPos(vals);
        }
        class_2350.class_2351 ax = class_2350.class_2351.values()[3 - tempDir.method_10166().ordinal() - facing.method_10166().ordinal()];
        if (tempDir.method_35833(ax) == facing) {
            if (ax == class_2350.class_2351.field_11052) {
                return new RelPos(-pos.vals()[2], pos.vals()[1], pos.vals()[0]);
            }
            if (ax == class_2350.class_2351.field_11048) {
                return new RelPos(pos.vals()[0], -pos.vals()[2], -pos.vals()[1]);
            }
            return new RelPos(pos.vals()[1], pos.vals()[0], pos.vals()[2]);
        }
        if (ax == class_2350.class_2351.field_11052) {
            return new RelPos(pos.vals()[2], pos.vals()[1], -pos.vals()[0]);
        }
        if (ax == class_2350.class_2351.field_11048) {
            return new RelPos(pos.vals()[0], pos.vals()[2], pos.vals()[1]);
        }
        return new RelPos(-pos.vals()[1], -pos.vals()[0], pos.vals()[2]);
    }

    public void rotateEach(Consumer<RelPos> action) {
        for (int i = 0; i < this.x.length; ++i) {
            RelPos pos = this.pos(i);
            if (!RePlacerConfig.isSnap() && !RePlacerConfig.isSpin()) {
                action.accept(pos);
                continue;
            }
            action.accept(this.spin(this.snap(pos)));
        }
    }

    public void forEach(Consumer<RelPos> action) {
        for (int i = 0; i < this.x.length; ++i) {
            action.accept(this.pos(i));
        }
    }

    private RelPos pos(int i) {
        return new RelPos(this.x[i], this.y[i], this.z[i]);
    }

    @Nullable
    private class_2350 rot() {
        if (this.faceDir == null) {
            return null;
        }
        try {
            if (this.firstDir.method_10166().equals((Object)baseDir.method_10166())) {
                return this.faceDir;
            }
            class_2350.class_2351 ax = class_2350.class_2351.values()[3 - this.firstDir.method_10166().ordinal() - baseDir.method_10166().ordinal()];
            if (this.firstDir.method_10166() == class_2350.class_2351.field_11052 && this.faceDir.method_10166() != baseDir.method_10166()) {
                if (facing.method_10166() == class_2350.class_2351.field_11052) {
                    return this.faceDir.method_10153();
                }
                if (this.firstDir.method_35833(ax) == baseDir) {
                    return this.faceDir.method_35834(ax);
                }
                return this.faceDir.method_35833(ax);
            }
            if (this.firstDir.method_35834(ax) == baseDir) {
                return this.faceDir.method_35834(ax);
            }
            return this.faceDir.method_35833(ax);
        }
        catch (NullPointerException e) {
            return this.faceDir;
        }
    }

    private static RelPos[] sort(RelPos[] posList) {
        Arrays.sort(posList, Comparator.comparingDouble(RelPos::dist));
        return posList;
    }

    private static int @NotNull [][] split(RelPos @NotNull [] posList) {
        int[][] ret = new int[3][posList.length];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < posList.length; ++j) {
                ret[i][j] = posList[j].vals()[i];
            }
        }
        return ret;
    }

    public RelPos @NotNull [] posList() {
        this.thrower();
        RelPos[] posList = new RelPos[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            posList[i] = new RelPos(this.x[i], this.y[i], this.z[i]);
        }
        return posList;
    }

    @NotNull
    public BuildHolder handleSort(class_1657 player) {
        return switch (RePlacerConfig.getSortOrder()) {
            default -> throw new MatchException(null, null);
            case SortOrder.Near_block_first, SortOrder.Near_block_last -> this.sort();
            case SortOrder.Near_player_first, SortOrder.Near_player_last -> this.sort(player);
            case SortOrder.Top_down, SortOrder.Bottom_up -> this.vert();
            case SortOrder.Random -> this.random();
        };
    }

    private BuildHolder sort() {
        int i;
        this.thrower();
        RelPos[] posList = BuildHolder.sort(this.posList());
        if (RePlacerConfig.getSortOrder().equals((Object)SortOrder.Near_block_first)) {
            for (i = 0; i < posList.length; ++i) {
                this.x[i] = posList[i].vals()[0];
                this.y[i] = posList[i].vals()[1];
                this.z[i] = posList[i].vals()[2];
            }
        }
        if (RePlacerConfig.getSortOrder().equals((Object)SortOrder.Near_block_last)) {
            for (i = 0; i < posList.length; ++i) {
                this.x[i] = posList[posList.length - i - 1].vals()[0];
                this.y[i] = posList[posList.length - i - 1].vals()[1];
                this.z[i] = posList[posList.length - i - 1].vals()[2];
            }
        }
        return this;
    }

    private BuildHolder sort(class_1657 player) {
        int i;
        this.thrower();
        RelPos[] posList = this.posList();
        class_243 v = player.method_33571();
        Arrays.sort(posList, Comparator.comparingDouble(pos -> pos.dist(v)));
        if (RePlacerConfig.getSortOrder().equals((Object)SortOrder.Near_player_first)) {
            for (i = 0; i < posList.length; ++i) {
                this.x[i] = posList[i].vals()[0];
                this.y[i] = posList[i].vals()[1];
                this.z[i] = posList[i].vals()[2];
            }
        }
        if (RePlacerConfig.getSortOrder().equals((Object)SortOrder.Near_player_last)) {
            for (i = 0; i < posList.length; ++i) {
                this.x[i] = posList[posList.length - i - 1].vals()[0];
                this.y[i] = posList[posList.length - i - 1].vals()[1];
                this.z[i] = posList[posList.length - i - 1].vals()[2];
            }
        }
        return this;
    }

    private BuildHolder random() {
        this.thrower();
        RelPos[] posList = this.posList();
        Collections.shuffle(Arrays.asList(posList));
        for (int i = 0; i < posList.length; ++i) {
            this.x[i] = posList[i].vals()[0];
            this.y[i] = posList[i].vals()[1];
            this.z[i] = posList[i].vals()[2];
        }
        return this;
    }

    private BuildHolder vert() {
        int i;
        this.thrower();
        RelPos[] posList = this.posList();
        Arrays.sort(posList, Comparator.comparingInt(pos -> pos.vals()[1]));
        if (RePlacerConfig.getSortOrder().equals((Object)SortOrder.Bottom_up)) {
            for (i = 0; i < posList.length; ++i) {
                this.x[i] = posList[i].vals()[0];
                this.y[i] = posList[i].vals()[1];
                this.z[i] = posList[i].vals()[2];
            }
        }
        if (RePlacerConfig.getSortOrder().equals((Object)SortOrder.Top_down)) {
            for (i = posList.length - 1; i >= 0; --i) {
                this.x[i] = posList[posList.length - i - 1].vals()[0];
                this.y[i] = posList[posList.length - i - 1].vals()[1];
                this.z[i] = posList[posList.length - i - 1].vals()[2];
            }
        }
        return this;
    }

    private void thrower() {
        if (this.x.length != this.y.length || this.z.length != this.x.length) {
            throw new IllegalArgumentException();
        }
    }

    public boolean containsOrigin() {
        for (RelPos pos : this.posList()) {
            if (!pos.equals(RelPos.ORIGIN)) continue;
            return true;
        }
        return false;
    }

    static void clear() {
        baseDir = null;
        facing = null;
    }
}

